/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.abilities.BaseDurationAbility;
import com.fs.starfarer.api.impl.campaign.intel.misc.RemoteSurveyDataForPlanetIntel;
import com.fs.starfarer.api.plugins.SurveyPlugin;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class RemoteSurveyAbility
extends BaseDurationAbility {
    public static final String ALREADY_DID_IN_SYSTEM = "$core_didRemoteSurveyInSystem";
    public static final float SURVEY_RANGE = 10000.0f;
    public static final float DETECTABILITY_RANGE_BONUS = 5000.0f;
    public static final float ACCELERATION_MULT = 4.0f;
    protected boolean performed = false;

    @Override
    protected void activateImpl() {
        if (this.entity.isInCurrentLocation()) {
            SectorEntityToken.VisibilityLevel level = this.entity.getVisibilityLevelToPlayerFleet();
            if (level != SectorEntityToken.VisibilityLevel.NONE) {
                Global.getSector().addPing(this.entity, "remote_survey");
            }
            this.performed = false;
        }
    }

    @Override
    protected void applyEffect(float amount, float level) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getFleetwideMaxBurnMod().modifyMult(this.getModId(), 0.0f, "Remote survey");
        fleet.getStats().getDetectedRangeMod().modifyFlat(this.getModId(), 5000.0f * level, "Remote survey");
        fleet.getStats().getAccelerationMult().modifyMult(this.getModId(), 1.0f + 3.0f * level);
        if (!this.performed && level >= 1.0f) {
            PlanetAPI planet = this.findBestPlanet();
            if (planet != null && planet.getMarket() != null) {
                MarketAPI market = planet.getMarket();
                market.setSurveyLevel(MarketAPI.SurveyLevel.PRELIMINARY);
                new RemoteSurveyDataForPlanetIntel(planet);
                if (planet.getStarSystem() != null) {
                    planet.getStarSystem().getMemoryWithoutUpdate().set(ALREADY_DID_IN_SYSTEM, true);
                }
            }
            this.performed = true;
        }
    }

    @Override
    public boolean isUsable() {
        if (!super.isUsable()) {
            return false;
        }
        if (this.getFleet() == null) {
            return false;
        }
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet.isInHyperspace() || fleet.isInHyperspaceTransition()) {
            return false;
        }
        return this.findBestPlanet() != null;
    }

    public PlanetAPI findBestPlanet() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null || fleet.isInHyperspace() || fleet.getStarSystem() == null) {
            return null;
        }
        StarSystemAPI system = fleet.getStarSystem();
        if (system.getMemoryWithoutUpdate().contains(ALREADY_DID_IN_SYSTEM)) {
            return null;
        }
        SurveyPlugin plugin = (SurveyPlugin)Global.getSettings().getNewPluginInstance("surveyPlugin");
        int bestScore = 0;
        PlanetAPI best = null;
        for (PlanetAPI planet : system.getPlanets()) {
            int score;
            MarketAPI.SurveyLevel level;
            if (planet.isStar() || planet.getMarket() == null || (level = planet.getMarket().getSurveyLevel()) == MarketAPI.SurveyLevel.FULL || (score = plugin.getSurveyDataScore(planet)) <= bestScore) continue;
            bestScore = score;
            best = planet;
        }
        return best;
    }

    @Override
    protected void deactivateImpl() {
        this.cleanupImpl();
    }

    @Override
    protected void cleanupImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        fleet.getStats().getDetectedRangeMod().unmodify(this.getModId());
        fleet.getStats().getFleetwideMaxBurnMod().unmodify(this.getModId());
        fleet.getStats().getAccelerationMult().unmodify(this.getModId());
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        PlanetAPI planet;
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        if (!Global.CODEX_TOOLTIP_MODE) {
            LabelAPI labelAPI = tooltip.addTitle(this.spec.getName());
        } else {
            tooltip.addSpacer(-10.0f);
        }
        float pad = 10.0f;
        tooltip.addPara("Coordinate the fleet's active sensor network to scan all the planets in the system and identify the most promising candidate for a full survey operation.", pad, highlight, "10000");
        tooltip.addPara("Increases the range at which the fleet can be detected by %s* units and brings the fleet to a near-stop as drives are powered down to reduce interference.", pad, highlight, "5000");
        if (!Global.CODEX_TOOLTIP_MODE && (planet = this.findBestPlanet()) == null) {
            if (fleet.isInHyperspace()) {
                tooltip.addPara("Can not be used in hyperspace.", bad, pad);
            } else if (fleet.getStarSystem() != null && fleet.getStarSystem().getMemoryWithoutUpdate().contains(ALREADY_DID_IN_SYSTEM)) {
                tooltip.addPara("Remote survey already performed in this star system.", bad, pad);
            } else {
                tooltip.addPara("No suitable planets in the star system.", bad, pad);
            }
        }
        tooltip.addPara("*2000 units = 1 map grid cell", gray, pad);
        this.addIncompatibleToTooltip(tooltip, expanded);
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }
}

