/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.fleet.FleetMemberViewAPI;
import com.fs.starfarer.api.impl.campaign.abilities.ToggleAbilityWithCost;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class ReversePolarityToggle
extends ToggleAbilityWithCost {
    public static String REVERSED_POLARITY = "$reversedPolarity";
    public static String POLARITY_SPEED_MULT = "$polaritySpeedMult";
    public static String POLARITY_WIND_GLOW_COLOR_KEY = "$polarityWindGlowColor";
    public static Color POLARITY_WIND_GLOW_COLOR = new Color(1.0f, 0.25f, 1.0f, 0.75f);
    public static float SLIPSTREAM_SPEED_MULT = 0.75f;
    public static float CR_COST_MULT = 0.25f;
    public static float FUEL_COST_MULT = 1.0f;
    public static float ACTIVATION_DAMAGE_PROB = 0.33f;

    @Override
    public float getFuelCostMult(boolean forTooltip) {
        if (!forTooltip && !this.isFleetInSlipstream()) {
            return 0.0f;
        }
        return FUEL_COST_MULT;
    }

    @Override
    public float getCRCostMult(boolean forTooltip) {
        if (!forTooltip && !this.isFleetInSlipstream()) {
            return 0.0f;
        }
        return CR_COST_MULT;
    }

    @Override
    public boolean canRecoverCRWhileActive(boolean forTooltip) {
        return true;
    }

    @Override
    protected String getActivationText() {
        return "Drive field polarity reversed";
    }

    @Override
    public boolean isUsable() {
        if (!super.isUsable()) {
            return false;
        }
        if (this.getFleet() == null) {
            return false;
        }
        CampaignFleetAPI fleet = this.getFleet();
        return fleet.isInHyperspace();
    }

    @Override
    protected void applyStatsEffect(float amount, float level) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        if (fleet.getContainingLocation() == null || !fleet.getContainingLocation().isHyperspace()) {
            this.deactivate();
            return;
        }
        if (level >= 1.0f && this.turnedOn) {
            fleet.getMemoryWithoutUpdate().set(REVERSED_POLARITY, true, this.getDeactivationDays());
            float speedMult = SLIPSTREAM_SPEED_MULT;
            fleet.getMemoryWithoutUpdate().set(POLARITY_SPEED_MULT, Float.valueOf(speedMult), this.getDeactivationDays());
            fleet.getMemoryWithoutUpdate().set(POLARITY_WIND_GLOW_COLOR_KEY, POLARITY_WIND_GLOW_COLOR, this.getDeactivationDays());
        }
        if (level <= 0.0f) {
            this.cleanupImpl();
        }
    }

    @Override
    protected void applyFleetVisual(float amount, float level) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        Color c = new Color(255, 0, 255, 255);
        Color cDim = new Color(255, 0, 255, 50);
        Color cDim2 = new Color(255, 0, 255, 120);
        for (FleetMemberViewAPI view : fleet.getViews()) {
            view.getContrailColor().shift(this.getModId(), cDim2, 1.0f, 1.0f, 0.75f);
            view.getEngineGlowColor().shift(this.getModId(), cDim, 1.0f, 1.0f, 0.5f);
            view.getEngineGlowSizeMult().shift(this.getModId(), 3.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public boolean isFleetInSlipstream() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return false;
        }
        return Misc.isInsideSlipstream(fleet);
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        String status = " (off)";
        if (this.turnedOn) {
            status = " (on)";
        }
        if (!Global.CODEX_TOOLTIP_MODE) {
            LabelAPI title = tooltip.addTitle("Reverse Polarity" + status);
            title.highlightLast(status);
            title.setHighlightColor(gray);
        } else {
            tooltip.addSpacer(-10.0f);
        }
        float pad = 10.0f;
        tooltip.addPara("Reverse the polarity of the drive field, causing the fleet to travel against the current of slipstreams.", pad);
        if (SLIPSTREAM_SPEED_MULT != 1.0f) {
            tooltip.addPara("Going against the current is less efficient and results in the slipstream current's effect being reduced by %s.", pad, highlight, Math.round(100.0f * (1.0f - SLIPSTREAM_SPEED_MULT)) + "%");
        }
        tooltip.addPara("When used outside a slipstream, incurs no cost, penalty, or risk of ship damage.", pad);
        tooltip.addSectionHeading("Use inside slipstreams", Alignment.MID, pad);
        this.addCostTooltipSection(tooltip, expanded, "An emergency maneuver when performed inside a slipstream, reversing drive field polarity");
        this.addIncompatibleToTooltip(tooltip, expanded);
    }

    @Override
    public void addOtherNotUsableReason(TooltipMakerAPI tooltip, boolean expanded) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
        Color bad = Misc.getNegativeHighlightColor();
        if (!fleet.isInHyperspace()) {
            tooltip.addPara("Can only be used in hyperspace.", bad, 10.0f);
        }
    }

    @Override
    protected boolean showAlarm() {
        if (!this.isFleetInSlipstream()) {
            return false;
        }
        return super.showAlarm() || this.isFleetInSlipstream();
    }

    @Override
    public Color getCooldownColor() {
        if (this.showAlarm()) {
            Color color = Misc.getNegativeHighlightColor();
            if (!super.showAlarm()) {
                color = Misc.getHighlightColor();
            }
            return Misc.scaleAlpha(color, Global.getSector().getCampaignUI().getSharedFader().getBrightness() * 0.5f);
        }
        return super.getCooldownColor();
    }
}

