/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.RuleBasedInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.abilities.BaseDurationAbility;
import com.fs.starfarer.api.impl.campaign.procgen.SalvageEntityGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.themes.SalvageEntityGeneratorOld;
import com.fs.starfarer.api.impl.campaign.terrain.DebrisFieldTerrainPlugin;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.ReadableVector2f;

public class ScavengeAbility
extends BaseDurationAbility {
    private IntervalUtil interval = null;

    @Override
    protected String getActivationText() {
        return "Scavenging";
    }

    @Override
    protected void activateImpl() {
        if (this.entity.isPlayerFleet()) {
            CampaignFleetAPI fleet = this.getFleet();
            DebrisFieldTerrainPlugin debris = this.getDebrisField();
            if (debris != null) {
                CustomCampaignEntityAPI target = debris.getEntity().getContainingLocation().addCustomEntity(null, null, "debris_field_shared", debris.getEntity().getFaction().getId());
                debris.getEntity().getContainingLocation().removeEntity(target);
                target.getLocation().set((ReadableVector2f)debris.getEntity().getLocation());
                MemoryAPI debrisMemory = debris.getEntity().getMemory();
                debrisMemory.set("$salvageDebrisField", debris, 0.0f);
                target.setMemory(debrisMemory);
                SalvageEntityGenDataSpec spec = SalvageEntityGeneratorOld.getSalvageSpec(target.getCustomEntityType());
                spec.getDropValue().clear();
                spec.getDropRandom().clear();
                spec.getDropValue().addAll(debris.getEntity().getDropValue());
                spec.getDropRandom().addAll(debris.getEntity().getDropRandom());
                spec.setProbDefenders(debris.getParams().defenderProb * debris.getParams().density);
                spec.setMinStr((float)debris.getParams().minStr * debris.getParams().density);
                spec.setMaxStr((float)debris.getParams().maxStr * debris.getParams().density);
                spec.setMaxDefenderSize(debris.getParams().maxDefenderSize);
                spec.setDefFaction(debris.getParams().defFaction);
                float xp = (float)debris.getParams().baseSalvageXP * debris.getParams().density;
                spec.setXpSalvage(xp);
                Global.getSector().getCampaignUI().showInteractionDialog(new RuleBasedInteractionDialogPluginImpl(), target);
            }
        }
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        if (this.interval != null && this.getFleet() != null && this.getFleet().isPlayerFleet()) {
            float days = Global.getSector().getClock().convertToDays(amount);
            this.interval.advance(days);
            this.interval.intervalElapsed();
        }
    }

    @Override
    protected void applyEffect(float amount, float level) {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
    }

    @Override
    protected void deactivateImpl() {
        this.cleanupImpl();
    }

    @Override
    protected void cleanupImpl() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return;
        }
    }

    @Override
    public boolean isUsable() {
        DebrisFieldTerrainPlugin debris = this.getDebrisField();
        if (debris == null || debris.isScavenged()) {
            return false;
        }
        return super.isUsable();
    }

    protected DebrisFieldTerrainPlugin getDebrisField() {
        CampaignFleetAPI fleet = this.getFleet();
        if (fleet == null) {
            return null;
        }
        DebrisFieldTerrainPlugin scavenged = null;
        DebrisFieldTerrainPlugin usable = null;
        for (CampaignTerrainAPI curr : fleet.getContainingLocation().getTerrainCopy()) {
            DebrisFieldTerrainPlugin debris;
            if (!(curr.getPlugin() instanceof DebrisFieldTerrainPlugin) || !(debris = (DebrisFieldTerrainPlugin)curr.getPlugin()).containsEntity(fleet)) continue;
            if (debris.isScavenged()) {
                scavenged = debris;
                continue;
            }
            usable = debris;
        }
        if (usable != null) {
            return usable;
        }
        return scavenged;
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        if (!Global.CODEX_TOOLTIP_MODE) {
            tooltip.addTitle(this.spec.getName());
        } else {
            tooltip.addSpacer(-10.0f);
        }
        float pad = 10.0f;
        tooltip.addPara("Pick through a debris field looking for anything of value.", pad);
        if (!Global.CODEX_TOOLTIP_MODE) {
            DebrisFieldTerrainPlugin debris = this.getDebrisField();
            if (debris == null) {
                tooltip.addPara("Your fleet is not currently inside a debris field.", Misc.getNegativeHighlightColor(), pad);
            } else if (debris.isScavenged()) {
                tooltip.addPara("Your fleet is inside a debris field, but it contains nothing of value.", Misc.getNegativeHighlightColor(), pad);
            } else {
                tooltip.addPara("Your fleet is inside a debris field and can begin scavenging.", Misc.getPositiveHighlightColor(), pad);
            }
        }
        this.addIncompatibleToTooltip(tooltip, expanded);
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }
}

