/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities.ai;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.abilities.ai.BaseAbilityAI;
import com.fs.starfarer.api.impl.campaign.abilities.ai.EmergencyBurnAbilityAI;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class GoDarkAbilityAI
extends BaseAbilityAI {
    private IntervalUtil interval = new IntervalUtil(0.05f, 0.15f);

    @Override
    public void advance(float days) {
        this.interval.advance(days * EmergencyBurnAbilityAI.AI_FREQUENCY_MULT);
        if (!this.interval.intervalElapsed()) {
            return;
        }
        MemoryAPI mem = this.fleet.getMemoryWithoutUpdate();
        if (this.ability.isActiveOrInProgress()) {
            mem.set("$ai_hasSpeedPenalty", true, 0.2f);
            mem.set("$ai_hasLowerDetectability", true, 0.2f);
        }
        CampaignFleetAPI pursueTarget = mem.getFleet("$ai_pursuitTarget");
        CampaignFleetAPI fleeingFrom = mem.getFleet("$ai_fleeingFrom");
        Vector2f travelDest = mem.getVector2f("$ai_travelDest");
        boolean wantsTransponderOn = mem.getBoolean("$ai_wantsTransponderOn");
        if (fleeingFrom != null) {
            float dist = Misc.getDistance(this.fleet.getLocation(), fleeingFrom.getLocation()) - this.fleet.getRadius() - fleeingFrom.getRadius();
            if (dist < 0.0f) {
                return;
            }
            float detRange = fleeingFrom.getMaxSensorRangeToDetect(this.fleet);
            float ourSpeed = this.fleet.getFleetData().getBurnLevel();
            float theirSpeed = fleeingFrom.getFleetData().getBurnLevel();
            if (!this.ability.isActiveOrInProgress()) {
                if (dist > detRange * 0.5f + 100.0f && ourSpeed < theirSpeed && dist > detRange && dist < detRange + 300.0f) {
                    this.ability.activate();
                }
            } else if (dist < detRange || ourSpeed > theirSpeed) {
                this.ability.deactivate();
            }
            return;
        }
        if (this.fleet.isTransponderOn()) {
            return;
        }
        if (pursueTarget != null) {
            float closingSpeed = Misc.getClosingSpeed(this.fleet.getLocation(), pursueTarget.getLocation(), this.fleet.getVelocity(), pursueTarget.getVelocity());
            if (closingSpeed <= 1.0f && this.ability.isActiveOrInProgress()) {
                this.ability.deactivate();
            }
            return;
        }
        boolean smuggler = mem.getBoolean("$isSmuggler");
        boolean pirate = mem.getBoolean("$isPirate");
        pirate = false;
        boolean nearestMarketHostile = false;
        MarketAPI nearestMarket = Misc.findNearestLocalMarket(this.fleet, 2000.0f, new BaseEventPlugin.MarketFilter(){

            @Override
            public boolean acceptMarket(MarketAPI market) {
                return true;
            }
        });
        if (nearestMarket != null && nearestMarket.getFaction().isHostileTo(this.fleet.getFaction())) {
            nearestMarketHostile = true;
        }
        if ((smuggler || pirate || nearestMarketHostile) && !this.ability.isActiveOrInProgress() && travelDest != null) {
            float dist = Misc.getDistance(this.fleet.getLocation(), travelDest);
            if (dist < 1500.0f) {
                this.ability.activate();
            }
            return;
        }
    }
}

