/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities.ai;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.impl.campaign.abilities.InterdictionPulseAbility;
import com.fs.starfarer.api.impl.campaign.abilities.ai.BaseAbilityAI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;

public class InterdictionPulseAbilityAI
extends BaseAbilityAI {
    public static final float AI_FREQUENCY_MULT = 1.0f;
    private IntervalUtil interval = new IntervalUtil(0.05f, 0.15f);

    @Override
    public void advance(float days) {
        ModularFleetAIAPI ai;
        this.interval.advance(days * 1.0f);
        if (!this.interval.intervalElapsed()) {
            return;
        }
        if (this.fleet.getAI() instanceof ModularFleetAIAPI && (ai = (ModularFleetAIAPI)this.fleet.getAI()).getTacticalModule().isMaintainingContact()) {
            return;
        }
        MemoryAPI mem = this.fleet.getMemoryWithoutUpdate();
        if (this.ability.isActiveOrInProgress()) {
            mem.set("$ai_hasSpeedPenalty", true, 0.2f);
            mem.set("$ai_usedIP", true, 0.5f);
            return;
        }
        if (!this.ability.isUsable()) {
            return;
        }
        CampaignFleetAPI pursueTarget = mem.getFleet("$ai_pursuitTarget");
        CampaignFleetAPI fleeingFrom = mem.getFleet("$ai_fleeingFrom");
        float activationTime = this.ability.getSpec().getActivationDays() * Global.getSector().getClock().getSecondsPerDay();
        if (fleeingFrom != null) {
            float range = InterdictionPulseAbility.getRange(this.fleet);
            float dist = Misc.getDistance(this.fleet.getLocation(), fleeingFrom.getLocation());
            if (dist > range + 200.0f) {
                return;
            }
            SectorEntityToken.VisibilityLevel level = fleeingFrom.getVisibilityLevelTo(this.fleet);
            if (level == SectorEntityToken.VisibilityLevel.NONE) {
                return;
            }
            if (this.fleet.getAI() != null && !this.fleet.getAI().isHostileTo(fleeingFrom)) {
                return;
            }
            float speed = Math.max(1.0f, fleeingFrom.getVelocity().length());
            float time = dist / speed;
            boolean usingHasBenefit = false;
            float interdictDur = InterdictionPulseAbility.getInterdictSeconds(this.fleet, fleeingFrom);
            if (interdictDur > 0.0f && fleeingFrom.getVelocity().length() > this.fleet.getVelocity().length()) {
                for (AbilityPlugin ability : fleeingFrom.getAbilities().values()) {
                    if (!ability.getSpec().hasTag("burn+") || !ability.isActiveOrInProgress()) continue;
                    usingHasBenefit = true;
                    break;
                }
                AbilityPlugin eb = this.fleet.getAbility("emergency_burn");
                if (eb != null && eb.getCooldownLeft() < activationTime + 1.0f) {
                    usingHasBenefit = true;
                }
            }
            if (time > activationTime + 2.0f && time < activationTime + 7.0f && usingHasBenefit) {
                if (this.shouldSkipUsing()) {
                    return;
                }
                this.ability.activate();
            }
            return;
        }
        if (pursueTarget != null) {
            AbilityPlugin sb;
            AbilityPlugin tj;
            float range = InterdictionPulseAbility.getRange(this.fleet);
            float dist = Misc.getDistance(this.fleet.getLocation(), pursueTarget.getLocation());
            if (dist > range + 200.0f) {
                return;
            }
            SectorEntityToken.VisibilityLevel level = pursueTarget.getVisibilityLevelTo(this.fleet);
            if (level == SectorEntityToken.VisibilityLevel.NONE) {
                return;
            }
            if (this.fleet.getAI() != null && !this.fleet.getAI().isHostileTo(pursueTarget)) {
                return;
            }
            float speed = Math.max(1.0f, pursueTarget.getVelocity().length());
            float closingSpeed = Misc.getClosingSpeed(this.fleet.getLocation(), pursueTarget.getLocation(), this.fleet.getVelocity(), pursueTarget.getVelocity());
            speed = Math.max(1.0f, (speed - closingSpeed) / 2.0f);
            float time = Math.max(200.0f, range - dist) / speed;
            float timeToReach = dist / this.fleet.getVelocity().length();
            boolean usingHasBenefit = false;
            float interdictDur = InterdictionPulseAbility.getInterdictSeconds(this.fleet, pursueTarget);
            if (interdictDur > 0.0f && pursueTarget.getVelocity().length() > this.fleet.getVelocity().length()) {
                for (AbilityPlugin ability : pursueTarget.getAbilities().values()) {
                    if (!ability.getSpec().hasTag("burn+") || !ability.isActiveOrInProgress()) continue;
                    usingHasBenefit = true;
                    break;
                }
            }
            if ((tj = pursueTarget.getAbility("fracture_jump")) != null && tj.isActiveOrInProgress() && timeToReach > activationTime && dist < range) {
                usingHasBenefit = true;
            }
            if ((sb = pursueTarget.getAbility("sustained_burn")) != null && sb.isActiveOrInProgress() && sb.getProgressFraction() > 0.25f && sb.getProgressFraction() <= 0.5f) {
                usingHasBenefit = true;
            }
            if (usingHasBenefit && time > activationTime + 0.5f) {
                if (this.shouldSkipUsing()) {
                    return;
                }
                this.ability.activate();
            }
            return;
        }
    }

    public boolean shouldSkipUsing() {
        for (CampaignFleetAPI other : this.fleet.getContainingLocation().getFleets()) {
            if (this.fleet == other) continue;
            if (other.getMemoryWithoutUpdate().contains("$ai_usedIP")) {
                return true;
            }
            AbilityPlugin ip = other.getAbility("interdiction_pulse");
            if (ip == null || !ip.isActiveOrInProgress()) continue;
            return true;
        }
        return false;
    }
}

