/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities.ai;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.abilities.ai.BaseAbilityAI;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;

public class SensorBurstAbilityAI
extends BaseAbilityAI {
    private IntervalUtil interval = new IntervalUtil(0.05f, 0.15f);

    @Override
    public void advance(float days) {
        this.interval.advance(days);
        if (!this.interval.intervalElapsed()) {
            return;
        }
        MemoryAPI mem = this.fleet.getMemoryWithoutUpdate();
        if (this.ability.isActiveOrInProgress()) {
            mem.set("$ai_hasSpeedPenalty", true, 0.2f);
            mem.set("$ai_hasVisionBonus", true, 0.2f);
            mem.set("$ai_hasHigherDetectability", true, 0.2f);
            return;
        }
        if (this.fleet.getOrbit() != null) {
            return;
        }
        CampaignFleetAPI pursueTarget = mem.getFleet("$ai_pursuitTarget");
        CampaignFleetAPI fleeingFrom = mem.getFleet("$ai_fleeingFrom");
        if (fleeingFrom != null) {
            return;
        }
        if (pursueTarget != null) {
            SectorEntityToken.VisibilityLevel level = pursueTarget.getVisibilityLevelTo(this.fleet);
            if (level != SectorEntityToken.VisibilityLevel.NONE) {
                return;
            }
            float daysUnseen = mem.getFloat("$ai_daysTargetUnseen");
            float prob = (daysUnseen - 1.0f) * 0.1f;
            MarketAPI nearestMarket = Misc.findNearestLocalMarket(this.fleet, 1000000.0f, new BaseEventPlugin.MarketFilter(){

                @Override
                public boolean acceptMarket(MarketAPI market) {
                    return true;
                }
            });
            if (nearestMarket != null && nearestMarket.getFaction().isHostileTo(this.fleet.getFaction())) {
                prob *= 0.25f;
            }
            if (Math.random() < (double)prob) {
                this.ability.activate();
            }
            return;
        }
        boolean trader = mem.getBoolean("$isTradeFleet");
        boolean smuggler = mem.getBoolean("$isSmuggler");
        if (trader || smuggler) {
            return;
        }
        MarketAPI nearestMarket = Misc.findNearestLocalMarket(this.fleet, 1000000.0f, new BaseEventPlugin.MarketFilter(){

            @Override
            public boolean acceptMarket(MarketAPI market) {
                return true;
            }
        });
        float prob = 0.01f;
        if (nearestMarket != null && nearestMarket.getFaction().isHostileTo(this.fleet.getFaction())) {
            prob *= 0.25f;
        }
        if (Math.random() < (double)prob) {
            this.ability.activate();
        }
    }
}

