/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;
import com.fs.starfarer.api.impl.campaign.intel.PerseanLeagueMembership;
import com.fs.starfarer.api.impl.campaign.intel.events.EstablishedPolityScript;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class EstablishedPolity
extends BaseMarketConditionPlugin {
    public static float ACCESSIBILITY_BONUS = 0.1f;
    public static String NAME_BASE = "Established Polity";
    public static String NAME_LEAGUE = "League development programs";

    @Override
    public void apply(String id) {
        String text = Misc.ucFirst(this.getName().toLowerCase());
        this.market.getAccessibilityMod().modifyFlat(id, ACCESSIBILITY_BONUS, text);
    }

    @Override
    public void unapply(String id) {
        this.market.getAccessibilityMod().unmodifyFlat(id);
    }

    @Override
    public void createTooltipAfterDescription(TooltipMakerAPI tooltip, boolean expanded) {
        EstablishedPolityScript script = EstablishedPolityScript.get();
        if (script == null) {
            return;
        }
        Color h = Misc.getHighlightColor();
        float opad = 10.0f;
        if (PerseanLeagueMembership.isLeagueMember()) {
            tooltip.addPara("Your colonies are recently joined members of the Persean League, resulting in an increased flow of commerce.", opad);
        } else {
            tooltip.addPara("You've proven the independence and strength of your colonies by defeating a Persean League force sent against you, and are viewed as a stable trading partner.", opad);
        }
        tooltip.addPara("%s accessibility.", opad, h, "+" + Math.round(ACCESSIBILITY_BONUS * 100.0f) + "%");
    }

    @Override
    public boolean hasCustomTooltip() {
        return true;
    }

    @Override
    public String getName() {
        if (PerseanLeagueMembership.isLeagueMember()) {
            return NAME_LEAGUE;
        }
        return NAME_BASE;
    }

    @Override
    public String getIconName() {
        if (PerseanLeagueMembership.isLeagueMember()) {
            return Global.getSettings().getSpriteName("events", "new_league_member");
        }
        return super.getIconName();
    }
}

