/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketImmigrationModifier;
import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;
import com.fs.starfarer.api.impl.campaign.econ.impl.ConstructionQueue;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.intel.events.LuddicChurchHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.population.PopulationComposition;
import com.fs.starfarer.api.loading.IndustrySpecAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class LuddicMajority
extends BaseMarketConditionPlugin
implements MarketImmigrationModifier {
    public static float STABILITY = 1.0f;
    public static float IMMIGRATION_BASE = 5.0f;
    public static float PRODUCTION_BASE_RURAL = 1.0f;
    public static Map<String, Integer> PRODUCTION_OVERRIDES = new LinkedHashMap<String, Integer>();
    public static int BONUS_MULT_DEFEATED_EXPEDITION = 2;
    @Deprecated
    public static String[] luddicFactions = new String[]{"knights_of_ludd", "luddic_church", "luddic_path"};

    @Override
    public void apply(String id) {
        if (!LuddicMajority.matchesBonusConditions(this.market)) {
            this.unapply(id);
            return;
        }
        this.market.addTransientImmigrationModifier(this);
        int stability = Math.round(STABILITY * this.getEffectMult());
        if (stability != 0) {
            this.market.getStability().modifyFlat(id, stability, "Luddic majority");
        }
        float mult = this.getEffectMult();
        for (Industry ind : this.market.getIndustries()) {
            if (!ind.getSpec().hasTag("rural") && !PRODUCTION_OVERRIDES.containsKey(ind.getId())) continue;
            int production = Math.round(PRODUCTION_BASE_RURAL * mult);
            if (PRODUCTION_OVERRIDES.containsKey(ind.getId())) {
                production = Math.round((float)PRODUCTION_OVERRIDES.get(ind.getId()).intValue() * mult);
            }
            if (production == 0) continue;
            ind.getSupplyBonusFromOther().modifyFlat(id, production, "Luddic majority");
        }
    }

    @Override
    public void unapply(String id) {
        this.market.removeTransientImmigrationModifier(this);
        this.market.getStability().unmodify(id);
        for (Industry ind : this.market.getIndustries()) {
            if (!ind.getSpec().hasTag("rural") && !PRODUCTION_OVERRIDES.containsKey(ind.getId())) continue;
            ind.getSupplyBonusFromOther().unmodifyFlat(id);
        }
    }

    @Override
    public void modifyIncoming(MarketAPI market, PopulationComposition incoming) {
        float bonus = this.getImmigrationBonus(true);
        if (bonus > 0.0f) {
            incoming.add("luddic_church", bonus);
            incoming.getWeight().modifyFlat(this.getModId(), bonus, "Luddic immigration (Luddic majority)");
        }
    }

    public float getImmigrationBonus(boolean withEffectMult) {
        float bonus = IMMIGRATION_BASE * (float)this.market.getSize();
        if (withEffectMult) {
            bonus *= this.getEffectMult();
        }
        return bonus;
    }

    public float getEffectMult() {
        if (this.market.isPlayerOwned() && LuddicChurchHostileActivityFactor.isDefeatedExpedition()) {
            return BONUS_MULT_DEFEATED_EXPEDITION;
        }
        return 1.0f;
    }

    @Override
    protected void createTooltipAfterDescription(TooltipMakerAPI tooltip, boolean expanded) {
        super.createTooltipAfterDescription(tooltip, expanded);
        String name = this.market.getName();
        float opad = 10.0f;
        tooltip.addPara("A majority of the population of " + name + " are Luddic faithful. " + "This may result in a substantial boost " + "to stability and productivity.", opad);
        tooltip.addPara("For colonies outside the core, it may also result in increased population growth, from Luddic immigrants seeking to escape the sometimes oppressive influence of the Luddic Church.", opad);
        tooltip.addPara("%s stability", opad, Misc.getHighlightColor(), "+" + (int)STABILITY);
        tooltip.addPara("%s production for Farming, Light Industry, and similar", opad, Misc.getHighlightColor(), "+" + (int)PRODUCTION_BASE_RURAL);
        if (this.market.isPlayerOwned()) {
            tooltip.addPara("%s population growth", opad, Misc.getHighlightColor(), "+" + (int)this.getImmigrationBonus(false));
        }
        if (!Global.CODEX_TOOLTIP_MODE) {
            LuddicMajority.addConditions(tooltip, this.market, opad);
        }
    }

    public static void addConditions(TooltipMakerAPI tooltip, MarketAPI market, float opad) {
        boolean matches;
        boolean madeDeal = LuddicChurchHostileActivityFactor.isMadeDeal() && market.isPlayerOwned();
        boolean freePort = market.isFreePort();
        freePort = false;
        boolean habitable = market.hasCondition("habitable");
        boolean hasRural = false;
        boolean hasIndustrial = false;
        boolean hasMilitary = false;
        String heavy = null;
        String military = null;
        String rural = null;
        Iterator<Object> iterator = market.getIndustries().iterator();
        while (iterator.hasNext()) {
            Industry ind = iterator.next();
            if (ind.getSpec().hasTag("industrial")) {
                if (heavy == null) {
                    heavy = ind.getCurrentName();
                }
                hasIndustrial = true;
            }
            if (ind.getSpec().hasTag("military") || ind.getSpec().hasTag("command")) {
                if (military == null) {
                    military = ind.getCurrentName();
                }
                hasMilitary = true;
            }
            if (!ind.getSpec().hasTag("rural")) continue;
            if (rural == null) {
                rural = ind.getCurrentName();
            }
            hasRural = true;
        }
        if (market.getConstructionQueue() != null && (iterator = market.getConstructionQueue().getItems().iterator()).hasNext()) {
            ConstructionQueue.ConstructionQueueItem item = (ConstructionQueue.ConstructionQueueItem)iterator.next();
            IndustrySpecAPI spec = Global.getSettings().getIndustrySpec(item.id);
            if (spec != null) {
                if (spec.hasTag("industrial")) {
                    if (heavy == null) {
                        heavy = spec.getName();
                    }
                    hasIndustrial = true;
                }
                if (spec.hasTag("military") || spec.hasTag("command")) {
                    if (military == null) {
                        military = spec.getName();
                    }
                    hasMilitary = true;
                }
                if (spec.hasTag("rural")) {
                    if (rural == null) {
                        rural = spec.getName();
                    }
                    hasRural = true;
                }
            }
        }
        if (!(matches = LuddicMajority.matchesBonusConditions(market))) {
            if (market.isPlayerOwned()) {
                tooltip.addPara("The following factors result in these bonuses being negated, and, unless addressed, will result in the \"Luddic Majority\" condition being removed if the colony increases in size:", opad, Misc.getNegativeHighlightColor(), "negated", "removed");
            } else {
                tooltip.addPara("The following factors result in these bonuses being negated:", opad, Misc.getNegativeHighlightColor(), "negated", "removed");
            }
            tooltip.setBulletedListMode("    - ");
            if (market.getAdmin() != null && market.getAdmin().getId().equals(People.DARDAN_KATO)) {
                tooltip.addPara("Dardan Kato's \"policies\"", opad);
                opad = 0.0f;
            }
            if (madeDeal) {
                tooltip.addPara("Deal made with Luddic Church to curtail immigration", opad);
                opad = 0.0f;
            }
            if (freePort) {
                tooltip.addPara("The colony is a free port", opad);
                opad = 0.0f;
            }
            if (!habitable) {
                tooltip.addPara("The colony is not habitable", opad);
                opad = 0.0f;
            }
            if (!hasRural) {
                tooltip.addPara("The colony has no suitable employment for the faithful, such as farming or light industry", opad);
                opad = 0.0f;
            }
            if (hasIndustrial) {
                tooltip.addPara("The colony has heavy industrial facilities (" + heavy + ")", opad);
                opad = 0.0f;
            }
            if (hasMilitary) {
                tooltip.addPara("The colony has military facilities (" + military + ")", opad);
                opad = 0.0f;
            }
            tooltip.setBulletedListMode(null);
        } else if (market.isPlayerOwned() && LuddicChurchHostileActivityFactor.isDefeatedExpedition()) {
            tooltip.addPara("The bonus is doubled due to the faithful " + market.getOnOrAt() + " " + market.getName() + " feeling securely out from under the direct " + "influence of the Luddic Church.", opad, Misc.getPositiveHighlightColor(), "doubled");
        }
        tooltip.setBulletedListMode("    - ");
        tooltip.setBulletedListMode(null);
    }

    public static boolean matchesBonusConditions(MarketAPI market) {
        if (market.isPlayerOwned() && LuddicChurchHostileActivityFactor.isMadeDeal()) {
            return false;
        }
        if (!market.hasCondition("habitable")) {
            return false;
        }
        if (market.getAdmin() != null && market.getAdmin().getId().equals(People.DARDAN_KATO)) {
            return false;
        }
        boolean hasRural = false;
        Iterator<Object> iterator = market.getIndustries().iterator();
        while (iterator.hasNext()) {
            Industry ind = iterator.next();
            if (ind.getSpec().hasTag("industrial")) {
                return false;
            }
            if (ind.getSpec().hasTag("military")) {
                return false;
            }
            if (ind.getSpec().hasTag("command")) {
                return false;
            }
            hasRural |= ind.getSpec().hasTag("rural");
        }
        if (market.getConstructionQueue() != null && (iterator = market.getConstructionQueue().getItems().iterator()).hasNext()) {
            ConstructionQueue.ConstructionQueueItem item = (ConstructionQueue.ConstructionQueueItem)iterator.next();
            IndustrySpecAPI spec = Global.getSettings().getIndustrySpec(item.id);
            if (spec != null) {
                if (spec.hasTag("industrial")) {
                    return false;
                }
                if (spec.hasTag("military") || spec.hasTag("command")) {
                    return false;
                }
            }
        }
        return hasRural;
    }

    @Override
    public String getIconName() {
        if (!LuddicMajority.matchesBonusConditions(this.market)) {
            return Global.getSettings().getSpriteName("events", "luddic_majority_unhappy");
        }
        return super.getIconName();
    }
}

