/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ;

import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;
import com.fs.starfarer.api.impl.campaign.intel.events.PiracyRespiteScript;
import com.fs.starfarer.api.impl.campaign.rulecmd.KantaCMD;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class PiracyRespite
extends BaseMarketConditionPlugin {
    public static boolean NEW_MODE = true;
    public static float ACCESSIBILITY_BONUS = 0.1f;
    public static float ACCESSIBILITY_BONUS_KANTA = 0.1f;

    public static float getBonus() {
        float bonus = ACCESSIBILITY_BONUS;
        if (KantaCMD.playerHasProtection()) {
            bonus += ACCESSIBILITY_BONUS_KANTA;
        }
        return bonus;
    }

    @Override
    public void apply(String id) {
        if (NEW_MODE) {
            return;
        }
        String text = Misc.ucFirst(this.getName().toLowerCase());
        if (KantaCMD.playerHasProtection()) {
            text = String.valueOf(text) + " (with Kanta's Protection)";
        }
        this.market.getAccessibilityMod().modifyFlat(id, PiracyRespite.getBonus(), text);
    }

    @Override
    public void unapply(String id) {
        if (NEW_MODE) {
            return;
        }
        this.market.getAccessibilityMod().unmodifyFlat(id);
    }

    @Override
    public void createTooltipAfterDescription(TooltipMakerAPI tooltip, boolean expanded) {
        PiracyRespiteScript script = PiracyRespiteScript.get();
        if (script == null) {
            return;
        }
        Color h = Misc.getHighlightColor();
        float opad = 10.0f;
        if (NEW_MODE) {
            if (KantaCMD.playerHasProtection()) {
                tooltip.addPara("Your colonies have %s, and pirates are wary of attacking trade fleets serving them lest they attract her wrath. Shipping disruptions from piracy are virtually eliminated.", opad, Misc.getPositiveHighlightColor(), "Kanta's Protection");
            } else {
                tooltip.addPara("You've defeated a large armada sent against your colonies, and pirates are wary of attacking trade fleets serving them, resulting in a greatly reduced number of shipping disruptions.", opad);
            }
        } else {
            String days;
            int rem = Math.round(script.getDaysRemaining());
            String string = days = rem == 1 ? "day" : "days";
            if (KantaCMD.playerHasProtection()) {
                tooltip.addPara("Your colonies have %s, resulting in an increased accessibility bonus.", opad, Misc.getPositiveHighlightColor(), "Kanta's Protection");
            }
            if (rem >= 0) {
                tooltip.addPara("%s accessibility (%s " + days + " remaining).", opad, h, "+" + Math.round(PiracyRespite.getBonus() * 100.0f) + "%", "" + rem);
            } else {
                tooltip.addPara("%s accessibility.", opad, h, "+" + Math.round(PiracyRespite.getBonus() * 100.0f) + "%");
            }
        }
    }

    @Override
    public boolean hasCustomTooltip() {
        return true;
    }
}

