/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.SpecialItemSpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.InstallableIndustryItemPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.econ.impl.InstallableItemEffect;
import com.fs.starfarer.api.impl.campaign.econ.impl.ItemEffectsRepo;
import com.fs.starfarer.api.impl.campaign.econ.impl.PopulationAndInfrastructure;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Pair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class BaseInstallableItemEffect
implements InstallableItemEffect {
    public String id;
    public SpecialItemSpecAPI spec;

    public BaseInstallableItemEffect(String id) {
        this.id = id;
        this.spec = Global.getSettings().getSpecialItemSpec(id);
    }

    public float getItemDescPad(InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode) {
        float pad = 0.0f;
        if (mode == InstallableIndustryItemPlugin.InstallableItemDescriptionMode.INDUSTRY_MENU_TOOLTIP || mode == InstallableIndustryItemPlugin.InstallableItemDescriptionMode.CARGO_TOOLTIP) {
            pad = 10.0f;
        }
        return pad;
    }

    public String getItemInstalledText(TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode) {
        String name = Misc.ucFirst(this.spec.getName().toLowerCase());
        String pre = "";
        float pad = 0.0f;
        if (mode == InstallableIndustryItemPlugin.InstallableItemDescriptionMode.MANAGE_ITEM_DIALOG_LIST || mode == InstallableIndustryItemPlugin.InstallableItemDescriptionMode.INDUSTRY_TOOLTIP) {
            pre = String.valueOf(name) + ". ";
        } else if (mode == InstallableIndustryItemPlugin.InstallableItemDescriptionMode.MANAGE_ITEM_DIALOG_INSTALLED || mode == InstallableIndustryItemPlugin.InstallableItemDescriptionMode.INDUSTRY_MENU_TOOLTIP) {
            pre = String.valueOf(name) + " currently installed. ";
        }
        if (mode == InstallableIndustryItemPlugin.InstallableItemDescriptionMode.INDUSTRY_MENU_TOOLTIP || mode == InstallableIndustryItemPlugin.InstallableItemDescriptionMode.CARGO_TOOLTIP) {
            pad = 10.0f;
        }
        return pre;
    }

    @Override
    public void addItemDescription(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode) {
        String pre = this.getItemInstalledText(text, data, mode);
        float pad = this.getItemDescPad(mode);
        this.addItemDescriptionImpl(industry, text, data, mode, pre, pad);
    }

    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
    }

    public String[] getSimpleReqs(Industry industry) {
        return new String[0];
    }

    @Override
    public List<String> getRequirements(Industry industry) {
        ArrayList<String> reqs = new ArrayList<String>();
        String[] stringArray = this.getSimpleReqs(industry);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String curr = stringArray[n2];
            reqs.add(curr);
            ++n2;
        }
        return reqs;
    }

    @Override
    public List<String> getUnmetRequirements(Industry industry) {
        return this.getUnmetRequirements(industry, false);
    }

    @Override
    public List<String> getUnmetRequirements(Industry industry, boolean checkSurveyed) {
        boolean full;
        ArrayList<String> unmet = new ArrayList<String>();
        if (industry == null) {
            return unmet;
        }
        MarketAPI market = industry.getMarket();
        boolean prelim = market.getSurveyLevel().ordinal() >= MarketAPI.SurveyLevel.PRELIMINARY.ordinal();
        boolean bl = full = market.getSurveyLevel().ordinal() >= MarketAPI.SurveyLevel.FULL.ordinal();
        if (!checkSurveyed) {
            prelim = true;
            full = true;
        }
        for (String curr : this.getRequirements(industry)) {
            if (ItemEffectsRepo.NO_ATMOSPHERE.equals(curr)) {
                if (market.hasCondition("no_atmosphere") && prelim) continue;
                unmet.add(curr);
                continue;
            }
            if (ItemEffectsRepo.HABITABLE.equals(curr)) {
                if (market.hasCondition("habitable") && prelim) continue;
                unmet.add(curr);
                continue;
            }
            if (ItemEffectsRepo.NOT_HABITABLE.equals(curr)) {
                if (!market.hasCondition("habitable") && prelim) continue;
                unmet.add(curr);
                continue;
            }
            if (ItemEffectsRepo.GAS_GIANT.equals(curr)) {
                if (market.getPlanetEntity() == null || market.getPlanetEntity().isGasGiant()) continue;
                unmet.add(curr);
                continue;
            }
            if (ItemEffectsRepo.NOT_A_GAS_GIANT.equals(curr)) {
                if (market.getPlanetEntity() == null || !market.getPlanetEntity().isGasGiant()) continue;
                unmet.add(curr);
                continue;
            }
            if (ItemEffectsRepo.NOT_EXTREME_WEATHER.equals(curr)) {
                if (!market.hasCondition("extreme_weather") && prelim) continue;
                unmet.add(curr);
                continue;
            }
            if (ItemEffectsRepo.NOT_EXTREME_TECTONIC_ACTIVITY.equals(curr)) {
                if (!market.hasCondition("extreme_tectonic_activity") && prelim) continue;
                unmet.add(curr);
                continue;
            }
            if (ItemEffectsRepo.NO_TRANSPLUTONIC_ORE_DEPOSITS.equals(curr)) {
                if (!market.hasCondition("rare_ore_sparse") && !market.hasCondition("rare_ore_moderate") && !market.hasCondition("rare_ore_abundant") && !market.hasCondition("rare_ore_rich") && !market.hasCondition("rare_ore_ultrarich") && full) continue;
                unmet.add(curr);
                continue;
            }
            if (ItemEffectsRepo.NO_VOLATILES_DEPOSITS.equals(curr)) {
                if (!market.hasCondition("volatiles_trace") && !market.hasCondition("volatiles_diffuse") && !market.hasCondition("volatiles_abundant") && !market.hasCondition("volatiles_plentiful") && full) continue;
                unmet.add(curr);
                continue;
            }
            if (ItemEffectsRepo.HOT_OR_EXTREME_HEAT.equals(curr)) {
                if ((market.hasCondition("hot") || market.hasCondition("very_hot")) && prelim) continue;
                unmet.add(curr);
                continue;
            }
            if (ItemEffectsRepo.COLD_OR_EXTREME_COLD.equals(curr)) {
                if ((market.hasCondition("cold") || market.hasCondition("very_cold")) && prelim) continue;
                unmet.add(curr);
                continue;
            }
            if (!ItemEffectsRepo.CORONAL_TAP_RANGE.equals(curr)) continue;
            Pair<SectorEntityToken, Float> p = PopulationAndInfrastructure.getNearestCoronalTap(market.getLocationInHyperspace(), true);
            float dist = Float.MAX_VALUE;
            if (p != null) {
                dist = ((Float)p.two).floatValue();
            }
            if (!(dist > (float)ItemEffectsRepo.CORONAL_TAP_LIGHT_YEARS)) continue;
            unmet.add(curr);
        }
        return unmet;
    }

    @Override
    public Set<String> getConditionsRelatedToRequirements(Industry industry) {
        LinkedHashSet<String> cond = new LinkedHashSet<String>();
        for (String curr : this.getRequirements(industry)) {
            if (ItemEffectsRepo.NO_ATMOSPHERE.equals(curr)) {
                cond.add("no_atmosphere");
                continue;
            }
            if (ItemEffectsRepo.HABITABLE.equals(curr)) {
                cond.add("habitable");
                continue;
            }
            if (ItemEffectsRepo.NOT_HABITABLE.equals(curr)) {
                cond.add("habitable");
                continue;
            }
            if (ItemEffectsRepo.NOT_EXTREME_WEATHER.equals(curr)) {
                cond.add("extreme_weather");
                continue;
            }
            if (ItemEffectsRepo.NOT_EXTREME_TECTONIC_ACTIVITY.equals(curr)) {
                cond.add("extreme_tectonic_activity");
                continue;
            }
            if (ItemEffectsRepo.NO_TRANSPLUTONIC_ORE_DEPOSITS.equals(curr)) {
                cond.add("rare_ore_sparse");
                cond.add("rare_ore_moderate");
                cond.add("rare_ore_abundant");
                cond.add("rare_ore_rich");
                cond.add("rare_ore_ultrarich");
                continue;
            }
            if (ItemEffectsRepo.NO_VOLATILES_DEPOSITS.equals(curr)) {
                cond.add("volatiles_trace");
                cond.add("volatiles_diffuse");
                cond.add("volatiles_abundant");
                cond.add("volatiles_plentiful");
                continue;
            }
            if (ItemEffectsRepo.HOT_OR_EXTREME_HEAT.equals(curr)) {
                cond.add("hot");
                cond.add("very_hot");
                continue;
            }
            if (!ItemEffectsRepo.COLD_OR_EXTREME_COLD.equals(curr)) continue;
            cond.add("cold");
            cond.add("very_cold");
        }
        return cond;
    }

    protected void addRequirements(TooltipMakerAPI text, boolean canInstall, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String ... reqs) {
        if (canInstall) {
            return;
        }
        float opad = 10.0f;
        String list = "";
        String[] stringArray = reqs;
        int n = reqs.length;
        int n2 = 0;
        while (n2 < n) {
            String curr = stringArray[n2];
            curr = curr.trim();
            list = String.valueOf(list) + curr + ", ";
            ++n2;
        }
        Color reqColor = Misc.getBasePlayerColor();
        if (mode != InstallableIndustryItemPlugin.InstallableItemDescriptionMode.CARGO_TOOLTIP) {
            reqColor = Misc.getNegativeHighlightColor();
            opad = 0.0f;
        }
        if (!list.isEmpty()) {
            list = list.substring(0, list.length() - 2);
        }
        if (!list.isEmpty()) {
            text.addPara("Requires: " + list, opad, Misc.getGrayColor(), reqColor, reqs);
        }
    }
}

