/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.EconomyAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;

public class ConditionManager
implements EconomyAPI.EconomyUpdateListener {
    public static final String KEY = "$core_marketConditionManager";

    public static ConditionManager getInstance() {
        Object test = Global.getSector().getMemoryWithoutUpdate().get(KEY);
        if (test == null) {
            test = new ConditionManager();
            Global.getSector().getMemoryWithoutUpdate().set(KEY, test);
        }
        return (ConditionManager)test;
    }

    protected Object readResolve() {
        return this;
    }

    public ConditionManager() {
        Global.getSector().getEconomy().addUpdateListener(this);
    }

    @Override
    public void economyUpdated() {
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (market.isHidden()) continue;
            int urban = 0;
            int industrial = 0;
            int rural = 0;
            int pollution = 0;
            for (Industry curr : market.getIndustries()) {
                if (!curr.isIndustry()) continue;
                if (curr.getSpec().hasTag("urban")) {
                    ++urban;
                }
                if (curr.getSpec().hasTag("rural")) {
                    ++rural;
                }
                if (!curr.getSpec().hasTag("industrial")) continue;
                ++industrial;
                ++pollution;
            }
            if (market.hasCondition("urbanized_polity") && (urban <= 0 || industrial > 0 || rural > 0)) {
                market.removeCondition("urbanized_polity");
            }
            if (market.hasCondition("rural_polity") && (rural <= 0 || urban > 0 || industrial > 0)) {
                market.removeCondition("rural_polity");
            }
            if (market.hasCondition("industrial_polity") && (industrial <= 0 || urban > 0 || rural > 0)) {
                market.removeCondition("industrial_polity");
            }
            if (market.getSize() <= 3) continue;
            if (!market.hasCondition("urbanized_polity") && urban > 0 && industrial + rural <= 0) {
                market.addCondition("urbanized_polity");
            }
            if (!market.hasCondition("rural_polity") && rural > 0 && industrial + urban <= 0) {
                market.addCondition("rural_polity");
            }
            if (!market.hasCondition("industrial_polity") && industrial > 0 && rural + urban <= 0) {
                market.addCondition("industrial_polity");
            }
            if (market.hasCondition("pollution") || !market.hasCondition("habitable") || market.getSize() < 5 || pollution < 3) continue;
            market.addCondition("pollution");
        }
    }

    @Override
    public void commodityUpdated(String commodityId) {
    }

    @Override
    public boolean isEconomyListenerExpired() {
        return false;
    }
}

