/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.campaign.econ.MarketImmigrationModifier;
import com.fs.starfarer.api.impl.campaign.econ.ResourceDepositsCondition;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.population.PopulationComposition;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Pair;
import java.util.HashSet;
import java.util.Set;

public class Farming
extends BaseIndustry
implements MarketImmigrationModifier {
    public static Set<String> AQUA_PLANETS = new HashSet<String>();

    static {
        AQUA_PLANETS.add("water");
    }

    @Override
    public void apply() {
        super.apply(true);
        int size = this.market.getSize();
        boolean aquaculture = "aquaculture".equals(this.getId());
        if (aquaculture) {
            this.demand(0, "heavy_machinery", size, "Base value for colony size");
        } else {
            this.demand(0, "heavy_machinery", size - 3, "Base value for colony size");
        }
        Pair<String, Integer> deficit = this.getMaxDeficit("heavy_machinery");
        this.applyDeficitToProduction(0, deficit, "food");
        if (!this.isFunctional()) {
            this.supply.clear();
        }
    }

    @Override
    public void unapply() {
        super.unapply();
    }

    @Override
    public boolean isAvailableToBuild() {
        boolean canAquaculture;
        if (!super.isAvailableToBuild()) {
            return false;
        }
        boolean aquaculture = "aquaculture".equals(this.getId());
        boolean bl = canAquaculture = this.market.getPlanetEntity() != null && AQUA_PLANETS.contains(this.market.getPlanetEntity().getTypeId());
        if (aquaculture != canAquaculture) {
            return false;
        }
        for (MarketConditionAPI mc : this.market.getConditions()) {
            String industry;
            String commodity = ResourceDepositsCondition.COMMODITY.get(mc.getId());
            if (commodity == null || !"farming".equals(industry = ResourceDepositsCondition.INDUSTRY.get(commodity))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean showWhenUnavailable() {
        boolean canAquaculture;
        boolean aquaculture = "aquaculture".equals(this.getId());
        boolean bl = canAquaculture = this.market.getPlanetEntity() != null && AQUA_PLANETS.contains(this.market.getPlanetEntity().getTypeId());
        if (aquaculture != canAquaculture) {
            return false;
        }
        return super.showWhenUnavailable();
    }

    @Override
    public String getUnavailableReason() {
        if (!super.isAvailableToBuild()) {
            return super.getUnavailableReason();
        }
        return "Requires farmland";
    }

    @Override
    public void createTooltip(Industry.IndustryTooltipMode mode, TooltipMakerAPI tooltip, boolean expanded) {
        super.createTooltip(mode, tooltip, expanded);
    }

    @Override
    public void modifyIncoming(MarketAPI market, PopulationComposition incoming) {
        incoming.add("luddic_church", 10.0f);
    }

    @Override
    public String getCurrentImage() {
        boolean aquaculture = "aquaculture".equals(this.getId());
        if (aquaculture) {
            return super.getCurrentImage();
        }
        float size = this.market.getSize();
        if (size <= (float)SIZE_FOR_SMALL_IMAGE) {
            return Global.getSettings().getSpriteName("industry", "farming_low");
        }
        if (size >= (float)SIZE_FOR_LARGE_IMAGE) {
            return Global.getSettings().getSpriteName("industry", "farming_high");
        }
        return Global.getSettings().getSpriteName("industry", "farming_med");
    }

    @Override
    protected boolean canImproveToIncreaseProduction() {
        return true;
    }

    @Override
    public MarketCMD.RaidDangerLevel adjustCommodityDangerLevel(String commodityId, MarketCMD.RaidDangerLevel level) {
        boolean aquaculture = "aquaculture".equals(this.getId());
        if (aquaculture) {
            return level;
        }
        return level.prev();
    }

    @Override
    public MarketCMD.RaidDangerLevel adjustItemDangerLevel(String itemId, String data, MarketCMD.RaidDangerLevel level) {
        boolean aquaculture = "aquaculture".equals(this.getId());
        if (aquaculture) {
            return level;
        }
        return level.prev();
    }
}

