/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.SpecialItemSpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.InstallableIndustryItemPlugin;
import com.fs.starfarer.api.campaign.impl.items.GenericSpecialItemPlugin;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseInstallableIndustryItemPlugin;
import com.fs.starfarer.api.impl.campaign.econ.impl.InstallableItemEffect;
import com.fs.starfarer.api.impl.campaign.econ.impl.ItemEffectsRepo;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import java.util.HashSet;
import java.util.List;

public class GenericInstallableItemPlugin
extends BaseInstallableIndustryItemPlugin {
    protected Industry industry;

    public GenericInstallableItemPlugin(Industry industry) {
        this.industry = industry;
    }

    @Override
    public String getMenuItemTitle() {
        if (this.getCurrentlyInstalledItemData() == null) {
            return "Install item...";
        }
        return "Manage item...";
    }

    @Override
    public String getUninstallButtonText() {
        return "Uninstall item";
    }

    @Override
    public boolean isInstallableItem(CargoStackAPI stack) {
        if (!stack.isSpecialStack()) {
            return false;
        }
        String[] industries = stack.getPlugin().getSpec().getParams().split(",");
        HashSet<String> all = new HashSet<String>();
        String[] stringArray = industries;
        int n = industries.length;
        int n2 = 0;
        while (n2 < n) {
            String ind = stringArray[n2];
            all.add(ind.trim());
            ++n2;
        }
        if (!all.contains(this.industry.getId())) {
            return false;
        }
        return ItemEffectsRepo.ITEM_EFFECTS.containsKey(stack.getSpecialDataIfSpecial().getId());
    }

    @Override
    public SpecialItemData getCurrentlyInstalledItemData() {
        return this.industry.getSpecialItem();
    }

    @Override
    public void setCurrentlyInstalledItemData(SpecialItemData data) {
        this.industry.setSpecialItem(data);
    }

    @Override
    public String getNoItemCurrentlyInstalledText() {
        return "No item currently installed";
    }

    @Override
    public String getNoItemsAvailableText() {
        return "No suitable items available";
    }

    @Override
    public String getNoItemsAvailableTextRemote() {
        return "No suitable items available in storage";
    }

    @Override
    public String getSelectItemToAssignToIndustryText() {
        return "Select item to install for " + this.industry.getCurrentName();
    }

    @Override
    public boolean canBeInstalled(SpecialItemData data) {
        InstallableItemEffect effect = ItemEffectsRepo.ITEM_EFFECTS.get(data.getId());
        if (effect != null) {
            List<String> unmet = effect.getUnmetRequirements(this.industry);
            return unmet == null || unmet.isEmpty();
        }
        return true;
    }

    @Override
    public void addItemDescription(TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode) {
        InstallableItemEffect effect = ItemEffectsRepo.ITEM_EFFECTS.get(data.getId());
        if (effect != null) {
            boolean canInstall;
            List<String> unmet = effect.getUnmetRequirements(this.industry);
            boolean bl = canInstall = unmet == null || unmet.isEmpty();
            if (!canInstall) {
                GenericSpecialItemPlugin.addReqsSection(this.industry, effect, text, true, 0.0f);
            } else {
                effect.addItemDescription(this.industry, text, data, mode);
            }
        }
    }

    @Override
    public boolean isMenuItemTooltipExpandable() {
        return false;
    }

    @Override
    public float getMenuItemTooltipWidth() {
        return super.getMenuItemTooltipWidth();
    }

    @Override
    public boolean hasMenuItemTooltip() {
        return super.hasMenuItemTooltip();
    }

    @Override
    public void createMenuItemTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        float pad = 3.0f;
        float opad = 10.0f;
        tooltip.addPara("Certain Domain-era artifacts might be installed here to improve the colony. Only one such artifact may be installed at an industry at a time.", 0.0f);
        SpecialItemData data = this.industry.getSpecialItem();
        if (data == null) {
            tooltip.addPara(String.valueOf(this.getNoItemCurrentlyInstalledText()) + ".", opad);
        } else {
            InstallableItemEffect effect = ItemEffectsRepo.ITEM_EFFECTS.get(data.getId());
            SpecialItemSpecAPI spec = Global.getSettings().getSpecialItemSpec(data.getId());
            TooltipMakerAPI text = tooltip.beginImageWithText(spec.getIconName(), 48.0f);
            effect.addItemDescription(this.industry, text, data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode.INDUSTRY_MENU_TOOLTIP);
            tooltip.addImageWithText(opad);
        }
    }
}

