/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Pair;
import java.awt.Color;

public class HeavyIndustry
extends BaseIndustry {
    public static float ORBITAL_WORKS_QUALITY_BONUS = 0.2f;
    public static String POLLUTION_ID = "pollution";
    public static float DAYS_BEFORE_POLLUTION = 0.0f;
    public static float DAYS_BEFORE_POLLUTION_PERMANENT = 90.0f;
    protected boolean permaPollution = false;
    protected boolean addedPollution = false;
    protected float daysWithNanoforge = 0.0f;

    @Override
    public void apply() {
        float stability;
        super.apply(true);
        int size = this.market.getSize();
        boolean works = "orbitalworks".equals(this.getId());
        int shipBonus = 0;
        float qualityBonus = 0.0f;
        if (works) {
            qualityBonus = ORBITAL_WORKS_QUALITY_BONUS;
        }
        this.demand("metals", size);
        this.demand("rare_metals", size - 2);
        this.supply("heavy_machinery", size - 2);
        this.supply("supplies", size - 2);
        this.supply("hand_weapons", size - 2);
        this.supply("ships", size - 2);
        if (shipBonus > 0) {
            this.supply(1, "ships", shipBonus, "Orbital works");
        }
        Pair<String, Integer> deficit = this.getMaxDeficit("metals", "rare_metals");
        int maxDeficit = size - 3;
        if ((Integer)deficit.two > maxDeficit) {
            deficit.two = maxDeficit;
        }
        this.applyDeficitToProduction(2, deficit, "heavy_machinery", "supplies", "hand_weapons", "ships");
        if (qualityBonus > 0.0f) {
            this.market.getStats().getDynamic().getMod("production_quality_mod").modifyFlat(this.getModId(1), qualityBonus, "Orbital works");
        }
        if ((stability = this.market.getPrevStability()) < 5.0f) {
            float stabilityMod = (stability - 5.0f) / 5.0f;
            this.market.getStats().getDynamic().getMod("production_quality_mod").modifyFlat(this.getModId(0), stabilityMod *= 0.5f, String.valueOf(this.getNameForModifier()) + " - low stability");
        }
        if (!this.isFunctional()) {
            this.supply.clear();
            this.unapply();
        }
    }

    @Override
    public void unapply() {
        super.unapply();
        this.market.getStats().getDynamic().getMod("production_quality_mod").unmodifyFlat(this.getModId(0));
        this.market.getStats().getDynamic().getMod("production_quality_mod").unmodifyFlat(this.getModId(1));
    }

    @Override
    protected void addPostDemandSection(TooltipMakerAPI tooltip, boolean hasDemand, Industry.IndustryTooltipMode mode) {
        boolean works;
        if ((mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional()) && (works = "orbitalworks".equals(this.getId()))) {
            float total = ORBITAL_WORKS_QUALITY_BONUS;
            String totalStr = "+" + Math.round(total * 100.0f) + "%";
            Color h = Misc.getHighlightColor();
            if (total < 0.0f) {
                h = Misc.getNegativeHighlightColor();
                totalStr = Math.round(total * 100.0f) + "%";
            }
            float opad = 10.0f;
            if (total >= 0.0f) {
                tooltip.addPara("Ship quality: %s", opad, h, totalStr);
                tooltip.addPara("*Quality bonus only applies for the largest ship producer in the faction.", Misc.getGrayColor(), opad);
            }
        }
    }

    @Override
    public boolean isDemandLegal(CommodityOnMarketAPI com) {
        return true;
    }

    @Override
    public boolean isSupplyLegal(CommodityOnMarketAPI com) {
        return true;
    }

    @Override
    protected boolean canImproveToIncreaseProduction() {
        return true;
    }

    @Override
    public boolean wantsToUseSpecialItem(SpecialItemData data) {
        if (this.special != null && "corrupted_nanoforge".equals(this.special.getId()) && data != null && "pristine_nanoforge".equals(data.getId())) {
            return true;
        }
        return super.wantsToUseSpecialItem(data);
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        if (this.special != null) {
            float days = Global.getSector().getClock().convertToDays(amount);
            this.daysWithNanoforge += days;
            this.updatePollutionStatus();
        }
    }

    protected void updatePollutionStatus() {
        if (!this.market.hasCondition("habitable")) {
            return;
        }
        if (this.special != null) {
            if (!this.addedPollution && this.daysWithNanoforge >= DAYS_BEFORE_POLLUTION) {
                if (this.market.hasCondition(POLLUTION_ID)) {
                    this.permaPollution = true;
                } else {
                    this.market.addCondition(POLLUTION_ID);
                    this.addedPollution = true;
                }
            }
            if (this.addedPollution && !this.permaPollution && this.daysWithNanoforge > DAYS_BEFORE_POLLUTION_PERMANENT) {
                this.permaPollution = true;
            }
        } else if (this.addedPollution && !this.permaPollution) {
            this.market.removeCondition(POLLUTION_ID);
            this.addedPollution = false;
        }
    }

    public boolean isPermaPollution() {
        return this.permaPollution;
    }

    public void setPermaPollution(boolean permaPollution) {
        this.permaPollution = permaPollution;
    }

    public boolean isAddedPollution() {
        return this.addedPollution;
    }

    public void setAddedPollution(boolean addedPollution) {
        this.addedPollution = addedPollution;
    }

    public float getDaysWithNanoforge() {
        return this.daysWithNanoforge;
    }

    public void setDaysWithNanoforge(float daysWithNanoforge) {
        this.daysWithNanoforge = daysWithNanoforge;
    }

    @Override
    public void setSpecialItem(SpecialItemData special) {
        super.setSpecialItem(special);
        this.updatePollutionStatus();
    }
}

