/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.InstallableIndustryItemPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.MarketConditionSpecAPI;
import com.fs.starfarer.api.impl.campaign.FusionLampEntityPlugin;
import com.fs.starfarer.api.impl.campaign.econ.ResourceDepositsCondition;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseInstallableItemEffect;
import com.fs.starfarer.api.impl.campaign.econ.impl.BoostIndustryInstallableItemEffect;
import com.fs.starfarer.api.impl.campaign.econ.impl.InstallableItemEffect;
import com.fs.starfarer.api.impl.campaign.econ.impl.PopulationAndInfrastructure;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ItemEffectsRepo {
    public static String NOT_A_GAS_GIANT = "not a gas giant";
    public static String NOT_HABITABLE = "not habitable";
    public static String HABITABLE = "habitable";
    public static String GAS_GIANT = "gas giant";
    public static String NO_ATMOSPHERE = "no atmosphere";
    public static String NOT_EXTREME_WEATHER = "no extreme weather";
    public static String NOT_EXTREME_TECTONIC_ACTIVITY = "no extreme tectonic activity";
    public static String NO_TRANSPLUTONIC_ORE_DEPOSITS = "no transplutonic ore deposits";
    public static String NO_VOLATILES_DEPOSITS = "no volatiles deposits";
    public static String HOT_OR_EXTREME_HEAT = "hot or extreme heat";
    public static String COLD_OR_EXTREME_COLD = "cold or extreme cold";
    public static int CORONAL_TAP_LIGHT_YEARS = 10;
    public static String CORONAL_TAP_RANGE = "coronal hypershunt within " + CORONAL_TAP_LIGHT_YEARS + " light-years";
    public static int CORONAL_TAP_TRANSPLUTONICS = 10;
    public static int CORONAL_TAP_INDUSTRIES = 1;
    public static int FUSION_LAMP_FARMING_BONUS = 0;
    public static int FUSION_LAMP_VOLATILES = 10;
    public static float FUSION_LAMP_SHORTAGE_HAZARD = 0.5f;
    public static List<String> FUSION_LAMP_CONDITIONS = new ArrayList<String>();
    public static float CORRUPTED_NANOFORGE_QUALITY_BONUS;
    public static float PRISTINE_NANOFORGE_QUALITY_BONUS;
    public static int CORRUPTED_NANOFORGE_PROD;
    public static int PRISTINE_NANOFORGE_PROD;
    public static int SYNCHROTRON_FUEL_BONUS;
    public static int MANTLE_BORE_MINING_BONUS;
    public static List<String> MANTLE_BORE_COMMODITIES;
    public static int PLASMA_DYNAMO_MINING_BONUS;
    public static List<String> PLASMA_DYNAMO_COMMODITIES;
    public static int BIOFACTORY_PROD_BONUS;
    public static int CATALYTIC_CORE_BONUS;
    public static float FULLERENE_SPOOL_ACCESS_BONUS;
    public static int SOIL_NANITES_BONUS;
    public static float CRYOARITHMETIC_FLEET_SIZE_BONUS_HOT;
    public static float CRYOARITHMETIC_FLEET_SIZE_BONUS_VERY_HOT;
    public static float DRONE_REPLICATOR_BONUS_MULT;
    public static int DEALMAKER_INCOME_PERCENT_BONUS;
    public static Map<String, InstallableItemEffect> ITEM_EFFECTS;

    static {
        FUSION_LAMP_CONDITIONS.add("cold");
        FUSION_LAMP_CONDITIONS.add("very_cold");
        FUSION_LAMP_CONDITIONS.add("poor_light");
        FUSION_LAMP_CONDITIONS.add("dark");
        CORRUPTED_NANOFORGE_QUALITY_BONUS = 0.2f;
        PRISTINE_NANOFORGE_QUALITY_BONUS = 0.5f;
        CORRUPTED_NANOFORGE_PROD = 1;
        PRISTINE_NANOFORGE_PROD = 3;
        SYNCHROTRON_FUEL_BONUS = 3;
        MANTLE_BORE_MINING_BONUS = 3;
        MANTLE_BORE_COMMODITIES = new ArrayList<String>();
        MANTLE_BORE_COMMODITIES.add("ore");
        MANTLE_BORE_COMMODITIES.add("rare_ore");
        MANTLE_BORE_COMMODITIES.add("organics");
        PLASMA_DYNAMO_MINING_BONUS = 3;
        PLASMA_DYNAMO_COMMODITIES = new ArrayList<String>();
        PLASMA_DYNAMO_COMMODITIES.add("volatiles");
        BIOFACTORY_PROD_BONUS = 2;
        CATALYTIC_CORE_BONUS = 3;
        FULLERENE_SPOOL_ACCESS_BONUS = 0.3f;
        SOIL_NANITES_BONUS = 2;
        CRYOARITHMETIC_FLEET_SIZE_BONUS_HOT = 0.25f;
        CRYOARITHMETIC_FLEET_SIZE_BONUS_VERY_HOT = 1.0f;
        DRONE_REPLICATOR_BONUS_MULT = 1.5f;
        DEALMAKER_INCOME_PERCENT_BONUS = 50;
        ITEM_EFFECTS = new HashMap<String, InstallableItemEffect>(){
            {
                this.put("orbital_fusion_lamp", new BaseInstallableItemEffect("orbital_fusion_lamp"){

                    @Override
                    public void apply(Industry industry) {
                        Industry farming = this.getFarming(industry);
                        if (farming != null && FUSION_LAMP_FARMING_BONUS > 0) {
                            if (farming.isFunctional()) {
                                farming.getSupplyBonusFromOther().modifyFlat(this.spec.getId(), FUSION_LAMP_FARMING_BONUS, String.valueOf(Misc.ucFirst(this.spec.getName().toLowerCase())) + " (" + industry.getCurrentName() + ")");
                            } else {
                                farming.getSupplyBonusFromOther().unmodifyFlat(this.spec.getId());
                            }
                        }
                        if (industry instanceof BaseIndustry) {
                            BaseIndustry b = (BaseIndustry)industry;
                            b.demand(9, "volatiles", FUSION_LAMP_VOLATILES, Misc.ucFirst(this.spec.getName().toLowerCase()));
                            MemoryAPI memory = this.getLampMemory(industry);
                            float h = this.getShortageHazard(industry);
                            if (h > 0.0f) {
                                industry.getMarket().getHazard().modifyFlat(this.spec.getId(), h, String.valueOf(Misc.ucFirst(this.spec.getName().toLowerCase())) + " volatiles shortage");
                                if (memory != null) {
                                    memory.set(FusionLampEntityPlugin.VOLATILES_SHORTAGE_KEY, Float.valueOf(h / FUSION_LAMP_SHORTAGE_HAZARD));
                                }
                            }
                        }
                        for (String id : FUSION_LAMP_CONDITIONS) {
                            industry.getMarket().suppressCondition(id);
                        }
                    }

                    @Override
                    public void unapply(Industry industry) {
                        Industry farming = this.getFarming(industry);
                        if (farming != null && FUSION_LAMP_FARMING_BONUS > 0) {
                            farming.getSupplyBonusFromOther().unmodifyFlat(this.spec.getId());
                        }
                        if (industry instanceof BaseIndustry) {
                            BaseIndustry b = (BaseIndustry)industry;
                            b.demand(9, "volatiles", 0, null);
                            industry.getMarket().getHazard().unmodifyFlat(this.spec.getId());
                            MemoryAPI memory = this.getLampMemory(industry);
                            if (memory != null) {
                                memory.unset(FusionLampEntityPlugin.VOLATILES_SHORTAGE_KEY);
                            }
                        }
                        for (String id : FUSION_LAMP_CONDITIONS) {
                            industry.getMarket().unsuppressCondition(id);
                        }
                    }

                    protected MemoryAPI getLampMemory(Industry industry) {
                        if (industry instanceof PopulationAndInfrastructure) {
                            PopulationAndInfrastructure b = (PopulationAndInfrastructure)industry;
                            if (b.lamp != null) {
                                return b.lamp.getMemoryWithoutUpdate();
                            }
                        }
                        return null;
                    }

                    protected float getShortageHazard(Industry industry) {
                        int volatilesDemand = industry.getDemand("volatiles").getQuantity().getModifiedInt();
                        if (volatilesDemand <= 0 || FUSION_LAMP_SHORTAGE_HAZARD <= 0.0f) {
                            return 0.0f;
                        }
                        float v = industry.getMarket().getCommodityData("volatiles").getAvailable();
                        float f = 1.0f - v / (float)volatilesDemand;
                        float h = (float)Math.round(f * FUSION_LAMP_SHORTAGE_HAZARD * 100.0f) / 100.0f;
                        if (h > 0.0f) {
                            industry.getMarket().getHazard().modifyFlat(this.spec.getId(), h, String.valueOf(Misc.ucFirst(this.spec.getName().toLowerCase())) + " volatiles shortage");
                        }
                        return h;
                    }

                    protected Industry getFarming(Industry industry) {
                        String farmingId = "farming";
                        Industry farming = industry.getMarket().getIndustry(farmingId);
                        if (farming == null) {
                            farmingId = "aquaculture";
                            farming = industry.getMarket().getIndustry(farmingId);
                        }
                        return farming;
                    }

                    @Override
                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        text.addPara(String.valueOf(pre) + "Increases heat on non-cold planets. " + "Adds demand for %s units of volatiles.", pad, Misc.getHighlightColor(), "" + FUSION_LAMP_VOLATILES);
                    }

                    @Override
                    public String getSpecialNotesName() {
                        return "Counters";
                    }

                    @Override
                    public List<String> getSpecialNotes(Industry industry) {
                        ArrayList<String> conds = new ArrayList<String>();
                        for (String id : FUSION_LAMP_CONDITIONS) {
                            MarketConditionSpecAPI mc = Global.getSettings().getMarketConditionSpec(id);
                            conds.add(mc.getName().toLowerCase());
                        }
                        return conds;
                    }

                    @Override
                    public Set<String> getConditionsRelatedToRequirements(Industry industry) {
                        Set<String> list = super.getConditionsRelatedToRequirements(industry);
                        list.addAll(FUSION_LAMP_CONDITIONS);
                        list.add("hot");
                        list.add("very_hot");
                        return list;
                    }
                });
                this.put("corrupted_nanoforge", new BoostIndustryInstallableItemEffect("corrupted_nanoforge", CORRUPTED_NANOFORGE_PROD, 0){

                    @Override
                    public void apply(Industry industry) {
                        super.apply(industry);
                        industry.getMarket().getStats().getDynamic().getMod("production_quality_mod").modifyFlat("nanoforge", CORRUPTED_NANOFORGE_QUALITY_BONUS, Misc.ucFirst(this.spec.getName().toLowerCase()));
                    }

                    @Override
                    public void unapply(Industry industry) {
                        super.unapply(industry);
                        industry.getMarket().getStats().getDynamic().getMod("production_quality_mod").unmodifyFlat("nanoforge");
                    }

                    @Override
                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        String heavyIndustry = "heavy industry ";
                        if (mode == InstallableIndustryItemPlugin.InstallableItemDescriptionMode.MANAGE_ITEM_DIALOG_LIST) {
                            heavyIndustry = "";
                        }
                        text.addPara(String.valueOf(pre) + "Increases ship and weapon production quality by %s. " + "Increases " + heavyIndustry + "production by %s unit." + " On habitable worlds, causes pollution which becomes permanent.", pad, Misc.getHighlightColor(), Math.round(CORRUPTED_NANOFORGE_QUALITY_BONUS * 100.0f) + "%", "" + CORRUPTED_NANOFORGE_PROD);
                    }
                });
                this.put("pristine_nanoforge", new BoostIndustryInstallableItemEffect("pristine_nanoforge", PRISTINE_NANOFORGE_PROD, 0){

                    @Override
                    public void apply(Industry industry) {
                        super.apply(industry);
                        industry.getMarket().getStats().getDynamic().getMod("production_quality_mod").modifyFlat("nanoforge", PRISTINE_NANOFORGE_QUALITY_BONUS, Misc.ucFirst(this.spec.getName().toLowerCase()));
                    }

                    @Override
                    public void unapply(Industry industry) {
                        super.unapply(industry);
                        industry.getMarket().getStats().getDynamic().getMod("production_quality_mod").unmodifyFlat("nanoforge");
                    }

                    @Override
                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        String heavyIndustry = "heavy industry ";
                        if (mode == InstallableIndustryItemPlugin.InstallableItemDescriptionMode.MANAGE_ITEM_DIALOG_LIST) {
                            heavyIndustry = "";
                        }
                        text.addPara(String.valueOf(pre) + "Increases ship and weapon production quality by %s. " + "Increases " + heavyIndustry + "production by %s units." + " On habitable worlds, causes pollution which becomes permanent.", pad, Misc.getHighlightColor(), Math.round(PRISTINE_NANOFORGE_QUALITY_BONUS * 100.0f) + "%", "" + PRISTINE_NANOFORGE_PROD);
                    }
                });
                this.put("synchrotron", new BoostIndustryInstallableItemEffect("synchrotron", SYNCHROTRON_FUEL_BONUS, 0){

                    @Override
                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        text.addPara(String.valueOf(pre) + "Increases fuel production output by %s units.", pad, Misc.getHighlightColor(), "" + SYNCHROTRON_FUEL_BONUS);
                    }

                    @Override
                    public String[] getSimpleReqs(Industry industry) {
                        return new String[]{NO_ATMOSPHERE};
                    }
                });
                this.put("mantle_bore", new BaseInstallableItemEffect("mantle_bore"){

                    protected Set<String> getAffectedCommodities(Industry industry) {
                        MarketAPI market = industry.getMarket();
                        LinkedHashSet<String> result = new LinkedHashSet<String>();
                        for (MarketConditionAPI mc : market.getConditions()) {
                            String cid = mc.getId();
                            String commodity = ResourceDepositsCondition.COMMODITY.get(cid);
                            for (String curr : MANTLE_BORE_COMMODITIES) {
                                if (!curr.equals(commodity)) continue;
                                result.add(curr);
                            }
                        }
                        return result;
                    }

                    @Override
                    public void apply(Industry industry) {
                        if (industry instanceof BaseIndustry) {
                            BaseIndustry b = (BaseIndustry)industry;
                            Set<String> list = this.getAffectedCommodities(industry);
                            if (!list.isEmpty()) {
                                for (String curr : list) {
                                    b.supply(this.spec.getId(), curr, MANTLE_BORE_MINING_BONUS, Misc.ucFirst(this.spec.getName().toLowerCase()));
                                }
                            }
                        }
                    }

                    @Override
                    public void unapply(Industry industry) {
                        if (industry instanceof BaseIndustry) {
                            BaseIndustry b = (BaseIndustry)industry;
                            for (String curr : MANTLE_BORE_COMMODITIES) {
                                b.supply(this.spec.getId(), curr, 0, null);
                            }
                        }
                    }

                    @Override
                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        ArrayList<String> commodities = new ArrayList<String>();
                        for (String curr : MANTLE_BORE_COMMODITIES) {
                            CommoditySpecAPI c = Global.getSettings().getCommoditySpec(curr);
                            commodities.add(c.getName().toLowerCase());
                        }
                        text.addPara(String.valueOf(pre) + "Increases " + Misc.getAndJoined(commodities) + " production by %s units.", pad, Misc.getHighlightColor(), "" + MANTLE_BORE_MINING_BONUS);
                    }

                    @Override
                    public String[] getSimpleReqs(Industry industry) {
                        return new String[]{NOT_A_GAS_GIANT, NOT_HABITABLE};
                    }
                });
                this.put("plasma_dynamo", new BaseInstallableItemEffect("plasma_dynamo"){

                    protected Set<String> getAffectedCommodities(Industry industry) {
                        MarketAPI market = industry.getMarket();
                        LinkedHashSet<String> result = new LinkedHashSet<String>();
                        for (MarketConditionAPI mc : market.getConditions()) {
                            String cid = mc.getId();
                            String commodity = ResourceDepositsCondition.COMMODITY.get(cid);
                            for (String curr : PLASMA_DYNAMO_COMMODITIES) {
                                if (!curr.equals(commodity)) continue;
                                result.add(curr);
                            }
                        }
                        return result;
                    }

                    @Override
                    public void apply(Industry industry) {
                        if (industry instanceof BaseIndustry) {
                            BaseIndustry b = (BaseIndustry)industry;
                            Set<String> list = this.getAffectedCommodities(industry);
                            if (!list.isEmpty()) {
                                for (String curr : list) {
                                    b.supply(this.spec.getId(), curr, PLASMA_DYNAMO_MINING_BONUS, Misc.ucFirst(this.spec.getName().toLowerCase()));
                                }
                            }
                        }
                    }

                    @Override
                    public void unapply(Industry industry) {
                        if (industry instanceof BaseIndustry) {
                            BaseIndustry b = (BaseIndustry)industry;
                            for (String curr : PLASMA_DYNAMO_COMMODITIES) {
                                b.supply(this.spec.getId(), curr, 0, null);
                            }
                        }
                    }

                    @Override
                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        ArrayList<String> commodities = new ArrayList<String>();
                        for (String curr : PLASMA_DYNAMO_COMMODITIES) {
                            CommoditySpecAPI c = Global.getSettings().getCommoditySpec(curr);
                            commodities.add(c.getName().toLowerCase());
                        }
                        text.addPara(String.valueOf(pre) + "Increases " + Misc.getAndJoined(commodities) + " production by %s units.", pad, Misc.getHighlightColor(), "" + PLASMA_DYNAMO_MINING_BONUS);
                    }

                    @Override
                    public String[] getSimpleReqs(Industry industry) {
                        return new String[]{GAS_GIANT};
                    }
                });
                this.put("biofactory_embryo", new BoostIndustryInstallableItemEffect("biofactory_embryo", BIOFACTORY_PROD_BONUS, 0){

                    @Override
                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        text.addPara(String.valueOf(pre) + "Increases light industry production by %s units.", pad, Misc.getHighlightColor(), "" + BIOFACTORY_PROD_BONUS);
                    }

                    @Override
                    public String[] getSimpleReqs(Industry industry) {
                        return new String[]{HABITABLE};
                    }
                });
                this.put("catalytic_core", new BoostIndustryInstallableItemEffect("catalytic_core", CATALYTIC_CORE_BONUS, 0){

                    @Override
                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        text.addPara(String.valueOf(pre) + "Increases refining production by %s units.", pad, Misc.getHighlightColor(), "" + CATALYTIC_CORE_BONUS);
                    }

                    @Override
                    public String[] getSimpleReqs(Industry industry) {
                        return new String[]{NO_ATMOSPHERE};
                    }
                });
                this.put("fullerene_spool", new BaseInstallableItemEffect("fullerene_spool"){

                    @Override
                    public void apply(Industry industry) {
                        industry.getMarket().getAccessibilityMod().modifyFlat(this.spec.getId(), FULLERENE_SPOOL_ACCESS_BONUS, Misc.ucFirst(this.spec.getName().toLowerCase()));
                    }

                    @Override
                    public void unapply(Industry industry) {
                        industry.getMarket().getAccessibilityMod().unmodifyFlat(this.spec.getId());
                    }

                    @Override
                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        text.addPara(String.valueOf(pre) + "Increases colony accessibility by %s.", pad, Misc.getHighlightColor(), Math.round(FULLERENE_SPOOL_ACCESS_BONUS * 100.0f) + "%");
                    }

                    @Override
                    public String[] getSimpleReqs(Industry industry) {
                        return new String[]{NOT_A_GAS_GIANT, NOT_EXTREME_WEATHER, NOT_EXTREME_TECTONIC_ACTIVITY};
                    }
                });
                this.put("soil_nanites", new BoostIndustryInstallableItemEffect("soil_nanites", SOIL_NANITES_BONUS, 0){

                    @Override
                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        text.addPara(String.valueOf(pre) + "Increases farming production by %s units.", pad, Misc.getHighlightColor(), "" + SOIL_NANITES_BONUS);
                    }

                    @Override
                    public String[] getSimpleReqs(Industry industry) {
                        return new String[]{NO_TRANSPLUTONIC_ORE_DEPOSITS, NO_VOLATILES_DEPOSITS};
                    }
                });
                this.put("cryoarithmetic_engine", new BaseInstallableItemEffect("cryoarithmetic_engine"){

                    @Override
                    public void apply(Industry industry) {
                        float bonus = 0.0f;
                        if (industry.getMarket().hasCondition("hot")) {
                            bonus = CRYOARITHMETIC_FLEET_SIZE_BONUS_HOT;
                        } else if (industry.getMarket().hasCondition("very_hot")) {
                            bonus = CRYOARITHMETIC_FLEET_SIZE_BONUS_VERY_HOT;
                        }
                        industry.getMarket().getStats().getDynamic().getMod("combat_fleet_size_mult").modifyFlat(this.spec.getId(), bonus, Misc.ucFirst(this.spec.getName().toLowerCase()));
                    }

                    @Override
                    public void unapply(Industry industry) {
                        industry.getMarket().getStats().getDynamic().getMod("combat_fleet_size_mult").unmodifyFlat(this.spec.getId());
                    }

                    @Override
                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        text.addPara(String.valueOf(pre) + "Increases size of fleets launched by colony by %s for hot worlds, and " + "by %s for worlds with extreme heat.", pad, Misc.getHighlightColor(), Math.round(CRYOARITHMETIC_FLEET_SIZE_BONUS_HOT * 100.0f) + "%", Math.round(CRYOARITHMETIC_FLEET_SIZE_BONUS_VERY_HOT * 100.0f) + "%");
                    }

                    @Override
                    public String[] getSimpleReqs(Industry industry) {
                        return new String[]{HOT_OR_EXTREME_HEAT};
                    }
                });
                this.put("drone_replicator", new BaseInstallableItemEffect("drone_replicator"){

                    @Override
                    public void apply(Industry industry) {
                        industry.getMarket().getStats().getDynamic().getMod("ground_defenses_mod").modifyMult(this.spec.getId(), DRONE_REPLICATOR_BONUS_MULT, Misc.ucFirst(this.spec.getName().toLowerCase()));
                    }

                    @Override
                    public void unapply(Industry industry) {
                        industry.getMarket().getStats().getDynamic().getMod("ground_defenses_mod").unmodifyMult(this.spec.getId());
                    }

                    @Override
                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        text.addPara(String.valueOf(pre) + "Colony's ground defenses increased by %s.", pad, Misc.getHighlightColor(), "\u00d7" + DRONE_REPLICATOR_BONUS_MULT);
                    }
                });
                this.put("dealmaker_holosuite", new BaseInstallableItemEffect("dealmaker_holosuite"){

                    @Override
                    public void apply(Industry industry) {
                        industry.getMarket().getIncomeMult().modifyPercent(this.spec.getId(), DEALMAKER_INCOME_PERCENT_BONUS, Misc.ucFirst(this.spec.getName().toLowerCase()));
                    }

                    @Override
                    public void unapply(Industry industry) {
                        industry.getMarket().getIncomeMult().unmodifyPercent(this.spec.getId());
                    }

                    @Override
                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        text.addPara(String.valueOf(pre) + "Colony's income increased by %s.", pad, Misc.getHighlightColor(), DEALMAKER_INCOME_PERCENT_BONUS + "%");
                    }
                });
                this.put("coronal_portal", new BaseInstallableItemEffect("coronal_portal"){

                    @Override
                    public void apply(Industry industry) {
                        if (industry instanceof BaseIndustry) {
                            BaseIndustry b = (BaseIndustry)industry;
                            b.demand(8, "rare_metals", CORONAL_TAP_TRANSPLUTONICS, Misc.ucFirst(this.spec.getName().toLowerCase()));
                            if (!this.hasShortage(industry)) {
                                industry.getMarket().getStats().getDynamic().getMod("max_industries").modifyFlat(this.spec.getId(), CORONAL_TAP_INDUSTRIES);
                            } else {
                                industry.getMarket().getStats().getDynamic().getMod("max_industries").unmodifyFlat(this.spec.getId());
                            }
                        }
                    }

                    @Override
                    public void unapply(Industry industry) {
                        if (industry instanceof BaseIndustry) {
                            BaseIndustry b = (BaseIndustry)industry;
                            b.demand(8, "rare_metals", 0, null);
                            industry.getMarket().getStats().getDynamic().getMod("max_industries").unmodifyFlat(this.spec.getId());
                        }
                    }

                    protected boolean hasShortage(Industry industry) {
                        int transplutonicsDemand = industry.getDemand("rare_metals").getQuantity().getModifiedInt();
                        float v = industry.getMarket().getCommodityData("rare_metals").getAvailable();
                        float f = 1.0f - v / (float)transplutonicsDemand;
                        return f > 0.0f;
                    }

                    @Override
                    protected void addItemDescriptionImpl(Industry industry, TooltipMakerAPI text, SpecialItemData data, InstallableIndustryItemPlugin.InstallableItemDescriptionMode mode, String pre, float pad) {
                        text.addPara(String.valueOf(pre) + "Increases the maximum number of industries at a colony by %s when demand for " + "%s units of transplutonics is fully met.", pad, Misc.getHighlightColor(), "" + CORONAL_TAP_INDUSTRIES, "" + CORONAL_TAP_TRANSPLUTONICS);
                    }

                    @Override
                    public String[] getSimpleReqs(Industry industry) {
                        return new String[]{CORONAL_TAP_RANGE};
                    }
                });
            }
        };
    }
}

