/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.util.Pair;

public class LightIndustry
extends BaseIndustry {
    @Override
    public void apply() {
        super.apply(true);
        int size = this.market.getSize();
        this.demand("organics", size);
        this.supply("domestic_goods", size);
        if (!this.market.isIllegal("luxury_goods")) {
            this.supply("luxury_goods", size - 2);
        } else {
            this.supply("luxury_goods", 0);
        }
        if (!this.market.isIllegal("drugs")) {
            this.supply("drugs", size - 2);
        } else {
            this.supply("drugs", 0);
        }
        Pair<String, Integer> deficit = this.getMaxDeficit("organics");
        this.applyDeficitToProduction(1, deficit, "domestic_goods", "luxury_goods", "drugs");
        if (!this.isFunctional()) {
            this.supply.clear();
        }
    }

    @Override
    public void unapply() {
        super.unapply();
    }

    @Override
    public String getCurrentImage() {
        float size = this.market.getSize();
        PlanetAPI planet = this.market.getPlanetEntity();
        if (planet == null || planet.isGasGiant()) {
            if (size <= (float)SIZE_FOR_SMALL_IMAGE) {
                return Global.getSettings().getSpriteName("industry", "light_industry_orbital_low");
            }
            if (size >= (float)SIZE_FOR_LARGE_IMAGE) {
                return Global.getSettings().getSpriteName("industry", "light_industry_orbital_high");
            }
            return Global.getSettings().getSpriteName("industry", "light_industry_orbital");
        }
        if (size <= (float)SIZE_FOR_SMALL_IMAGE) {
            return Global.getSettings().getSpriteName("industry", "light_industry_low");
        }
        if (size >= (float)SIZE_FOR_LARGE_IMAGE) {
            return Global.getSettings().getSpriteName("industry", "light_industry_high");
        }
        return super.getCurrentImage();
    }

    @Override
    protected boolean canImproveToIncreaseProduction() {
        return true;
    }
}

