/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.EconomyAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.combat.StatBonus;
import java.util.HashMap;
import java.util.Map;

public class ShipQuality
implements EconomyAPI.EconomyUpdateListener {
    public static final String KEY = "$core_shipQualityManager";
    protected transient Map<String, QualityData> data = new HashMap<String, QualityData>();
    public static float IMPORT_PENALTY = Global.getSettings().getFloat("qualityPenaltyForImports");

    public static ShipQuality getInstance() {
        Object test = Global.getSector().getMemoryWithoutUpdate().get(KEY);
        if (test == null) {
            test = new ShipQuality();
            Global.getSector().getMemoryWithoutUpdate().set(KEY, test);
        }
        return (ShipQuality)test;
    }

    protected Object readResolve() {
        this.data = new HashMap<String, QualityData>();
        return this;
    }

    public ShipQuality() {
        Global.getSector().getEconomy().addUpdateListener(this);
    }

    public String getKey(MarketAPI market) {
        return String.valueOf(market.getFactionId()) + "_" + market.getEconGroup();
    }

    @Override
    public void economyUpdated() {
        this.data.clear();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            float q;
            QualityData d = this.getQualityData(market);
            CommodityOnMarketAPI com = market.getCommodityData("ships");
            int prod = Math.min(com.getAvailable(), com.getMaxSupply());
            int inFactionShipping = com.getCommodityMarketData().getMaxShipping(market, true);
            prod = Math.min(prod, inFactionShipping);
            prod = Math.max(Math.min(com.getAvailable(), com.getMaxSupply()), prod);
            if (prod < d.prod || prod <= 0 || !((q = market.getStats().getDynamic().getMod("production_quality_mod").computeEffective(0.0f)) >= d.qMod) && prod <= d.prod) continue;
            d.prod = prod;
            d.qMod = q;
            d.market = market;
            d.quality = market.getStats().getDynamic().getMod("production_quality_mod");
        }
    }

    public QualityData getQualityData(MarketAPI market) {
        String key = this.getKey(market);
        QualityData d = this.data.get(key);
        if (d == null) {
            d = new QualityData(market.getEconGroup(), market.getFaction());
            if (!market.isHidden()) {
                d.quality.modifyFlat("no_prod_penalty", IMPORT_PENALTY, "Cross-faction imports");
            }
            d.prod = -1;
            d.qMod = -1.0f;
            this.data.put(key, d);
        }
        return d;
    }

    @Override
    public void commodityUpdated(String commodityId) {
    }

    @Override
    public boolean isEconomyListenerExpired() {
        return false;
    }

    public static float getShipQuality(MarketAPI market, String factionId) {
        float quality = 0.0f;
        if (market != null) {
            QualityData d = ShipQuality.getInstance().getQualityData(market);
            quality = d.quality.computeEffective(0.0f);
            quality += market.getStats().getDynamic().getMod("fleet_quality_mod").computeEffective(0.0f);
        }
        if (factionId != null) {
            if (market != null && market.getFaction() != null) {
                quality -= market.getFaction().getDoctrine().getShipQualityContribution();
            }
            quality += Global.getSector().getFaction(factionId).getDoctrine().getShipQualityContribution();
        }
        return quality;
    }

    public static class QualityData {
        public String econGroup;
        public FactionAPI faction;
        public StatBonus quality = new StatBonus();
        public MarketAPI market;
        public int prod;
        public float qMod = 0.0f;

        public QualityData(String econGroup, FactionAPI faction) {
            this.econGroup = econGroup;
            this.faction = faction;
        }
    }
}

