/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SubmarketPlugin;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HyperspaceTopographyEventIntel;
import com.fs.starfarer.api.impl.campaign.submarkets.LocalResourcesSubmarketPlugin;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Pair;
import java.awt.Color;

public class Waystation
extends BaseIndustry {
    public static float UPKEEP_MULT_PER_DEFICIT = 0.1f;
    public static float BASE_ACCESSIBILITY = 0.1f;
    public static float IMPROVE_ACCESSIBILITY = 0.2f;
    public static float ALPHA_CORE_ACCESSIBILITY = 0.2f;

    @Override
    public void apply() {
        HyperspaceTopographyEventIntel intel;
        SubmarketPlugin sub;
        super.apply(true);
        int size = this.market.getSize();
        this.demand("fuel", size);
        this.demand("supplies", size);
        this.demand("crew", size);
        this.demand("volatiles", 1);
        this.demand("rare_metals", 1);
        String desc = this.getNameForModifier();
        this.market.setHasWaystation(true);
        float a = BASE_ACCESSIBILITY;
        if (a > 0.0f) {
            this.market.getAccessibilityMod().modifyFlat(this.getModId(0), a, desc);
        }
        if (this.market.isPlayerOwned() && (sub = Misc.getLocalResources(this.market)) instanceof LocalResourcesSubmarketPlugin) {
            LocalResourcesSubmarketPlugin lr = (LocalResourcesSubmarketPlugin)sub;
            float mult = Global.getSettings().getFloat("stockpileMultExcess");
            lr.getStockpilingBonus("fuel").modifyFlat(this.getModId(0), (float)size * mult);
            lr.getStockpilingBonus("supplies").modifyFlat(this.getModId(0), (float)size * mult);
            lr.getStockpilingBonus("crew").modifyFlat(this.getModId(0), (float)size * mult);
            lr.getStockpilingBonus("volatiles").modifyFlat(this.getModId(0), 1.0f * mult);
            lr.getStockpilingBonus("rare_metals").modifyFlat(this.getModId(0), 1.0f * mult);
        }
        if ((intel = HyperspaceTopographyEventIntel.get()) != null && intel.isStageActive((Object)HyperspaceTopographyEventIntel.Stage.SLIPSTREAM_DETECTION)) {
            this.market.getStats().getDynamic().getMod("slipstream_reveal_range_ly_mod").modifyFlat(this.getModId(0), HyperspaceTopographyEventIntel.WAYSTATION_BONUS, this.getNameForModifier());
        }
        if (!this.isFunctional()) {
            this.supply.clear();
            this.unapply();
        }
    }

    @Override
    public void unapply() {
        SubmarketPlugin sub;
        super.unapply();
        this.market.setHasWaystation(false);
        this.market.getAccessibilityMod().unmodifyFlat(this.getModId(0));
        this.market.getAccessibilityMod().unmodifyFlat(this.getModId(1));
        this.market.getAccessibilityMod().unmodifyFlat(this.getModId(2));
        this.market.getStats().getDynamic().getMod("slipstream_reveal_range_ly_mod").unmodifyFlat(this.getModId(0));
        if (this.market.isPlayerOwned() && (sub = Misc.getLocalResources(this.market)) instanceof LocalResourcesSubmarketPlugin) {
            LocalResourcesSubmarketPlugin lr = (LocalResourcesSubmarketPlugin)sub;
            lr.getStockpilingBonus("fuel").unmodifyFlat(this.getModId(0));
            lr.getStockpilingBonus("supplies").unmodifyFlat(this.getModId(0));
            lr.getStockpilingBonus("crew").unmodifyFlat(this.getModId(0));
            lr.getStockpilingBonus("volatiles").unmodifyFlat(this.getModId(0));
            lr.getStockpilingBonus("rare_metals").unmodifyFlat(this.getModId(0));
        }
    }

    protected float getUpkeepPenalty(Pair<String, Integer> deficit) {
        float loss = (float)((Integer)deficit.two).intValue() * UPKEEP_MULT_PER_DEFICIT;
        if (loss < 0.0f) {
            loss = 0.0f;
        }
        return loss;
    }

    protected Pair<String, Integer> getUpkeepAffectingDeficit() {
        return this.getMaxDeficit("fuel", "supplies", "crew");
    }

    @Override
    protected void addPostDescriptionSection(TooltipMakerAPI tooltip, Industry.IndustryTooltipMode mode) {
        if (!this.market.isPlayerOwned()) {
            return;
        }
        float opad = 10.0f;
        tooltip.addPara("Increases the range at which slipstreams are detected around the colony by %s, once the capability to do so is available.", opad, Misc.getHighlightColor(), "" + (int)HyperspaceTopographyEventIntel.WAYSTATION_BONUS);
    }

    @Override
    protected boolean hasPostDemandSection(boolean hasDemand, Industry.IndustryTooltipMode mode) {
        return mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional();
    }

    @Override
    protected void addPostDemandSection(TooltipMakerAPI tooltip, boolean hasDemand, Industry.IndustryTooltipMode mode) {
        if (mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional()) {
            MutableStat fake = new MutableStat(0.0f);
            String desc = this.getNameForModifier();
            float a = BASE_ACCESSIBILITY;
            if (a > 0.0f) {
                fake.modifyFlat(this.getModId(0), a, desc);
            }
            float total = a;
            String totalStr = "+" + Math.round(total * 100.0f) + "%";
            Color h = Misc.getHighlightColor();
            if (total < 0.0f) {
                h = Misc.getNegativeHighlightColor();
                totalStr = Math.round(total * 100.0f) + "%";
            }
            float opad = 10.0f;
            float pad = 3.0f;
            if (total >= 0.0f) {
                tooltip.addPara("Accessibility bonus: %s", opad, h, totalStr);
            } else {
                tooltip.addPara("Accessibility penalty: %s", opad, h, totalStr);
            }
            tooltip.addPara("As long as demand is met, allows the colony to stockpile fuel, supplies, and crew, even if it does not produce them locally. The stockpile levels exceed those generated by equivalent local production.", opad);
        }
    }

    @Override
    protected void applyAlphaCoreModifiers() {
        SubmarketPlugin sub;
        if (this.market.isPlayerOwned() && (sub = Misc.getLocalResources(this.market)) instanceof LocalResourcesSubmarketPlugin) {
            float bonus = (float)this.market.getSize() * Global.getSettings().getFloat("stockpileMultExcess");
            LocalResourcesSubmarketPlugin lr = (LocalResourcesSubmarketPlugin)sub;
            lr.getStockpilingBonus("fuel").modifyFlat(this.getModId(1), bonus);
            lr.getStockpilingBonus("supplies").modifyFlat(this.getModId(1), bonus);
            lr.getStockpilingBonus("crew").modifyFlat(this.getModId(1), bonus);
        }
    }

    @Override
    protected void applyNoAICoreModifiers() {
        SubmarketPlugin sub;
        if (this.market.isPlayerOwned() && (sub = Misc.getLocalResources(this.market)) instanceof LocalResourcesSubmarketPlugin) {
            LocalResourcesSubmarketPlugin lr = (LocalResourcesSubmarketPlugin)sub;
            lr.getStockpilingBonus("fuel").unmodifyFlat(this.getModId(1));
            lr.getStockpilingBonus("supplies").unmodifyFlat(this.getModId(1));
            lr.getStockpilingBonus("crew").unmodifyFlat(this.getModId(1));
        }
    }

    @Override
    protected void applyAlphaCoreSupplyAndDemandModifiers() {
        this.demandReduction.modifyFlat(this.getModId(0), DEMAND_REDUCTION, "Alpha core");
    }

    @Override
    protected void addAlphaCoreDescription(TooltipMakerAPI tooltip, Industry.AICoreDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        String pre = "Alpha-level AI core currently assigned. ";
        if (mode == Industry.AICoreDescriptionMode.MANAGE_CORE_DIALOG_LIST || mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            pre = "Alpha-level AI core. ";
        }
        float a = ALPHA_CORE_ACCESSIBILITY;
        String aStr = Math.round(a * 100.0f) + "%";
        if (mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            CommoditySpecAPI coreSpec = Global.getSettings().getCommoditySpec(this.aiCoreId);
            TooltipMakerAPI text = tooltip.beginImageWithText(coreSpec.getIconName(), 48.0f);
            text.addPara(String.valueOf(pre) + "Reduces upkeep cost by %s. Reduces demand by %s unit. " + "Greatly increases stockpiles.", 0.0f, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, aStr);
            tooltip.addImageWithText(opad);
            return;
        }
        tooltip.addPara(String.valueOf(pre) + "Reduces upkeep cost by %s. Reduces demand by %s unit. " + "Greatly increases stockpiles.", opad, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, aStr);
    }

    @Override
    public boolean isAvailableToBuild() {
        return this.market.hasSpaceport();
    }

    @Override
    public String getUnavailableReason() {
        return "Requires a functional spaceport";
    }

    @Override
    public boolean canImprove() {
        return true;
    }

    @Override
    protected void applyImproveModifiers() {
        if (this.isImproved()) {
            this.market.getAccessibilityMod().modifyFlat(this.getModId(3), IMPROVE_ACCESSIBILITY, String.valueOf(this.getImprovementsDescForModifiers()) + " (" + this.getNameForModifier() + ")");
        } else {
            this.market.getAccessibilityMod().unmodifyFlat(this.getModId(3));
        }
    }

    @Override
    public void addImproveDesc(TooltipMakerAPI info, Industry.ImprovementDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        float a = IMPROVE_ACCESSIBILITY;
        String aStr = Math.round(a * 100.0f) + "%";
        if (mode == Industry.ImprovementDescriptionMode.INDUSTRY_TOOLTIP) {
            info.addPara("Accessibility increased by %s.", 0.0f, highlight, aStr);
        } else {
            info.addPara("Increases accessibility by %s.", 0.0f, highlight, aStr);
        }
        info.addSpacer(opad);
        super.addImproveDesc(info, mode);
    }
}

