/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.enc;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.NascentGravityWellAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;

public class AbyssalLocationDespawner
implements EveryFrameScript {
    protected IntervalUtil interval = new IntervalUtil(1.0f, 2.0f);
    protected StarSystemAPI system;

    public AbyssalLocationDespawner(StarSystemAPI system) {
        this.system = system;
    }

    @Override
    public void advance(float amount) {
        if (this.system == null) {
            return;
        }
        this.interval.advance(amount);
        if (this.interval.intervalElapsed()) {
            if (this.system.getDaysSinceLastPlayerVisit() < 10.0f) {
                return;
            }
            CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
            if (pf == null) {
                return;
            }
            float distLY = Misc.getDistanceLY(pf.getLocationInHyperspace(), this.system.getLocation());
            if (distLY < 5.0f) {
                return;
            }
            Global.getSector().removeStarSystemNextFrame(this.system);
            ArrayList<SectorEntityToken> remove = new ArrayList<SectorEntityToken>();
            for (SectorEntityToken sectorEntityToken : Global.getSector().getHyperspace().getJumpPoints()) {
                JumpPointAPI.JumpDestination dest;
                JumpPointAPI jp = (JumpPointAPI)sectorEntityToken;
                if (jp.getDestinations().isEmpty() || (dest = jp.getDestinations().get(0)).getDestination() == null || this.system != dest.getDestination().getStarSystem()) continue;
                remove.add(sectorEntityToken);
            }
            for (NascentGravityWellAPI nascentGravityWellAPI : Global.getSector().getHyperspace().getGravityWells()) {
                if (nascentGravityWellAPI.getTarget() == null || this.system != nascentGravityWellAPI.getTarget().getStarSystem()) continue;
                remove.add(nascentGravityWellAPI);
            }
            remove.add(this.system.getHyperspaceAnchor());
            for (SectorEntityToken sectorEntityToken : remove) {
                Global.getSector().getHyperspace().removeEntity(sectorEntityToken);
            }
            this.system = null;
        }
    }

    @Override
    public boolean isDone() {
        return this.system == null;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }
}

