/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.enc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.fleet.ShipRolePick;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.DerelictShipEntityPlugin;
import com.fs.starfarer.api.impl.campaign.enc.AbyssalFrequencies;
import com.fs.starfarer.api.impl.campaign.enc.AbyssalRogueStellarObjectEPEC;
import com.fs.starfarer.api.impl.campaign.enc.EncounterManager;
import com.fs.starfarer.api.impl.campaign.enc.EncounterPoint;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.ShipRecoverySpecial;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceAbyssPluginImpl;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.ReadableVector2f;

public class AbyssalRogueStellarObjectDireHintsEPEC
extends AbyssalRogueStellarObjectEPEC {
    public static WeightedRandomPicker<AbyssalDireHintType> DIRE_HINT_TYPES = new WeightedRandomPicker();

    static {
        DIRE_HINT_TYPES.add(AbyssalDireHintType.MINING_OP, 10.0f);
        DIRE_HINT_TYPES.add(AbyssalDireHintType.GAS_GIANT_TURBULENCE, 10.0f);
        DIRE_HINT_TYPES.add(AbyssalDireHintType.BLACK_HOLE_READINGS, 10.0f);
        DIRE_HINT_TYPES.add(AbyssalDireHintType.GHOST_SHIP, 20.0f);
    }

    @Override
    public float getFrequencyForPoint(EncounterManager manager, EncounterPoint point) {
        return AbyssalFrequencies.getAbyssalRogueStellarObjectDireHintsFrequency(manager, point);
    }

    @Override
    protected void addSpecials(StarSystemAPI system, EncounterManager manager, EncounterPoint point, HyperspaceAbyssPluginImpl.AbyssalEPData data) {
        WeightedRandomPicker<AbyssalDireHintType> picker = new WeightedRandomPicker<AbyssalDireHintType>(data.random);
        picker.addAll(DIRE_HINT_TYPES);
        SharedData.UniqueEncounterData ueData = SharedData.getData().getUniqueEncounterData();
        WeightedRandomPicker<GhostShipType> ghostShipPicker = new WeightedRandomPicker<GhostShipType>(data.random);
        for (GhostShipType type : EnumSet.allOf(GhostShipType.class)) {
            if (ueData.wasInteractedWith(type.name()) || Global.getSector().getMemoryWithoutUpdate().contains(type.getTimeoutKey())) continue;
            ghostShipPicker.add(type);
        }
        if (ghostShipPicker.isEmpty()) {
            picker.remove(AbyssalDireHintType.GHOST_SHIP);
        }
        if (DebugFlags.ABYSSAL_GHOST_SHIPS_DEBUG) {
            picker.add(AbyssalDireHintType.GHOST_SHIP, 1.0E9f);
        }
        boolean done = false;
        do {
            GhostShipType ghostType;
            AbyssalDireHintType type;
            if ((type = (AbyssalDireHintType)((Object)picker.pickAndRemove())) == AbyssalDireHintType.BLACK_HOLE_READINGS) {
                done = this.addBlackHoleReadings(system, point, data);
                continue;
            }
            if (type == AbyssalDireHintType.GAS_GIANT_TURBULENCE) {
                done = this.addGasGiantTurbulence(system, point, data);
                continue;
            }
            if (type == AbyssalDireHintType.MINING_OP) {
                done = this.addMiningOp(system, point, data);
                continue;
            }
            if (type != AbyssalDireHintType.GHOST_SHIP || (ghostType = (GhostShipType)((Object)ghostShipPicker.pickAndRemove())) == null) continue;
            done = this.addGhostShip(system, ghostType, point, data);
        } while (!picker.isEmpty() && !done);
    }

    protected boolean addBlackHoleReadings(StarSystemAPI system, EncounterPoint point, HyperspaceAbyssPluginImpl.AbyssalEPData data) {
        SectorEntityToken blackHole = null;
        for (PlanetAPI planet : system.getPlanets()) {
            if (!planet.isBlackHole()) continue;
            blackHole = planet;
            break;
        }
        if (blackHole == null) {
            return false;
        }
        blackHole.getMemoryWithoutUpdate().set("$abyssalBlackHoleReadings", true);
        return true;
    }

    protected boolean addGasGiantTurbulence(StarSystemAPI system, EncounterPoint point, HyperspaceAbyssPluginImpl.AbyssalEPData data) {
        WeightedRandomPicker<PlanetAPI> picker = new WeightedRandomPicker<PlanetAPI>(data.random);
        for (PlanetAPI planet : system.getPlanets()) {
            if (!planet.isGasGiant()) continue;
            picker.add(planet);
        }
        PlanetAPI giant = (PlanetAPI)picker.pick();
        if (giant == null) {
            return false;
        }
        giant.getMemoryWithoutUpdate().set("$abyssalGasGiantTurbulence", true);
        return true;
    }

    protected boolean addMiningOp(StarSystemAPI system, EncounterPoint point, HyperspaceAbyssPluginImpl.AbyssalEPData data) {
        WeightedRandomPicker<PlanetAPI> picker = new WeightedRandomPicker<PlanetAPI>(data.random);
        for (PlanetAPI planet : system.getPlanets()) {
            if (planet.isGasGiant() || planet.isStar()) continue;
            picker.add(planet);
        }
        PlanetAPI giant = (PlanetAPI)picker.pick();
        if (giant == null) {
            return false;
        }
        giant.getMemoryWithoutUpdate().set("$abyssalPlanetoidMiningOp", true);
        return true;
    }

    protected boolean addGhostShip(StarSystemAPI system, GhostShipType type, EncounterPoint point, HyperspaceAbyssPluginImpl.AbyssalEPData data) {
        PlanetAPI planet2;
        WeightedRandomPicker<PlanetAPI> picker = new WeightedRandomPicker<PlanetAPI>(data.random);
        for (PlanetAPI planet2 : system.getPlanets()) {
            picker.add(planet2);
        }
        planet2 = (PlanetAPI)picker.pick();
        if (planet2 == null) {
            return false;
        }
        if (DebugFlags.ABYSSAL_GHOST_SHIPS_DEBUG) {
            type = GhostShipType.GS_AI_CORES;
            type = GhostShipType.GS_TRI_TACHYON;
            type = GhostShipType.GS_ADVENTURERS;
            type = GhostShipType.GS_OPIS;
            type = GhostShipType.GS_PIRATES;
            type = GhostShipType.GS_ZGR_MERC;
            type = GhostShipType.GS_ACADEMY;
            type = GhostShipType.GS_VAMBRACE;
        }
        if (type == GhostShipType.GS_AI_CORES) {
            variantId = this.pickVariant("independent", "combatLarge", data.random);
            if (variantId == null) {
                return false;
            }
            this.addShipAroundPlanet(planet2, variantId, ShipRecoverySpecial.ShipCondition.GOOD, type.name(), data.random);
        } else if (type == GhostShipType.GS_TRI_TACHYON) {
            this.addShipAroundPlanet(planet2, "apogee_Balanced", ShipRecoverySpecial.ShipCondition.GOOD, type.name(), data.random);
        } else if (type == GhostShipType.GS_ADVENTURERS) {
            variantId = this.pickVariant("mercenary", "combatMedium", data.random);
            if (variantId == null) {
                return false;
            }
            this.addShipAroundPlanet(planet2, variantId, ShipRecoverySpecial.ShipCondition.GOOD, type.name(), data.random);
        } else if (type == GhostShipType.GS_OPIS) {
            this.addShipAroundPlanet(planet2, "starliner_Standard", ShipRecoverySpecial.ShipCondition.GOOD, type.name(), data.random);
        } else if (type == GhostShipType.GS_PIRATES) {
            variantId = this.pickVariant("pirates", "combatLarge", data.random);
            if (variantId == null) {
                return false;
            }
            this.addShipAroundPlanet(planet2, variantId, ShipRecoverySpecial.ShipCondition.BATTERED, type.name(), data.random);
        } else if (type == GhostShipType.GS_ACADEMY) {
            this.addShipAroundPlanet(planet2, "apogee_Balanced", ShipRecoverySpecial.ShipCondition.BATTERED, type.name(), "GAS Itzamna", data.random);
        } else if (type == GhostShipType.GS_ZGR_MERC) {
            variantId = this.pickVariant("mercenary", "combatMedium", data.random);
            if (variantId == null) {
                return false;
            }
            this.addShipAroundPlanet(planet2, variantId, ShipRecoverySpecial.ShipCondition.WRECKED, type.name(), data.random);
        } else if (type == GhostShipType.GS_VAMBRACE) {
            CustomCampaignEntityAPI vambrace = system.addCustomEntity("derelict_vambrace", "Derelict Structure", "derelict_vambrace", "neutral");
            float orbitRadius = planet2.getRadius() + data.random.nextFloat() * 100.0f;
            float orbitDays = orbitRadius / (10.0f + data.random.nextFloat() * 5.0f);
            vambrace.setCircularOrbit(planet2, data.random.nextFloat() * 360.0f, orbitRadius, orbitDays);
        }
        Global.getSector().getMemoryWithoutUpdate().set(type.getTimeoutKey(), true, 90.0f);
        return true;
    }

    public void addShipAroundPlanet(SectorEntityToken planet, String variantId, ShipRecoverySpecial.ShipCondition condition, String gsType, Random random) {
        this.addShipAroundPlanet(planet, variantId, condition, gsType, null, random);
    }

    public void addShipAroundPlanet(SectorEntityToken planet, String variantId, ShipRecoverySpecial.ShipCondition condition, String gsType, String shipName, Random random) {
        ShipRecoverySpecial.PerShipData psd = new ShipRecoverySpecial.PerShipData(variantId, condition, 0.0f);
        if (shipName != null) {
            psd.shipName = shipName;
            psd.nameAlwaysKnown = true;
        }
        DerelictShipEntityPlugin.DerelictShipData params = new DerelictShipEntityPlugin.DerelictShipData(psd, true);
        CustomCampaignEntityAPI ship = (CustomCampaignEntityAPI)BaseThemeGenerator.addSalvageEntity(random, planet.getContainingLocation(), "wreck", "neutral", params);
        ship.setDiscoverable(true);
        float orbitRadius = planet.getRadius() + 200.0f + random.nextFloat() * 100.0f;
        float orbitDays = orbitRadius / (10.0f + random.nextFloat() * 5.0f);
        ship.setCircularOrbit(planet, random.nextFloat() * 360.0f, orbitRadius, orbitDays);
        ship.setLocation(planet.getLocation().x, planet.getLocation().y);
        ship.getVelocity().set((ReadableVector2f)planet.getVelocity());
        ship.getMemoryWithoutUpdate().set("$gsType", gsType);
    }

    public String pickVariant(String factionId, String shipRole, Random random) {
        FactionAPI.ShipPickParams params = new FactionAPI.ShipPickParams(FactionAPI.ShipPickMode.ALL);
        List<ShipRolePick> picks = Global.getSector().getFaction(factionId).pickShip(shipRole, params, null, random);
        if (picks == null || picks.isEmpty()) {
            return null;
        }
        return picks.get((int)0).variantId;
    }

    public static enum AbyssalDireHintType {
        MINING_OP,
        GAS_GIANT_TURBULENCE,
        BLACK_HOLE_READINGS,
        GHOST_SHIP;

    }

    public static enum GhostShipType {
        GS_AI_CORES,
        GS_TRI_TACHYON,
        GS_ZGR_MERC,
        GS_ACADEMY,
        GS_ADVENTURERS,
        GS_OPIS,
        GS_PIRATES,
        GS_VAMBRACE;


        public String getTimeoutKey() {
            return "$" + this.name() + "_timeout";
        }
    }
}

