/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.entities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.impl.campaign.BaseCustomEntityPlugin;
import com.fs.starfarer.api.util.CampaignEngineGlowIndividualEngine;
import com.fs.starfarer.api.util.CampaignEngineGlowUtil;
import com.fs.starfarer.api.util.CampaignEntityMovementUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class GateHaulerEntityPlugin
extends BaseCustomEntityPlugin {
    public static float MAX_SPEED = 1000.0f;
    public static float ACCELERATION = 5.0f;
    protected CampaignEntityMovementUtil movement;
    protected CampaignEngineGlowUtil engineGlow;
    protected boolean longBurn = false;

    @Override
    public void init(SectorEntityToken entity, Object pluginParams) {
        super.init(entity, pluginParams);
        this.readResolve();
    }

    Object readResolve() {
        if (this.engineGlow == null) {
            Color fringe = new Color(255, 0, 0, 255);
            Color flame = new Color(255, 100, 100, 255);
            Color core = new Color(255, 255, 255, 255);
            this.engineGlow = new CampaignEngineGlowUtil(this.entity, fringe, core, flame, 0.25f);
            CampaignEngineGlowIndividualEngine engine = new CampaignEngineGlowIndividualEngine(90.0f, 300.0f, 50.0f, 400.0f, new Vector2f(-115.0f, 0.0f), this.engineGlow);
            engine.setFlameTexSpanMult(0.5f);
            this.engineGlow.addEngine(engine);
        }
        if (this.movement == null) {
            this.movement = new CampaignEntityMovementUtil(this.entity, 0.5f, 3.0f, ACCELERATION, MAX_SPEED);
            this.movement.setEngineGlow(this.engineGlow);
        }
        return this;
    }

    public CampaignEntityMovementUtil getMovement() {
        return this.movement;
    }

    public CampaignEngineGlowUtil getEngineGlow() {
        return this.engineGlow;
    }

    public boolean isActivated() {
        return this.entity.getMemoryWithoutUpdate().getBoolean("$activated");
    }

    public boolean isActivating() {
        return this.entity.getMemoryWithoutUpdate().getBoolean("$activating");
    }

    public boolean isInTransit() {
        return this.entity.getMemoryWithoutUpdate().getBoolean("$inTransit");
    }

    public float getRemainingActivationDays() {
        return this.entity.getMemoryWithoutUpdate().getExpire("$activating");
    }

    @Override
    public void advance(float amount) {
        if (this.entity.isInCurrentLocation() || this.isInTransit()) {
            float angleDiff;
            this.engineGlow.advance(amount);
            float soundVolume = this.engineGlow.getLengthMult().getCurr() * 0.5f;
            if (soundVolume > 0.5f) {
                soundVolume = 0.5f;
            }
            if (this.isActivating()) {
                float remaining = this.getRemainingActivationDays();
                float f = remaining / 1.0f;
                if (f < 0.0f) {
                    f = 0.0f;
                }
                if (f > 1.0f) {
                    f = 1.0f;
                }
                this.engineGlow.getFlickerRateMult().shift(this, 1.0f + 25.0f * f, 0.0f, 0.1f, 1.0f);
                this.engineGlow.getFlickerMult().shift(this, f, 0.0f, 0.1f, 1.0f);
            }
            if (!this.isActivated()) {
                this.engineGlow.showSuppressed();
            } else if (this.isActivated() && this.longBurn && this.movement.isDesiredFacingSet() && (angleDiff = Misc.getAngleDiff(this.movement.getDesiredFacing(), this.entity.getFacing())) < 2.0f) {
                Vector2f dir = Misc.getUnitVectorAtDegreeAngle(this.movement.getDesiredFacing());
                float speedInDesiredDir = Vector2f.dot((Vector2f)dir, (Vector2f)this.entity.getVelocity());
                if (this.movement.isFaceInOppositeDirection()) {
                    speedInDesiredDir *= -1.0f;
                }
                float speed = this.entity.getVelocity().length();
                if (speedInDesiredDir > 10.0f && speedInDesiredDir > speed * 0.7f) {
                    float speedForMaxEngineLength = 100.0f;
                    float f = speedInDesiredDir / speedForMaxEngineLength;
                    if (f < 0.0f) {
                        f = 0.0f;
                    }
                    if (f > 1.0f) {
                        f = 1.0f;
                    }
                    soundVolume = Math.min(soundVolume + f * 0.5f, 1.0f);
                    float flickerZone = 0.5f;
                    if (f < flickerZone) {
                        this.engineGlow.getFlickerRateMult().shift(this, 5.0f, 0.0f, 0.1f, 1.0f);
                        this.engineGlow.getFlickerMult().shift(this, 0.33f - 0.33f * f / flickerZone, 0.0f, 0.1f, 1.0f);
                    }
                    this.engineGlow.getGlowMult().shift(this, 2.0f, 1.0f, 1.0f, f);
                    this.engineGlow.getLengthMult().shift(this, 5.0f, 1.0f, 1.0f, f);
                    this.engineGlow.getWidthMult().shift(this, 3.0f, 1.0f, 1.0f, f);
                }
            }
            if (soundVolume > 0.0f && this.entity.isInCurrentLocation() && this.entity.isVisibleToPlayerFleet()) {
                Global.getSoundPlayer().playLoop("gate_hauler_engine_loop", this.entity, 1.0f, soundVolume, this.entity.getLocation(), this.entity.getVelocity());
            }
        }
        if (this.isActivated()) {
            this.movement.advance(amount);
        }
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        float alphaMult = viewport.getAlphaMult();
        alphaMult *= this.entity.getSensorFaderBrightness();
        if ((alphaMult *= this.entity.getSensorContactFaderBrightness()) <= 0.0f) {
            return;
        }
        this.engineGlow.render(alphaMult);
    }

    @Override
    public float getRenderRange() {
        return this.entity.getRadius() + 3000.0f;
    }

    public boolean isLongBurn() {
        return this.longBurn;
    }

    public void setLongBurn(boolean longBurn) {
        this.longBurn = longBurn;
    }
}

