/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.entities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.impl.campaign.BaseCustomEntityPlugin;
import com.fs.starfarer.api.util.CampaignEngineGlowIndividualEngine;
import com.fs.starfarer.api.util.CampaignEngineGlowUtil;
import com.fs.starfarer.api.util.CampaignEntityMovementUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class GenericProbeEntityPlugin
extends BaseCustomEntityPlugin {
    protected GenericProbeParams params;
    protected CampaignEntityMovementUtil movement;
    protected CampaignEngineGlowUtil engineGlow;

    @Override
    public void init(SectorEntityToken entity, Object pluginParams) {
        super.init(entity, pluginParams);
        this.params = (GenericProbeParams)pluginParams;
        this.readResolve();
    }

    Object readResolve() {
        if (this.engineGlow == null) {
            this.engineGlow = new CampaignEngineGlowUtil(this.entity, this.params.fringe, this.params.core, this.params.flame, this.params.engineGlowShiftRate);
            CampaignEngineGlowIndividualEngine engine = new CampaignEngineGlowIndividualEngine(90.0f, this.params.engineGlowLength, this.params.engineGlowWidth, this.params.engineGlowGlowSize, new Vector2f(-10.0f, 0.0f), this.engineGlow);
            engine.setFlameTexSpanMult(this.params.engineGlowTexSpanMult);
            this.engineGlow.addEngine(engine);
        }
        if (this.movement == null) {
            float maxSpeed = Misc.getSpeedForBurnLevel(this.params.maxBurn);
            float accel = Misc.getSpeedForBurnLevel(this.params.burnAccel);
            this.movement = new CampaignEntityMovementUtil(this.entity, this.params.turnAccel, this.params.maxBurn, accel, maxSpeed);
            this.movement.setEngineGlow(this.engineGlow);
        }
        return this;
    }

    public CampaignEntityMovementUtil getMovement() {
        return this.movement;
    }

    public CampaignEngineGlowUtil getEngineGlow() {
        return this.engineGlow;
    }

    @Override
    public void advance(float amount) {
        if (this.entity.isInCurrentLocation()) {
            this.engineGlow.advance(amount);
        }
        if (this.entity.hasTag("fading_out_and_expiring") || this.params.actions.isEmpty()) {
            Misc.fadeAndExpire(this.entity);
            this.engineGlow.showSuppressed();
            return;
        }
        ProbeAction curr = this.params.actions.get(0);
        ProbeAction next = null;
        if (this.params.actions.size() > 1) {
            next = this.params.actions.get(1);
        }
        if (curr.type == ProbeActionType.TRAVEL) {
            if (curr.location == null && curr.target == null) {
                this.movement.moveInDirection(curr.dir);
                curr.duration -= amount;
                if (curr.duration <= 0.0f) {
                    this.params.actions.remove(0);
                }
            } else {
                Vector2f loc = curr.location;
                if (loc == null) {
                    loc = curr.target.getLocation();
                }
                float dist = Misc.getDistance(this.entity.getLocation(), loc);
                if (next != null && next.type == ProbeActionType.ASSUME_ORBIT) {
                    float orbitAngle = Misc.getAngleInDegrees(next.target.getLocation(), this.entity.getLocation());
                    Vector2f away = Misc.getUnitVectorAtDegreeAngle(orbitAngle);
                    away.scale(next.target.getRadius() + next.radius * 0.8f);
                    loc = Vector2f.add((Vector2f)loc, (Vector2f)away, (Vector2f)new Vector2f());
                }
                this.movement.moveToLocation(loc);
                float checkDist = 100.0f + this.entity.getRadius();
                if (curr.target != null) {
                    checkDist += curr.target.getRadius();
                }
                if (next != null && next.type == ProbeActionType.ASSUME_ORBIT) {
                    checkDist -= 100.0f;
                    checkDist += next.radius;
                }
                if (dist < checkDist) {
                    this.params.actions.remove(0);
                }
            }
        } else if (curr.type == ProbeActionType.ASSUME_ORBIT) {
            if (this.entity.getOrbit() == null || this.entity.getOrbitFocus() != curr.target) {
                this.movement.leaveOrbit();
                float orbitAngle = Misc.getAngleInDegrees(curr.target.getLocation(), this.entity.getLocation());
                float orbitRadius = Misc.getDistance(this.entity.getLocation(), curr.target.getLocation());
                float orbitDays = orbitRadius / (10.0f + (float)Math.random() * 5.0f);
                this.entity.setCircularOrbit(curr.target, orbitAngle, orbitRadius, orbitDays *= 0.2f);
            }
            curr.duration -= amount;
            if (curr.duration <= 0.0f) {
                this.params.actions.remove(0);
            }
        } else if (curr.type == ProbeActionType.EMIT_PING) {
            SectorEntityToken.VisibilityLevel level = this.entity.getVisibilityLevelToPlayerFleet();
            if (level != SectorEntityToken.VisibilityLevel.NONE) {
                Global.getSector().addPing(this.entity, "remote_survey");
            }
            this.params.actions.remove(0);
        } else if (curr.type == ProbeActionType.STOP || curr.type == ProbeActionType.WAIT) {
            if (curr.type == ProbeActionType.STOP) {
                this.movement.stop();
            }
            curr.duration -= amount;
            if (curr.duration <= 0.0f) {
                this.params.actions.remove(0);
            }
        } else if (curr.type == ProbeActionType.PERFORM_ACTION) {
            curr.action.run();
            this.params.actions.remove(0);
        }
        this.movement.advance(amount);
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        float alphaMult = viewport.getAlphaMult();
        alphaMult *= this.entity.getSensorFaderBrightness();
        if ((alphaMult *= this.entity.getSensorContactFaderBrightness()) <= 0.0f) {
            return;
        }
        this.engineGlow.render(alphaMult);
    }

    @Override
    public float getRenderRange() {
        return this.entity.getRadius() + 1000.0f;
    }

    public static class GenericProbeParams {
        public float maxBurn = 20.0f;
        public float burnAccel = 5.0f;
        public float maxTurnRate = 120.0f;
        public float turnAccel = 120.0f;
        public Color fringe = new Color(255, 100, 0, 255);
        public Color flame = new Color(255, 165, 100, 255);
        public Color core = new Color(255, 255, 255, 255);
        public float engineGlowShiftRate = 2.0f;
        public float engineGlowLength = 100.0f;
        public float engineGlowWidth = 15.0f;
        public float engineGlowGlowSize = 100.0f;
        public float engineGlowTexSpanMult = 0.1f;
        protected List<ProbeAction> actions = new ArrayList<ProbeAction>();

        public void travelTo(Vector2f location) {
            ProbeAction a = new ProbeAction(ProbeActionType.TRAVEL);
            a.location = location;
            this.actions.add(a);
        }

        public void travelTo(SectorEntityToken target) {
            ProbeAction a = new ProbeAction(ProbeActionType.TRAVEL);
            a.target = target;
            this.actions.add(a);
        }

        public void travelInDir(float dir, float duration) {
            ProbeAction a = new ProbeAction(ProbeActionType.TRAVEL);
            a.dir = dir;
            a.duration = duration;
            this.actions.add(a);
        }

        public void assumeOrbit(SectorEntityToken target, float radius, float duration) {
            ProbeAction a = new ProbeAction(ProbeActionType.ASSUME_ORBIT);
            a.target = target;
            a.radius = radius;
            a.duration = duration;
            this.actions.add(a);
        }

        public void emitPing(String pingId) {
            ProbeAction a = new ProbeAction(ProbeActionType.EMIT_PING);
            a.pingId = pingId;
            this.actions.add(a);
        }

        public void performAction(Script action) {
            ProbeAction a = new ProbeAction(ProbeActionType.PERFORM_ACTION);
            a.action = action;
            this.actions.add(a);
        }

        public void wait(float duration) {
            ProbeAction a = new ProbeAction(ProbeActionType.WAIT);
            a.duration = duration;
            this.actions.add(a);
        }

        public void stop(float duration) {
            ProbeAction a = new ProbeAction(ProbeActionType.STOP);
            a.duration = duration;
            this.actions.add(a);
        }
    }

    public static class ProbeAction {
        public ProbeActionType type;
        public SectorEntityToken target;
        public Vector2f location;
        public float dir;
        public float radius;
        public float duration;
        public String pingId;
        public Script action;

        public ProbeAction(ProbeActionType type) {
            this.type = type;
        }
    }

    public static enum ProbeActionType {
        TRAVEL,
        ASSUME_ORBIT,
        EMIT_PING,
        PERFORM_ACTION,
        STOP,
        WAIT;

    }
}

