/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.eventide;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.eventide.Actions;
import com.fs.starfarer.api.impl.campaign.eventide.Actor;
import com.fs.starfarer.api.impl.campaign.eventide.CharAnim;
import com.fs.starfarer.api.impl.campaign.eventide.CharAnimFrame;
import com.fs.starfarer.api.impl.campaign.eventide.DuelPanel;
import com.fs.starfarer.api.impl.campaign.eventide.HitArea;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.LinkedHashSet;
import java.util.Set;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class AnimAction {
    public CharAnim anim;
    public CharAnimFrame curr;
    public float progress;
    public Actor actor;
    public boolean done = false;
    public boolean performedBlock = false;
    public boolean wasBlocked = false;
    public boolean scoredHit = false;
    public boolean makeCurrentFrameLast = false;
    public SpriteAPI sprite;
    public CharAnimFrame preFrame;
    public float returnToIdleXCorrection = 0.0f;
    public Set<CharAnimFrame> playedSoundsFor = new LinkedHashSet<CharAnimFrame>();

    public AnimAction(Actor actor, Object animKey, CharAnimFrame preFrame) {
        this.actor = actor;
        this.preFrame = preFrame;
        this.anim = Actions.ANIMATIONS.get(animKey);
        this.sprite = Global.getSettings().getSprite(this.anim.textureId);
        if (actor.texId != null) {
            this.sprite = Global.getSettings().getSprite(actor.texId);
        }
    }

    public int framesUntilAttackFrame() {
        int index = 0;
        for (CharAnimFrame frame : this.anim.frames) {
            if (frame.attackArea.isEmpty()) continue;
            index = this.anim.frames.indexOf(frame);
        }
        int currIndex = this.anim.frames.indexOf(this.curr);
        return index - currIndex;
    }

    public void undoLastMove() {
        if (this.curr != null) {
            this.actor.loc.x -= this.curr.move.x * this.anim.scale * this.actor.facing;
            this.actor.loc.y -= this.curr.move.y * this.anim.scale * this.actor.facing;
        }
    }

    public void advance(float amount) {
        this.progress += amount;
        float total = 0.0f;
        for (CharAnimFrame f : this.anim.frames) {
            if (!((total += f.dur) > this.progress)) continue;
            if (this.curr == f) break;
            if (this.makeCurrentFrameLast) {
                this.progress = this.anim.getTotalTime();
                break;
            }
            this.curr = f;
            this.actor.loc.x += this.curr.move.x * this.anim.scale * this.actor.facing;
            this.actor.loc.y += this.curr.move.y * this.anim.scale * this.actor.facing;
            if (!this.playedSoundsFor.contains(this.curr)) {
                this.playedSoundsFor.add(this.curr);
                for (String soundId : this.curr.soundIds) {
                    if (soundId == null || soundId.isEmpty()) continue;
                    Vector2f soundLoc = new Vector2f((ReadableVector2f)this.actor.loc);
                    soundLoc.x *= DuelPanel.SOUND_LOC_MULT;
                    Global.getSoundPlayer().playSound(soundId, 1.0f, 1.0f, soundLoc, new Vector2f());
                }
            }
            if (this.curr != this.anim.frames.get(0) || this.preFrame == null || this.anim.initialRelativeOffset == null) break;
            float preW = this.preFrame.width * this.anim.scale;
            float w = this.curr.width * this.anim.scale;
            this.returnToIdleXCorrection = (preW - w) / 2.0f * this.actor.facing + this.anim.initialRelativeOffset.floatValue() * this.anim.scale;
            this.actor.loc.x -= this.returnToIdleXCorrection;
            this.returnToIdleXCorrection = 0.0f;
            break;
        }
        if (this.progress >= this.anim.getTotalTime()) {
            this.actor.loc.x += this.anim.moveToIdle.x * this.anim.scale * this.actor.facing + this.returnToIdleXCorrection;
            this.actor.loc.y += this.anim.moveToIdle.y * this.anim.scale * this.actor.facing;
            this.done = true;
        }
    }

    public void render(float alphaMult) {
        if (this.curr == null) {
            return;
        }
        float x = this.actor.loc.x;
        float y = this.actor.loc.y;
        this.sprite.setAlphaMult(alphaMult);
        this.sprite.setSize(this.curr.width * this.anim.scale, this.curr.height * this.anim.scale);
        if (this.actor.facing > 0.0f) {
            this.sprite.setTexX(this.curr.tx);
            this.sprite.setTexY(this.curr.ty);
            this.sprite.setTexWidth(this.curr.tw);
            this.sprite.setTexHeight(this.curr.th);
        } else {
            this.sprite.setTexX(this.curr.tx + this.curr.tw);
            this.sprite.setTexY(this.curr.ty);
            this.sprite.setTexWidth(-this.curr.tw);
            this.sprite.setTexHeight(this.curr.th);
        }
        this.sprite.renderAtCenter(x, y);
        if (DuelPanel.DEBUG) {
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            for (HitArea area : this.curr.hittableArea) {
                area = area.getAdjustedForAction(this);
                Misc.renderQuad(area.x, area.y, area.w, area.h, new Color(120, 120, 120, 127), alphaMult);
            }
            for (HitArea area : this.curr.attackArea) {
                area = area.getAdjustedForAction(this);
                Misc.renderQuad(area.x, area.y, area.w, area.h, new Color(200, 60, 60, 127), alphaMult);
            }
            for (HitArea area : this.curr.blockArea) {
                area = area.getAdjustedForAction(this);
                Misc.renderQuad(area.x, area.y, area.w, area.h, new Color(60, 200, 60, 127), alphaMult);
            }
        }
    }

    public boolean isDone() {
        return this.done;
    }
}

