/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.eventide;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.eventide.CharAnimFrame;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class CharAnim
implements Cloneable {
    public String textureId;
    public SpriteAPI sprite;
    public float scale = 1.0f;
    public float frameHeight;
    public float widthSoFar = 0.0f;
    public float totalTime = 0.0f;
    public List<CharAnimFrame> frames = new ArrayList<CharAnimFrame>();
    public CharAnimFrame last;
    public Float initialRelativeOffset = null;
    public Vector2f moveToIdle = new Vector2f();
    public String action;
    public Set<String> interruptableBy = new LinkedHashSet<String>();

    public CharAnim clone() {
        try {
            CharAnim copy = (CharAnim)super.clone();
            copy.frames = new ArrayList<CharAnimFrame>();
            for (CharAnimFrame frame : this.frames) {
                CharAnimFrame cf = frame.clone();
                copy.frames.add(cf);
            }
            copy.sprite = Global.getSettings().getSprite(this.textureId);
            copy.totalTime = this.totalTime;
            copy.interruptableBy = new LinkedHashSet<String>(this.interruptableBy);
            copy.moveToIdle = new Vector2f((ReadableVector2f)this.moveToIdle);
            copy.last = this.last.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeFirstFrame() {
        CharAnimFrame frame = this.frames.remove(0);
        this.totalTime -= frame.dur;
    }

    public CharAnim(String textureId, String action, float frameHeight) {
        this.textureId = textureId;
        this.action = action;
        this.sprite = Global.getSettings().getSprite(textureId);
        this.frameHeight = frameHeight;
    }

    public boolean hasBlockFrames() {
        for (CharAnimFrame frame : this.frames) {
            if (frame.blockArea.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttackFrames() {
        for (CharAnimFrame frame : this.frames) {
            if (frame.attackArea.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void interruptableBy(String ... actions) {
        String[] stringArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            String action = stringArray[n2];
            this.interruptableBy.add(action);
            ++n2;
        }
    }

    public void skip(CharAnim anim) {
        this.widthSoFar += anim.widthSoFar;
    }

    public void skip(float frameWidth) {
        this.widthSoFar += frameWidth;
    }

    public void addFrame(float y, float frameWidth, float dur) {
        float txPerPixel = this.sprite.getTextureWidth() / this.sprite.getWidth();
        float tyPerPixel = this.sprite.getTextureHeight() / this.sprite.getHeight();
        CharAnimFrame frame = new CharAnimFrame();
        frame.dur = dur;
        frame.tx = this.widthSoFar * txPerPixel;
        frame.ty = y * tyPerPixel;
        frame.tw = frameWidth * txPerPixel;
        frame.th = this.frameHeight * tyPerPixel;
        frame.width = frameWidth;
        frame.height = this.frameHeight;
        this.widthSoFar += frameWidth;
        this.totalTime += dur;
        this.frames.add(frame);
        this.last = frame;
    }

    public float getTotalTime() {
        return this.totalTime;
    }

    public void updateTextureScale(float scale) {
        for (CharAnimFrame frame : this.frames) {
            frame.tx *= scale;
            frame.ty *= scale;
            frame.tw *= scale;
            frame.th *= scale;
        }
    }
}

