/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.eventide;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCustomUIPanelPlugin;
import com.fs.starfarer.api.campaign.CustomVisualDialogDelegate;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.impl.campaign.eventide.Actions;
import com.fs.starfarer.api.impl.campaign.eventide.Actor;
import com.fs.starfarer.api.impl.campaign.eventide.AnimAction;
import com.fs.starfarer.api.impl.campaign.eventide.CharAnim;
import com.fs.starfarer.api.impl.campaign.eventide.CharAnimFrame;
import com.fs.starfarer.api.impl.campaign.eventide.DuelBackground;
import com.fs.starfarer.api.impl.campaign.eventide.DuelEnemyAI;
import com.fs.starfarer.api.impl.campaign.eventide.DuelEnemyAIImpl;
import com.fs.starfarer.api.impl.campaign.eventide.DuelTutorialPanel;
import com.fs.starfarer.api.impl.campaign.eventide.EventideDuelBackground;
import com.fs.starfarer.api.impl.campaign.eventide.HitArea;
import com.fs.starfarer.api.impl.campaign.eventide.QuadParticles;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.ui.CustomPanelAPI;
import com.fs.starfarer.api.ui.PositionAPI;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class DuelPanel
extends BaseCustomUIPanelPlugin {
    public static float SOUND_LOC_MULT = 0.25f;
    public static boolean DEBUG = true;
    protected InteractionDialogAPI dialog;
    protected CustomVisualDialogDelegate.DialogCallbacks callbacks;
    protected CustomPanelAPI panel;
    protected PositionAPI p;
    protected Actor player;
    protected Actor enemy;
    protected List<QuadParticles> particles = new ArrayList<QuadParticles>();
    protected float floorLevel;
    protected float leftBorder;
    protected float rightBorder;
    protected float viewAreaWidth = 512.0f;
    protected DuelEnemyAI ai;
    protected DuelBackground background;
    protected boolean tutorialMode = false;
    protected DuelTutorialPanel prompt;
    protected FaderUtil blinker = new FaderUtil(0.0f, 0.25f, 0.25f, true, true);
    protected String ambienceLoopId = null;
    protected float desiredViewCenterX = 0.0f;
    protected float viewCenterX = 0.0f;
    public static boolean DO_CYCLE = false;
    public static boolean DO_CYCLE_HIGH = false;
    public int cycleIndex = -1;
    public static List<String> cycle = new ArrayList<String>();
    public static List<String> cycleHigh;
    protected boolean prevWasAttack;

    static {
        cycle.add("BLOCK");
        cycle.add("ATTACK");
        cycle.add("ATTACK_RECOVERY");
        cycleHigh = new ArrayList<String>();
        cycleHigh.add("BLOCK_LOW");
        cycleHigh.add("ATTACK_HIGH");
        cycleHigh.add("ATTACK_HIGH_RECOVERY");
    }

    public static DuelPanel createDefault(boolean playerSkilled, boolean enemySkilled, String ambienceLoopId) {
        Actions.initActions();
        Actor player = DuelPanel.createActor(Actions.TEX, playerSkilled);
        Actor enemy = DuelPanel.createActor(Actions.TEX, enemySkilled);
        enemy.actionRemap1.put("IDLE", "IDLE_HIGH");
        enemy.actionRemap1.put("MOVE_FORWARD", "MOVE_FORWARD_HIGH");
        enemy.actionRemap1.put("MOVE_BACK", "MOVE_BACK_HIGH");
        enemy.actionRemap1.put("ATTACK", "ATTACK_HIGH");
        enemy.actionRemap1.put("ATTACK_RECOVERY", "ATTACK_HIGH_RECOVERY");
        enemy.actionRemap1.put("RIPOSTE", "RIPOSTE_HIGH");
        enemy.actionRemap1.put("BLOCK", "BLOCK_LOW");
        EventideDuelBackground bg = new EventideDuelBackground();
        DuelPanel panel = new DuelPanel(player, enemy, new DuelEnemyAIImpl(), bg);
        DO_CYCLE = false;
        DO_CYCLE_HIGH = false;
        panel.ambienceLoopId = ambienceLoopId;
        return panel;
    }

    public static DuelPanel createTutorial(boolean playerSkilled, String ambienceLoopId) {
        Actions.initActions();
        Actor player = DuelPanel.createActor(Actions.TEX, playerSkilled);
        Actor enemy = DuelPanel.createActor(Actions.TEX, true);
        EventideDuelBackground bg = new EventideDuelBackground();
        DuelPanel panel = new DuelPanel(player, enemy, null, bg);
        panel.tutorialMode = true;
        panel.ambienceLoopId = ambienceLoopId;
        return panel;
    }

    public static Actor createActor(String tex, boolean skilled) {
        Actor actor = new Actor(tex);
        int health = 5;
        if (!skilled) {
            health = 3;
            actor.actionRemap2.put("RIPOSTE", "ATTACK");
            actor.actionRemap2.put("RIPOSTE_HIGH", "ATTACK_HIGH");
        }
        actor.maxHealth = health;
        actor.health = health;
        return actor;
    }

    public DuelPanel(Actor player, Actor enemy, DuelEnemyAI ai, DuelBackground background) {
        this.player = player;
        this.enemy = enemy;
        this.ai = ai;
        this.background = background;
    }

    public void init(CustomPanelAPI panel, CustomVisualDialogDelegate.DialogCallbacks callbacks, InteractionDialogAPI dialog) {
        this.panel = panel;
        this.callbacks = callbacks;
        this.dialog = dialog;
        this.blinker.fadeIn();
        if (this.tutorialMode) {
            this.prompt = new DuelTutorialPanel();
            CustomPanelAPI p = panel.createCustomPanel(450.0f, 120.0f, this.prompt);
            panel.addComponent(p).inTL(10.0f, 30.0f);
            this.prompt.init(p, callbacks, dialog);
        }
    }

    public CustomPanelAPI getPanel() {
        return this.panel;
    }

    public PositionAPI getPosition() {
        return this.p;
    }

    public float getFloorLevel() {
        return this.floorLevel;
    }

    @Override
    public void positionChanged(PositionAPI position) {
        this.p = position;
        if (this.player != null) {
            float cx = this.p.getCenterX();
            float cy = this.p.getCenterY();
            float charHeight = this.getCharacterHeight();
            this.floorLevel = (int)(cy - charHeight / 2.0f);
            this.leftBorder = (int)(cx - this.p.getWidth() / 2.0f + 50.0f);
            this.rightBorder = (int)(cx + this.p.getWidth() / 2.0f - 50.0f);
            float width = this.background.getStageWidth();
            float extra = width - this.p.getWidth();
            this.leftBorder -= (float)((int)(extra / 2.0f));
            this.rightBorder += (float)((int)(extra / 2.0f));
            float down = 5.0f;
            this.player.loc.set(cx - 200.0f, this.floorLevel + charHeight / 2.0f - down);
            this.player.facing = 1.0f;
            this.enemy.loc.set(cx + 200.0f, this.floorLevel + charHeight / 2.0f - down);
            this.enemy.facing = -1.0f;
            this.viewAreaWidth = 200.0f;
            this.viewCenterX = this.desiredViewCenterX = this.player.loc.x + this.viewAreaWidth / 2.0f - 50.0f;
        }
    }

    @Override
    public void render(float alphaMult) {
    }

    @Override
    public void renderBelow(float alphaMult) {
        if (this.p == null) {
            return;
        }
        float x = this.p.getX();
        float y = this.p.getY();
        float cx = this.p.getCenterX();
        float cy = this.p.getCenterY();
        float w = this.p.getWidth();
        float h = this.p.getHeight();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3089);
        float s = Global.getSettings().getScreenScaleMult();
        GL11.glScissor((int)((int)(x * s)), (int)((int)(y * s)), (int)((int)(w * s)), (int)((int)(h * s)));
        DEBUG = true;
        DEBUG = false;
        float centerX = this.player.loc.x - (this.desiredViewCenterX - cx);
        if (this.player.currAction != null && this.player.currAction.anim != null && this.player.currAction.anim.hasAttackFrames()) {
            centerX = cx;
        } else if (this.player.currAction != null && this.player.currAction.anim != null && this.player.currAction.curr != null && !this.player.currAction.curr.hittableArea.isEmpty()) {
            HitArea area = this.player.currAction.curr.hittableArea.get(0);
            centerX = this.player.loc.x + (area.x + area.w / 2.0f) - (this.desiredViewCenterX - cx);
        }
        float leftX = cx - this.viewAreaWidth / 2.0f;
        float rightX = cx + this.viewAreaWidth / 2.0f;
        if (centerX < leftX) {
            this.desiredViewCenterX -= leftX - centerX + 100.0f;
        } else if (centerX > rightX) {
            this.desiredViewCenterX += centerX - rightX + 100.0f;
        }
        float minVX = this.leftBorder + w / 2.0f - 50.0f;
        float maxVX = this.rightBorder - w / 2.0f + 50.0f;
        if (this.desiredViewCenterX < minVX) {
            this.desiredViewCenterX = minVX;
        }
        if (this.desiredViewCenterX > maxVX) {
            this.desiredViewCenterX = maxVX;
        }
        float offsetX = -(this.viewCenterX - cx);
        if (this.background == null) {
            GL11.glDisable((int)3553);
            Misc.renderQuad(x, y, w, h, Color.black, alphaMult);
            Misc.renderQuad(x, y, w, h, new Color(50, 50, 50, 255), alphaMult);
        } else {
            this.background.render(this, offsetX, 0.0f, alphaMult);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)offsetX, (float)0.0f, (float)0.0f);
        for (QuadParticles p : this.particles) {
            p.render(alphaMult, true);
        }
        if (this.enemy.health > 0 && this.player.health > 0) {
            boolean playerAttack;
            boolean bl = playerAttack = this.player.currAction != null && this.player.currAction.anim != null && this.player.currAction.anim.hasAttackFrames();
            if (playerAttack) {
                if (!this.tutorialMode) {
                    this.enemy.render(alphaMult);
                }
                this.player.render(alphaMult);
            } else {
                this.player.render(alphaMult);
                if (!this.tutorialMode) {
                    this.enemy.render(alphaMult);
                }
            }
        } else if (this.enemy.health > 0) {
            this.player.render(alphaMult);
            if (!this.tutorialMode) {
                this.enemy.render(alphaMult);
            }
        } else {
            if (!this.tutorialMode) {
                this.enemy.render(alphaMult);
            }
            this.player.render(alphaMult);
        }
        for (QuadParticles p : this.particles) {
            p.render(alphaMult, false);
        }
        GL11.glPopMatrix();
        if (this.background != null) {
            this.background.renderForeground(this, offsetX, 0.0f, alphaMult);
        }
        this.renderHealth(alphaMult);
        if (this.ai != null) {
            this.ai.render(alphaMult);
        }
        GL11.glDisable((int)3089);
    }

    public void renderHealth(float alphaMult) {
        float x = this.p.getX();
        float y = this.p.getY();
        float w = this.p.getWidth();
        float h = this.p.getHeight();
        float pipW = 20.0f;
        float pipH = 12.5f;
        float pad = 3.0f;
        float opad = 10.0f;
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        int i = 0;
        while (i < this.player.maxHealth) {
            boolean filled;
            boolean bl = filled = i < this.player.health;
            if (this.player.health == 1 && i == 0 && this.blinker.isFadingIn()) {
                filled = false;
            }
            this.renderPip(x + opad + (pipW + pad) * (float)i, y + h - opad - pipH, pipW, pipH, Misc.getPositiveHighlightColor(), alphaMult, filled);
            ++i;
        }
        if (!this.tutorialMode) {
            i = this.enemy.maxHealth - 1;
            while (i >= 0) {
                this.renderPip(x + w - opad - (pipW + pad) * (float)(i + 1), y + h - opad - pipH, pipW, pipH, Misc.getNegativeHighlightColor(), alphaMult, i < this.enemy.health);
                --i;
            }
        }
    }

    public void renderPip(float x, float y, float w, float h, Color c, float a, boolean filled) {
        if (filled) {
            Misc.renderQuad(x, y, w, h, c, a);
        } else {
            Misc.renderQuad(x, y, w, 1.0f, c, a);
            Misc.renderQuad(x, y + h - 1.0f, w, 1.0f, c, a);
            Misc.renderQuad(x, y + 1.0f, 1.0f, h - 2.0f, c, a);
            Misc.renderQuad(x + w - 1.0f, y + 1.0f, 1.0f, h - 2.0f, c, a);
        }
        Misc.renderQuad(x + w, y - 1.0f, 1.0f, h, Color.black, a);
        Misc.renderQuad(x + 1.0f, y - 1.0f, w - 1.0f, 1.0f, Color.black, a);
    }

    @Override
    public void advance(float amount) {
        if (this.p == null) {
            return;
        }
        if (Keyboard.isKeyDown((int)42) && Global.getSettings().isDevMode()) {
            amount *= 0.25f;
        }
        if (this.tutorialMode) {
            this.panel.bringComponentToTop(this.prompt.getPanel());
        }
        this.viewCenterX = Misc.approach(this.viewCenterX, this.desiredViewCenterX, 3.0f, 1.0f, amount);
        float soundOffset = this.viewCenterX - this.player.loc.x;
        Global.getSoundPlayer().setListenerPosOverrideOneFrame(new Vector2f((soundOffset *= SOUND_LOC_MULT) + (this.player.loc.x + this.enemy.loc.x) / 2.0f * SOUND_LOC_MULT, this.player.loc.y));
        if (this.ambienceLoopId != null) {
            Global.getSoundPlayer().playUILoop(this.ambienceLoopId, 1.0f, 1.0f);
        }
        if (this.background != null) {
            this.background.advance(amount);
        }
        if (DO_CYCLE || DO_CYCLE_HIGH) {
            amount *= 1.0f;
            if (this.player.getActionId() != null && (this.player.getActionId().equals("ATTACK") || this.player.getActionId().equals("ATTACK_HIGH"))) {
                float timeUntilAttack = 0.0f;
                for (CharAnimFrame f : this.player.currAction.anim.frames) {
                    if (!f.attackArea.isEmpty()) break;
                    timeUntilAttack += f.dur;
                }
                if (timeUntilAttack <= this.player.currAction.progress + 0.05f) {
                    this.player.currAction = null;
                }
            }
            if (this.player.getActionId().isEmpty() || this.player.getActionId().equals("IDLE") || this.player.getActionId().equals("IDLE_HIGH")) {
                ++this.cycleIndex;
                if (this.cycleIndex < 0) {
                    this.cycleIndex = 0;
                }
                if (DO_CYCLE_HIGH) {
                    this.cycleIndex %= cycleHigh.size();
                    this.player.doAction(cycleHigh.get(this.cycleIndex), true);
                } else {
                    this.cycleIndex %= cycle.size();
                    this.player.doAction(cycle.get(this.cycleIndex), true);
                }
            }
        }
        this.blinker.advance(amount * 1.5f);
        Iterator<QuadParticles> iter = this.particles.iterator();
        while (iter.hasNext()) {
            QuadParticles curr = iter.next();
            curr.advance(amount);
            if (!curr.isDone()) continue;
            iter.remove();
        }
        this.player.advance(amount);
        this.enemy.advance(amount);
        if (!this.tutorialMode) {
            if (this.player.loc.x - 100.0f > this.enemy.loc.x) {
                this.player.facing = -1.0f;
                this.enemy.facing = 1.0f;
            } else if (this.player.loc.x + 100.0f < this.enemy.loc.x) {
                this.player.facing = 1.0f;
                this.enemy.facing = -1.0f;
            }
        }
        float minDist = 40.0f;
        if (this.getDistance() < minDist && this.player.health > 0 && this.enemy.health > 0 && !this.tutorialMode) {
            this.player.doAction("MOVE_BACK", false);
            this.enemy.doAction("MOVE_BACK", false);
        } else {
            if (this.player.loc.x < this.leftBorder) {
                this.player.loc.x = this.leftBorder;
            }
            if (this.player.loc.x > this.rightBorder) {
                this.player.loc.x = this.rightBorder;
            }
            if (this.enemy.loc.x < this.leftBorder) {
                this.enemy.loc.x = this.leftBorder;
            }
            if (this.enemy.loc.x > this.rightBorder) {
                this.enemy.loc.x = this.rightBorder;
            }
        }
        this.checkBlocksAndHits();
        this.doAI(amount);
    }

    public float getDistance() {
        return Math.abs(this.player.loc.x - this.enemy.loc.x);
    }

    public void doAI(float amount) {
        if (this.ai != null) {
            this.ai.advance(amount, this);
        }
    }

    @Override
    public void processInput(List<InputEventAPI> events) {
        if (this.p == null) {
            return;
        }
        for (InputEventAPI event : events) {
            if (event.isConsumed()) continue;
            if ((Global.getSettings().isDevMode() || this.tutorialMode) && event.isKeyDownEvent() && event.getEventValue() == 1) {
                event.consume();
                this.callbacks.dismissDialog();
                return;
            }
            if (event.isKeyDownEvent() && (event.getEventValue() == 200 || event.getEventValue() == 72 || event.getEventValue() == 17)) {
                event.consume();
                this.player.doAction("BLOCK", false);
                if (!this.tutorialMode) continue;
                this.prompt.reportAction("BLOCK");
                continue;
            }
            if (event.isKeyDownEvent() && (event.getEventValue() == 203 || event.getEventValue() == 75 || event.getEventValue() == 30)) {
                event.consume();
                if (this.player.facing > 0.0f) {
                    this.player.doAction("MOVE_BACK", false);
                    if (!this.tutorialMode) continue;
                    this.prompt.reportAction("MOVE_BACK");
                    continue;
                }
                this.player.doAction("MOVE_FORWARD", false);
                if (!this.tutorialMode) continue;
                this.prompt.reportAction("MOVE_FORWARD");
                continue;
            }
            if (event.isKeyDownEvent() && (event.getEventValue() == 205 || event.getEventValue() == 77 || event.getEventValue() == 32)) {
                event.consume();
                if (this.player.facing > 0.0f) {
                    this.player.doAction("MOVE_FORWARD", false);
                    if (!this.tutorialMode) continue;
                    this.prompt.reportAction("MOVE_FORWARD");
                    continue;
                }
                this.player.doAction("MOVE_BACK", false);
                if (!this.tutorialMode) continue;
                this.prompt.reportAction("MOVE_BACK");
                continue;
            }
            if (event.isKeyDownEvent() && event.getEventValue() == 57) {
                event.consume();
                this.player.doAction("ATTACK", false);
                if (!this.tutorialMode) continue;
                this.prompt.reportAction("ATTACK");
                continue;
            }
            if (Global.getSettings().isDevMode() && event.isKeyDownEvent() && event.getEventValue() == 33) {
                event.consume();
                this.player.doAction("FALL", true);
                continue;
            }
            if (!event.isKeyDownEvent() || event.getEventValue() != 34) continue;
            event.consume();
            this.addSparks(this.player, this.enemy);
        }
    }

    public void checkBlocksAndHits() {
        if (this.tutorialMode) {
            return;
        }
        AttackResult playerAttackResult = this.checkAttackVsDefense(this.player, this.enemy);
        AttackResult enemyAttackResult = this.checkAttackVsDefense(this.enemy, this.player);
        if (playerAttackResult == AttackResult.HIT && enemyAttackResult == AttackResult.HIT) {
            if ((float)Math.random() < 0.5f) {
                playerAttackResult = AttackResult.NO_HIT;
            } else {
                enemyAttackResult = AttackResult.NO_HIT;
            }
        }
        if (playerAttackResult == AttackResult.BLOCK) {
            this.addSparks(this.player, this.enemy);
            this.player.currAction.wasBlocked = true;
            this.player.currAction.undoLastMove();
            this.enemy.currAction.performedBlock = true;
            this.player.doAction("ATTACK_RECOVERY", true);
        } else if (playerAttackResult == AttackResult.HIT) {
            this.wasHit(this.enemy, this.player);
            this.player.currAction.scoredHit = true;
        }
        if (enemyAttackResult == AttackResult.BLOCK) {
            this.addSparks(this.enemy, this.player);
            this.enemy.currAction.wasBlocked = true;
            this.enemy.currAction.undoLastMove();
            this.player.currAction.performedBlock = true;
            this.enemy.doAction("ATTACK_RECOVERY", true);
        } else if (enemyAttackResult == AttackResult.HIT) {
            this.wasHit(this.player, this.enemy);
            this.enemy.currAction.scoredHit = true;
        }
    }

    public AttackResult checkAttackVsDefense(Actor attacker, Actor defender) {
        AnimAction a = attacker.currAction;
        AnimAction d = defender.currAction;
        if (a.curr == null || a.curr.attackArea.isEmpty()) {
            return AttackResult.NO_HIT;
        }
        if (d.curr == null || d.curr.hittableArea.isEmpty()) {
            return AttackResult.NO_HIT;
        }
        if (a.wasBlocked) {
            return AttackResult.NO_HIT;
        }
        if (a.scoredHit) {
            return AttackResult.NO_HIT;
        }
        for (HitArea attack : a.curr.attackArea) {
            attack = attack.getAdjustedForAction(a);
            for (HitArea block : d.curr.blockArea) {
                if (!attack.intersects(block = block.getAdjustedForAction(d))) continue;
                return AttackResult.BLOCK;
            }
        }
        for (HitArea attack : a.curr.attackArea) {
            attack = attack.getAdjustedForAction(a);
            for (HitArea hit : d.curr.hittableArea) {
                if (!attack.intersects(hit = hit.getAdjustedForAction(d))) continue;
                return AttackResult.HIT;
            }
        }
        return AttackResult.NO_HIT;
    }

    public void addSparks(Actor attacker, Actor defender) {
    }

    public void wasHit(Actor actor, Actor by) {
        int damage = 1;
        if (by != null && by.currAction != null && by.currAction.curr != null) {
            damage = by.currAction.curr.hitDamage;
        }
        actor.health -= damage;
        if (actor.health > 0) {
            actor.doAction("GOT_HIT", true);
        } else {
            actor.doAction("FALL", true);
        }
        this.addBlood(actor);
    }

    public void addBlood(Actor actor) {
        Vector2f loc = new Vector2f((ReadableVector2f)actor.loc);
        loc.y += this.getCharacterHeight() * 0.07f;
        this.addBlood(loc, actor);
    }

    public void addBlood(Vector2f loc, Actor actor) {
        QuadParticles p = new QuadParticles();
        p.minDur = 5.0f;
        p.maxDur = 8.0f;
        p.minSize = 2.0f;
        p.maxSize = 3.0f;
        p.fadeTime = 3.0f;
        p.minColor = new Color(136, 8, 8, 155);
        p.maxColor = new Color(238, 75, 43, 255);
        p.maxFloorMod = 30.0f;
        int base = 100;
        if ((base -= actor.health * 15) < 20) {
            base = 20;
        }
        int num = base + Misc.random.nextInt((int)((float)base * 0.5f));
        num = (int)((float)num * 2.0f);
        int i = 0;
        while (i < num) {
            Vector2f pos = Misc.getPointWithinRadius(loc, 15.0f);
            Vector2f vel = Misc.getPointWithinRadius(new Vector2f(), 150.0f);
            p.addParticle(pos.x, pos.y, vel.x, vel.y);
            ++i;
        }
        p.gravity = this.getGravity();
        p.floor = this.floorLevel - 10.0f;
        p.floorFriction = 100.0f;
        this.particles.add(p);
    }

    public float getGravity() {
        float h = this.getCharacterHeight();
        return h / 2.0f * 9.81f;
    }

    public float getCharacterHeight() {
        CharAnim anim = Actions.ANIMATIONS.get("IDLE");
        return anim.frameHeight * anim.scale;
    }

    public Actor getPlayer() {
        return this.player;
    }

    public Actor getEnemy() {
        return this.enemy;
    }

    public static enum AttackResult {
        NO_HIT,
        BLOCK,
        HIT;

    }
}

