/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.eventide;

import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class QuadParticles {
    public List<QuadParticleData> particles = new ArrayList<QuadParticleData>();
    public float gravity = 0.0f;
    public float floor = -1.0E7f;
    public float maxFloorMod = 0.0f;
    public float floorFriction = 1.0f;
    public boolean additiveBlend = false;
    public Color minColor = null;
    public Color maxColor = null;
    public float minDur;
    public float maxDur;
    public float minSize;
    public float maxSize;
    public float fadeTime = 0.5f;

    public void addParticle(float x, float y, float dx, float dy) {
        float size = (float)Math.random() * (this.maxSize - this.minSize) + this.minSize;
        this.addParticle(x, y, dx, dy, size);
    }

    public void addParticle(float x, float y, float dx, float dy, float size) {
        float r1 = (float)Math.random();
        int r = Math.round(Misc.interpolate(this.minColor.getRed(), this.maxColor.getRed(), r1));
        if (r < 0) {
            r = 0;
        }
        if (r > 255) {
            r = 255;
        }
        r1 = (float)Math.random();
        int g = Math.round(Misc.interpolate(this.minColor.getGreen(), this.maxColor.getGreen(), r1));
        if (g < 0) {
            g = 0;
        }
        if (g > 255) {
            g = 255;
        }
        r1 = (float)Math.random();
        int b = Math.round(Misc.interpolate(this.minColor.getBlue(), this.maxColor.getBlue(), r1));
        if (b < 0) {
            b = 0;
        }
        if (b > 255) {
            b = 255;
        }
        r1 = (float)Math.random();
        int a = Math.round(Misc.interpolate(this.minColor.getAlpha(), this.maxColor.getAlpha(), r1));
        if (a < 0) {
            a = 0;
        }
        if (a > 255) {
            a = 255;
        }
        this.addParticle(x, y, dx, dy, size, new Color(r, g, b, a));
    }

    public void addParticle(float x, float y, float dx, float dy, float size, Color color) {
        float dur = (float)Math.random() * (this.maxDur - this.minDur) + this.minDur;
        this.addParticle(x, y, dx, dy, size, color, dur, this.fadeTime);
    }

    public void addParticle(float x, float y, float dx, float dy, float size, Color color, float maxDur) {
        this.addParticle(x, y, dx, dy, size, color, maxDur, this.fadeTime);
    }

    public void addParticle(float x, float y, float dx, float dy, float size, Color color, float maxDur, float fadeTime) {
        QuadParticleData p = new QuadParticleData();
        p.loc.x = x;
        p.loc.y = y;
        p.vel.x = dx;
        p.vel.y = dy;
        p.size = size;
        p.color = color;
        p.maxDur = maxDur;
        p.fadeTime = fadeTime;
        p.floorMod = (float)Math.random() * this.maxFloorMod;
        this.particles.add(p);
    }

    public boolean isParticleOnFloor(QuadParticleData curr) {
        return curr.loc.y <= this.floor + curr.floorMod;
    }

    public void advance(float amount) {
        Iterator<QuadParticleData> iter = this.particles.iterator();
        while (iter.hasNext()) {
            QuadParticleData curr = iter.next();
            curr.elapsed += amount;
            if (this.gravity > 0.0f) {
                curr.vel.y -= this.gravity * amount;
            }
            curr.loc.x += curr.vel.x * amount;
            curr.loc.y += curr.vel.y * amount;
            if (curr.loc.y < this.floor + curr.floorMod) {
                curr.loc.y = this.floor + curr.floorMod;
                if (this.floorFriction > 0.0f) {
                    curr.vel.scale(Math.max(0.0f, 1.0f - this.floorFriction * amount));
                }
            }
            if (!(curr.elapsed > curr.maxDur)) continue;
            iter.remove();
        }
    }

    public void render(float alphaMult, boolean onFloor) {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        if (this.additiveBlend) {
            GL11.glBlendFunc((int)770, (int)1);
        } else {
            GL11.glBlendFunc((int)770, (int)771);
        }
        for (QuadParticleData p : this.particles) {
            if (this.isParticleOnFloor(p) != onFloor) continue;
            float a = alphaMult;
            float left = p.maxDur - p.elapsed;
            if (left < 0.0f) {
                left = 0.0f;
            }
            if (left < p.fadeTime) {
                a *= left / p.fadeTime;
            }
            Misc.renderQuad(p.loc.x - p.size / 2.0f, p.loc.y - p.size / 2.0f, p.size, p.size, p.color, a);
        }
    }

    public boolean isDone() {
        return this.particles.isEmpty();
    }

    public static class QuadParticleData {
        public Vector2f loc = new Vector2f();
        public Vector2f vel = new Vector2f();
        public Color color;
        public float size;
        public float elapsed;
        public float maxDur;
        public float fadeTime;
        public float floorMod = 0.0f;
    }
}

