/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.events;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignClockAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlayerMarketTransaction;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.ColonyInteractionListener;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.AdminData;
import com.fs.starfarer.api.characters.FullName;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.OfficerDataAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.CallEvent;
import com.fs.starfarer.api.plugins.OfficerLevelupPlugin;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTracker;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;

public class OfficerManagerEvent
extends BaseEventPlugin
implements CallEvent.CallableEvent,
ColonyInteractionListener,
EveryFrameScript {
    public static Logger log = Global.getLogger(OfficerManagerEvent.class);
    protected IntervalUtil removeTracker = new IntervalUtil(1.0f, 3.0f);
    protected List<AvailableOfficer> available = new ArrayList<AvailableOfficer>();
    protected List<AvailableOfficer> availableAdmins = new ArrayList<AvailableOfficer>();
    protected TimeoutTracker<String> recentlyChecked = new TimeoutTracker();
    protected long seed = 0L;
    public static boolean DEBUG = false;

    public OfficerManagerEvent() {
        this.readResolve();
        Global.getSector().getListenerManager().addListener(this);
    }

    Object readResolve() {
        if (this.availableAdmins == null) {
            this.availableAdmins = new ArrayList<AvailableOfficer>();
        }
        if (this.recentlyChecked == null) {
            this.recentlyChecked = new TimeoutTracker();
        }
        if (this.seed == 0L) {
            this.seed = Misc.random.nextLong();
        }
        return this;
    }

    @Override
    public void reportPlayerClosedMarket(MarketAPI market) {
    }

    @Override
    public void reportPlayerOpenedMarket(MarketAPI market) {
        if (this.recentlyChecked.contains(market.getId())) {
            return;
        }
        if (market.isPlanetConditionMarketOnly()) {
            return;
        }
        if (market.getFaction().isNeutralFaction()) {
            return;
        }
        if (!market.isInEconomy()) {
            return;
        }
        if (market.hasTag("market_no_officer_spawn")) {
            return;
        }
        this.pruneFromRemovedMarkets();
        float officerProb = market.getStats().getDynamic().getMod("officer_prob").computeEffective(0.0f);
        float additionalProb = market.getStats().getDynamic().getMod("additional_officer_prob_mult").computeEffective(0.0f);
        float mercProb = market.getStats().getDynamic().getMod("officer_is_merc_prob").computeEffective(0.0f);
        float adminProb = market.getStats().getDynamic().getMod("admin_prob").computeEffective(0.0f);
        log.info((Object)("Spawning officers/admins at " + market.getId()));
        log.info((Object)("    officerProb: " + officerProb));
        log.info((Object)("    additionalProb: " + additionalProb));
        log.info((Object)("    mercProb: " + mercProb));
        log.info((Object)("    adminProb: " + adminProb));
        log.info((Object)"");
        CampaignClockAPI clock = Global.getSector().getClock();
        long mult = (long)clock.getCycle() * 12L + (long)clock.getMonth();
        Random random = Misc.getRandom(this.seed + (long)market.getId().hashCode() * mult, 11);
        float dur = this.getOfficerDuration(random);
        this.recentlyChecked.add(market.getId(), dur * 0.5f);
        if (random.nextFloat() < officerProb) {
            boolean merc = random.nextFloat() < mercProb;
            AvailableOfficer officer = this.createOfficer(merc, market, random);
            officer.person.setPortraitSprite(OfficerManagerEvent.pickPortraitPreferNonDuplicate(market.getFaction(), officer.person.getGender()));
            officer.timeRemaining = dur;
            this.addAvailable(officer);
            log.info((Object)("Added officer at " + officer.marketId));
            if (random.nextFloat() < officerProb * additionalProb) {
                merc = random.nextFloat() < mercProb;
                officer = this.createOfficer(merc, market, random);
                officer.person.setPortraitSprite(OfficerManagerEvent.pickPortraitPreferNonDuplicate(market.getFaction(), officer.person.getGender()));
                officer.timeRemaining = dur;
                this.addAvailable(officer);
                log.info((Object)("Added officer at [" + officer.marketId + "]"));
            }
        }
        if (random.nextFloat() < adminProb) {
            AvailableOfficer officer = this.createAdmin(market, random);
            officer.timeRemaining = dur;
            officer.person.setPortraitSprite(OfficerManagerEvent.pickPortraitPreferNonDuplicate(market.getFaction(), officer.person.getGender()));
            this.addAvailableAdmin(officer);
            log.info((Object)("Added admin at [" + officer.marketId + "]"));
        }
    }

    protected float getOfficerDuration(Random random) {
        return 60.0f + 60.0f * random.nextFloat();
    }

    @Override
    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.recentlyChecked.advance(days);
        this.removeTracker.advance(days);
        if (this.removeTracker.intervalElapsed()) {
            this.pruneFromRemovedMarkets();
            float interval = this.removeTracker.getIntervalDuration();
            for (AvailableOfficer curr : new ArrayList<AvailableOfficer>(this.available)) {
                curr.timeRemaining -= interval;
                if (!(curr.timeRemaining <= 0.0f)) continue;
                this.removeAvailable(curr);
                log.info((Object)("Removed officer from [" + curr.marketId + "]"));
            }
            for (AvailableOfficer curr : new ArrayList<AvailableOfficer>(this.availableAdmins)) {
                curr.timeRemaining -= interval;
                if (!(curr.timeRemaining <= 0.0f)) continue;
                this.removeAvailable(curr);
                log.info((Object)("Removed freelance admin from [" + curr.marketId + "]"));
            }
        }
    }

    public void pruneFromRemovedMarkets() {
        for (AvailableOfficer curr : new ArrayList<AvailableOfficer>(this.available)) {
            if (Global.getSector().getEconomy().getMarket(curr.marketId) != null) continue;
            this.removeAvailable(curr);
        }
        for (AvailableOfficer curr : new ArrayList<AvailableOfficer>(this.availableAdmins)) {
            if (Global.getSector().getEconomy().getMarket(curr.marketId) != null) continue;
            this.removeAvailable(curr);
        }
    }

    public void addAvailable(AvailableOfficer officer) {
        if (officer == null) {
            return;
        }
        this.available.add(officer);
        this.setEventDataAndAddToMarket(officer);
    }

    public void addAvailableAdmin(AvailableOfficer officer) {
        if (officer == null) {
            return;
        }
        this.availableAdmins.add(officer);
        this.setEventDataAndAddToMarket(officer);
    }

    protected void setEventDataAndAddToMarket(AvailableOfficer officer) {
        MarketAPI market = Global.getSector().getEconomy().getMarket(officer.marketId);
        if (market == null) {
            return;
        }
        market.getCommDirectory().addPerson(officer.person);
        market.addPerson(officer.person);
        officer.person.getMemoryWithoutUpdate().set("$ome_hireable", true);
        officer.person.getMemoryWithoutUpdate().set("$ome_eventRef", this);
        officer.person.getMemoryWithoutUpdate().set("$ome_hiringBonus", Misc.getWithDGS(officer.hiringBonus));
        officer.person.getMemoryWithoutUpdate().set("$ome_salary", Misc.getWithDGS(officer.salary));
    }

    public void removeAvailable(AvailableOfficer officer) {
        if (officer == null) {
            return;
        }
        this.available.remove(officer);
        this.availableAdmins.remove(officer);
        MarketAPI market = Global.getSector().getEconomy().getMarket(officer.marketId);
        if (market != null) {
            market.getCommDirectory().removePerson(officer.person);
            market.removePerson(officer.person);
        }
        officer.person.getMemoryWithoutUpdate().unset("$ome_hireable");
        officer.person.getMemoryWithoutUpdate().unset("$ome_eventRef");
        officer.person.getMemoryWithoutUpdate().unset("$ome_hiringBonus");
        officer.person.getMemoryWithoutUpdate().unset("$ome_salary");
    }

    public static String pickPortraitPreferNonDuplicate(FactionAPI faction, FullName.Gender gender) {
        if (faction == null) {
            faction = Global.getSector().getFaction("independent");
        }
        WeightedRandomPicker<String> all = faction.getPortraits(gender);
        WeightedRandomPicker<Object> picker = new WeightedRandomPicker();
        HashSet<String> exclude = new HashSet<String>();
        exclude.add(Global.getSector().getPlayerPerson().getPortraitSprite());
        if (Global.getSector().getPlayerFleet() != null) {
            for (OfficerDataAPI od : Global.getSector().getPlayerFleet().getFleetData().getOfficersCopy()) {
                exclude.add(od.getPerson().getPortraitSprite());
            }
        }
        for (AdminData ad : Global.getSector().getCharacterData().getAdmins()) {
            exclude.add(ad.getPerson().getPortraitSprite());
        }
        for (String p : all.getItems()) {
            if (exclude.contains(p)) continue;
            picker.add(p);
        }
        if (picker.isEmpty()) {
            picker = all;
        }
        return (String)picker.pick();
    }

    protected AvailableOfficer createAdmin(MarketAPI market, Random random) {
        if (market == null) {
            return null;
        }
        WeightedRandomPicker<Integer> tierPicker = new WeightedRandomPicker<Integer>();
        tierPicker.add(0, 60.0f);
        tierPicker.add(1, 40.0f);
        int tier = (Integer)tierPicker.pick();
        PersonAPI person = OfficerManagerEvent.createAdmin(market.getFaction(), tier, random);
        person.setFaction("independent");
        String hireKey = "adminHireTier" + tier;
        int hiringBonus = Global.getSettings().getInt(hireKey);
        int salary = (int)Misc.getAdminSalary(person);
        AvailableOfficer result = new AvailableOfficer(person, market.getId(), hiringBonus, salary);
        return result;
    }

    public static PersonAPI createAdmin(FactionAPI faction, int tier, Random random) {
        if (random == null) {
            random = new Random();
        }
        PersonAPI person = faction.createRandomPerson(random);
        person.getStats().setSkipRefresh(true);
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(random);
        List<String> allSkillIds = Global.getSettings().getSortedSkillIds();
        for (String skillId : allSkillIds) {
            SkillSpecAPI skill = Global.getSettings().getSkillSpec(skillId);
            if (skill.hasTag("deprecated") || skill.hasTag("player_only") || skill.hasTag("ai_core_only") || !skill.isAdminSkill()) continue;
            picker.add(skillId);
        }
        int i = 0;
        while (i < tier && !picker.isEmpty()) {
            String pick = (String)picker.pickAndRemove();
            person.getStats().setSkillLevel(pick, 3.0f);
            ++i;
        }
        person.getMemoryWithoutUpdate().set("$ome_isAdmin", true);
        person.getMemoryWithoutUpdate().set("$ome_adminTier", tier);
        person.setRankId(Ranks.CITIZEN);
        person.setPostId(Ranks.POST_FREELANCE_ADMIN);
        Object personalityPicker = faction.getPersonalityPicker().clone();
        String personality = (String)((WeightedRandomPicker)personalityPicker).pick();
        person.setPersonality(personality);
        person.getStats().setSkipRefresh(false);
        person.getStats().refreshCharacterStatsEffects();
        return person;
    }

    protected AvailableOfficer createOfficer(boolean isMerc, MarketAPI market, Random random) {
        if (market == null) {
            return null;
        }
        int level = 1;
        if ((float)Math.random() > 0.75f) {
            level = 2;
        }
        float payMult = 1.0f;
        PersonAPI person = null;
        if (isMerc) {
            payMult = Global.getSettings().getFloat("officerMercPayMult");
            int minLevel = Global.getSettings().getInt("officerMercMinLevel");
            int maxLevel = Global.getSettings().getInt("officerMercMaxLevel");
            level = minLevel + Misc.random.nextInt(maxLevel + 1 - minLevel);
            int numElite = 1;
            if (level == maxLevel) {
                numElite = 2;
            }
            person = OfficerManagerEvent.createMercInternal(market.getFaction(), level, numElite, true, random);
            person.setRankId(Ranks.SPACE_CAPTAIN);
            person.setPostId(Ranks.POST_MERCENARY);
            Misc.setMercenary(person, true);
        } else {
            person = OfficerManagerEvent.createOfficerInternal(market.getFaction(), level, true, random);
            person.setPostId(Ranks.POST_OFFICER_FOR_HIRE);
        }
        person.setFaction("independent");
        int salary = (int)Misc.getOfficerSalary(person);
        AvailableOfficer result = new AvailableOfficer(person, market.getId(), (int)((float)(person.getStats().getLevel() * 2000) * payMult), salary);
        return result;
    }

    public static PersonAPI createOfficerInternal(FactionAPI faction, int level, boolean allowNonDoctrinePersonality, Random random) {
        return OfficerManagerEvent.createOfficer(faction, level, SkillPickPreference.ANY, allowNonDoctrinePersonality, null, false, false, -1, random);
    }

    public static PersonAPI createMercInternal(FactionAPI faction, int level, int numElite, boolean allowNonDoctrinePersonality, Random random) {
        SkillPickPreference pref = SkillPickPreference.ANY;
        return OfficerManagerEvent.createOfficer(faction, level, pref, allowNonDoctrinePersonality, null, true, true, numElite, random);
    }

    public static PersonAPI createOfficer(FactionAPI faction, int level) {
        return OfficerManagerEvent.createOfficer(faction, level, false);
    }

    public static PersonAPI createOfficer(FactionAPI faction, int level, boolean allowNonDoctrinePersonality) {
        return OfficerManagerEvent.createOfficer(faction, level, SkillPickPreference.ANY, allowNonDoctrinePersonality, null, false, true, -1, null);
    }

    public static PersonAPI createOfficer(FactionAPI faction, int level, SkillPickPreference pref, Random random) {
        return OfficerManagerEvent.createOfficer(faction, level, pref, false, null, false, true, -1, random);
    }

    public static PersonAPI createOfficer(FactionAPI faction, int level, SkillPickPreference pref, boolean allowNonDoctrinePersonality, CampaignFleetAPI fleet, boolean allowAnyLevel, boolean withEliteSkills, int eliteSkillsNumOverride, Random random) {
        if (random == null) {
            random = new Random();
        }
        PersonAPI person = faction.createRandomPerson(random);
        person.setFleet(fleet);
        OfficerLevelupPlugin plugin = (OfficerLevelupPlugin)Global.getSettings().getPlugin("officerLevelUp");
        if (!allowAnyLevel && level > plugin.getMaxLevel(person)) {
            level = plugin.getMaxLevel(person);
        }
        person.getStats().setSkipRefresh(true);
        if (DEBUG) {
            System.out.println("Generating officer\n");
        }
        ArrayList<String> fixedSkills = new ArrayList<String>(faction.getDoctrine().getOfficerSkills());
        Iterator iter = fixedSkills.iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            SkillSpecAPI spec = Global.getSettings().getSkillSpec(id);
            if (spec == null || !spec.hasTag("player_only")) continue;
            iter.remove();
        }
        if (random.nextFloat() < faction.getDoctrine().getOfficerSkillsShuffleProbability()) {
            Collections.shuffle(fixedSkills, random);
        }
        int numSpec = 0;
        int i = 0;
        while (i < 1) {
            List<String> skills = plugin.pickLevelupSkills(person, random);
            String skillId = OfficerManagerEvent.pickSkill(person, skills, pref, numSpec, random);
            if (!fixedSkills.isEmpty()) {
                skillId = (String)fixedSkills.remove(0);
            }
            if (skillId != null) {
                if (DEBUG) {
                    System.out.println("Picking initial skill: " + skillId);
                }
                person.getStats().increaseSkill(skillId);
                SkillSpecAPI spec = Global.getSettings().getSkillSpec(skillId);
                if (spec.hasTag("spec")) {
                    ++numSpec;
                }
            }
            ++i;
        }
        long xp = plugin.getXPForLevel(level);
        OfficerDataAPI officerData = Global.getFactory().createOfficerData(person);
        officerData.addXP(xp, null, false);
        officerData.makeSkillPicks(random);
        while (officerData.canLevelUp(allowAnyLevel)) {
            String skillId = OfficerManagerEvent.pickSkill(officerData.getPerson(), officerData.getSkillPicks(), pref, numSpec, random);
            if (!fixedSkills.isEmpty()) {
                skillId = (String)fixedSkills.remove(0);
            }
            if (skillId == null) break;
            if (DEBUG) {
                System.out.println("Leveling up " + skillId);
            }
            officerData.levelUp(skillId, random);
            SkillSpecAPI spec = Global.getSettings().getSkillSpec(skillId);
            if (spec.hasTag("spec")) {
                ++numSpec;
            }
            if (!allowAnyLevel || !officerData.getSkillPicks().isEmpty()) continue;
            officerData.makeSkillPicks(random);
        }
        if (withEliteSkills && eliteSkillsNumOverride != 0) {
            int num = eliteSkillsNumOverride;
            if (num < 0 && (num = plugin.getMaxEliteSkills(person)) > 1 && faction != null && faction.getId().startsWith("tri")) {
                num = plugin.getMaxEliteSkills(person);
            }
            OfficerManagerEvent.addEliteSkills(person, num, random);
        }
        if (DEBUG) {
            System.out.println("Done\n");
        }
        person.setRankId(Ranks.SPACE_LIEUTENANT);
        person.setPostId(Ranks.POST_OFFICER);
        Object personalityPicker = faction.getPersonalityPicker().clone();
        if (allowNonDoctrinePersonality) {
            ((WeightedRandomPicker)personalityPicker).add("timid", 4.0f);
            ((WeightedRandomPicker)personalityPicker).add("cautious", 4.0f);
            ((WeightedRandomPicker)personalityPicker).add("steady", 4.0f);
            ((WeightedRandomPicker)personalityPicker).add("aggressive", 4.0f);
            ((WeightedRandomPicker)personalityPicker).add("reckless", 4.0f);
        }
        String personality = (String)((WeightedRandomPicker)personalityPicker).pick();
        person.setPersonality(personality);
        person.getStats().setSkipRefresh(false);
        person.getStats().refreshCharacterStatsEffects();
        return person;
    }

    public static void addEliteSkills(PersonAPI person, int num, Random random) {
        if (num <= 0) {
            return;
        }
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(random);
        for (MutableCharacterStatsAPI.SkillLevelAPI sl : person.getStats().getSkillsCopy()) {
            if (sl.getSkill().hasTag("elite_player_only") || sl.getSkill().isAptitudeEffect() || !sl.getSkill().isCombatOfficerSkill()) continue;
            picker.add(sl.getSkill().getId(), 1.0f);
        }
        int i = 0;
        while (i < num && !picker.isEmpty()) {
            String id = (String)picker.pickAndRemove();
            if (id != null) {
                if (DEBUG) {
                    System.out.println("Making skill elite: " + id);
                }
                person.getStats().increaseSkill(id);
            }
            ++i;
        }
    }

    public static String pickSkill(PersonAPI person, List<String> skills, SkillPickPreference pref, int numSpec, Random random) {
        if (random == null) {
            random = new Random();
        }
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(random);
        ArrayList<String> generic = new ArrayList<String>();
        boolean energy = pref.name().contains("YES_ENERGY");
        boolean ballistic = pref.name().contains("YES_BALLISTIC");
        boolean missile = pref.name().contains("YES_MISSILE");
        boolean defense = pref.name().contains("YES_DEFENSE");
        for (String id : skills) {
            SkillSpecAPI spec = Global.getSettings().getSkillSpec(id);
            boolean energySkill = spec.hasTag("energy_weapons");
            boolean ballisticSkill = spec.hasTag("ballistic_weapons");
            boolean missileSkill = spec.hasTag("missile_weapons");
            boolean defenseSkill = spec.hasTag("active_defenses");
            boolean preferred = true;
            if (pref != SkillPickPreference.ANY) {
                if (!energy && energySkill) {
                    preferred = false;
                }
                if (!ballistic && ballisticSkill) {
                    preferred = false;
                }
                if (!missile && missileSkill) {
                    preferred = false;
                }
                if (!defense && defenseSkill) {
                    preferred = false;
                }
            }
            if (spec.hasTag("player_only")) {
                preferred = false;
            }
            if (preferred) {
                picker.add(id);
                continue;
            }
            generic.add(id);
        }
        if (picker.isEmpty()) {
            picker.addAll(generic);
            if (picker.isEmpty()) {
                picker.addAll(skills);
            }
        }
        return (String)picker.pick();
    }

    @Override
    public boolean callEvent(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        String action = params.get(0).getString(memoryMap);
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CargoAPI cargo = playerFleet.getCargo();
        if (action.equals("printSkills")) {
            String personId = params.get(1).getString(memoryMap);
            AvailableOfficer officer = this.getOfficer(personId);
            boolean admin = false;
            int adminTier = 0;
            if (officer == null) {
                officer = this.getAdmin(personId);
                admin = true;
                if (officer != null) {
                    adminTier = (int)officer.person.getMemoryWithoutUpdate().getFloat("$ome_adminTier");
                }
            }
            if (officer != null) {
                MutableCharacterStatsAPI stats = officer.person.getStats();
                TextPanelAPI text = dialog.getTextPanel();
                Color hl = Misc.getHighlightColor();
                Color red = Misc.getNegativeHighlightColor();
                text.addSkillPanel(officer.person, admin);
                text.setFontSmallInsignia();
                if (!admin) {
                    String personality = Misc.lcFirst(officer.person.getPersonalityAPI().getDisplayName());
                    text.addParagraph("Personality: " + personality + ", level: " + stats.getLevel());
                    text.highlightInLastPara(hl, personality, "" + stats.getLevel());
                    text.addParagraph(officer.person.getPersonalityAPI().getDescription());
                }
                text.setFontInsignia();
            }
        } else if (action.equals("hireOfficer")) {
            String personId = params.get(1).getString(memoryMap);
            AvailableOfficer officer = this.getOfficer(personId);
            boolean admin = false;
            if (officer == null) {
                officer = this.getAdmin(personId);
                if (officer != null) {
                    officer.person.setPostId(Ranks.POST_ADMINISTRATOR);
                }
                admin = true;
            }
            if (officer != null) {
                this.removeAvailable(officer);
                if (admin) {
                    Global.getSector().getCharacterData().addAdmin(officer.person);
                } else {
                    playerFleet.getFleetData().addOfficer(officer.person);
                    if (Misc.isMercenary(officer.person)) {
                        Misc.setMercHiredNow(officer.person);
                    } else {
                        officer.person.setPostId(Ranks.POST_OFFICER);
                    }
                }
                AddRemoveCommodity.addCreditsLossText(officer.hiringBonus, dialog.getTextPanel());
                if (admin) {
                    AddRemoveCommodity.addAdminGainText(officer.person, dialog.getTextPanel());
                } else {
                    AddRemoveCommodity.addOfficerGainText(officer.person, dialog.getTextPanel());
                }
                playerFleet.getCargo().getCredits().subtract(officer.hiringBonus);
                if (playerFleet.getCargo().getCredits().get() <= 0.0f) {
                    playerFleet.getCargo().getCredits().set(0.0f);
                }
            }
        } else {
            if (action.equals("atLimit")) {
                String personId = params.get(1).getString(memoryMap);
                AvailableOfficer officer = this.getOfficer(personId);
                boolean admin = false;
                if (officer == null) {
                    officer = this.getAdmin(personId);
                    admin = true;
                }
                int max = playerFleet.getCommander().getStats().getOfficerNumber().getModifiedInt();
                if (admin) {
                    max = playerFleet.getCommander().getStats().getAdminNumber().getModifiedInt();
                    return Global.getSector().getCharacterData().getAdmins().size() >= max;
                }
                return Misc.getNumNonMercOfficers(playerFleet) >= max;
            }
            if (action.equals("canAfford")) {
                String personId = params.get(1).getString(memoryMap);
                AvailableOfficer officer = this.getOfficer(personId);
                if (officer == null) {
                    officer = this.getAdmin(personId);
                }
                if (officer != null) {
                    return playerFleet.getCargo().getCredits().get() >= (float)officer.hiringBonus;
                }
                return false;
            }
        }
        return true;
    }

    public AvailableOfficer getOfficer(String personId) {
        for (AvailableOfficer officer : this.available) {
            if (!officer.person.getId().equals(personId)) continue;
            return officer;
        }
        return null;
    }

    public AvailableOfficer getAdmin(String personId) {
        for (AvailableOfficer officer : this.availableAdmins) {
            if (!officer.person.getId().equals(personId)) continue;
            return officer;
        }
        return null;
    }

    @Override
    public void reportPlayerMarketTransaction(PlayerMarketTransaction transaction) {
    }

    @Override
    public void reportPlayerOpenedMarketAndCargoUpdated(MarketAPI market) {
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    public static class AvailableOfficer {
        public PersonAPI person;
        public String marketId;
        public int hiringBonus;
        public int salary;
        public float timeRemaining = 0.0f;

        public AvailableOfficer(PersonAPI person, String marketId, int hiringBonus, int salary) {
            this.person = person;
            this.marketId = marketId;
            this.hiringBonus = hiringBonus;
            this.salary = salary;
        }
    }

    public static enum SkillPickPreference {
        CARRIER,
        GENERIC,
        PHASE,
        YES_ENERGY_YES_BALLISTIC_YES_MISSILE_YES_DEFENSE,
        YES_ENERGY_YES_BALLISTIC_NO_MISSILE_YES_DEFENSE,
        YES_ENERGY_YES_BALLISTIC_YES_MISSILE_NO_DEFENSE,
        YES_ENERGY_YES_BALLISTIC_NO_MISSILE_NO_DEFENSE,
        YES_ENERGY_NO_BALLISTIC_YES_MISSILE_YES_DEFENSE,
        YES_ENERGY_NO_BALLISTIC_NO_MISSILE_YES_DEFENSE,
        YES_ENERGY_NO_BALLISTIC_YES_MISSILE_NO_DEFENSE,
        YES_ENERGY_NO_BALLISTIC_NO_MISSILE_NO_DEFENSE,
        NO_ENERGY_YES_BALLISTIC_YES_MISSILE_YES_DEFENSE,
        NO_ENERGY_YES_BALLISTIC_NO_MISSILE_YES_DEFENSE,
        NO_ENERGY_YES_BALLISTIC_YES_MISSILE_NO_DEFENSE,
        NO_ENERGY_YES_BALLISTIC_NO_MISSILE_NO_DEFENSE,
        NO_ENERGY_NO_BALLISTIC_YES_MISSILE_YES_DEFENSE,
        NO_ENERGY_NO_BALLISTIC_NO_MISSILE_YES_DEFENSE,
        NO_ENERGY_NO_BALLISTIC_YES_MISSILE_NO_DEFENSE,
        NO_ENERGY_NO_BALLISTIC_NO_MISSILE_NO_DEFENSE,
        ANY;

    }
}

