/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.impl.campaign.shared.CommodityStatTracker;
import com.fs.starfarer.api.util.Misc;

public class PriceUpdate
implements CampaignEventPlugin.PriceUpdatePlugin {
    private String marketId;
    private String commodityId;
    private float supplyPrice;
    private float demandPrice;
    private CampaignEventPlugin.PriceUpdatePlugin.PriceType type;
    private long timestamp;
    private float demand;

    public PriceUpdate(CommodityOnMarketAPI commodity) {
        this.marketId = commodity.getMarket().getId();
        this.commodityId = commodity.getId();
        this.supplyPrice = Math.round(commodity.getMarket().getSupplyPrice(commodity.getId(), 1.0, true));
        this.demandPrice = Math.round(commodity.getMarket().getDemandPrice(commodity.getId(), 1.0, true));
        this.updateType();
        this.timestamp = Global.getSector().getClock().getTimestamp();
        this.demand = commodity.getDemand().getDemandValue();
    }

    public void updatePrices(float stockpileMult) {
        CommodityOnMarketAPI com = this.getCommodity();
        float stockpile = com.getStockpile();
        float after = stockpile * stockpileMult;
        float diff = (after - stockpile) * com.getUtilityOnMarket();
        this.supplyPrice = Math.round(com.getMarket().getSupplyPriceAssumingExistingTransaction(com.getId(), 1.0, diff, true));
        this.demandPrice = Math.round(com.getMarket().getDemandPriceAssumingExistingTransaction(com.getId(), 1.0, diff, true));
    }

    @Override
    public int getRoundedPriceForDisplay() {
        return this.getRoundedPriceForDisplay(0.0f, 0.0f);
    }

    public int getRoundedPriceForDisplay(float priceFlat, float pricePercent) {
        CommodityOnMarketAPI commodity;
        float testSupplyPrice = this.supplyPrice;
        float testDemandPrice = this.demandPrice;
        if (priceFlat != 0.0f || pricePercent != 0.0f) {
            commodity = this.getCommodity();
            testSupplyPrice = Math.round(commodity.getMarket().getSupplyPrice(commodity.getId(), 1.0, true) * (1.0f + pricePercent / 100.0f) + priceFlat);
            testDemandPrice = Math.round(commodity.getMarket().getDemandPrice(commodity.getId(), 1.0, true) * (1.0f + pricePercent / 100.0f) + priceFlat);
        }
        commodity = this.getCommodity();
        testSupplyPrice = Math.round(commodity.getMarket().getSupplyPrice(commodity.getId(), 1.0, true));
        testDemandPrice = Math.round(commodity.getMarket().getDemandPrice(commodity.getId(), 1.0, true));
        this.supplyPrice = testSupplyPrice;
        this.demandPrice = testDemandPrice;
        this.updateType();
        int amt = 0;
        switch (this.getType()) {
            case NORMAL: {
                amt = (int)(testSupplyPrice + testDemandPrice) / 2;
                break;
            }
            case CHEAP: {
                amt = (int)testSupplyPrice;
                break;
            }
            case EXPENSIVE: {
                amt = (int)testDemandPrice;
            }
        }
        amt = (int)Misc.getRounded(amt);
        return amt;
    }

    @Override
    public float getDemand() {
        return this.demand;
    }

    @Override
    public float getAvailable() {
        CommodityOnMarketAPI com = this.getMarket().getCommodityData(this.commodityId);
        float available = com.getStockpile();
        return available;
    }

    @Override
    public void updateType() {
        this.updateType(0.0f, 0.0f);
    }

    public void updateType(float priceFlat, float pricePercent) {
        CommodityOnMarketAPI commodity = this.getCommodity();
        CommodityStatTracker stats = new CommodityStatTracker();
        float testSupplyPrice = this.supplyPrice;
        float testDemandPrice = this.demandPrice;
        if (priceFlat != 0.0f || pricePercent != 0.0f) {
            testSupplyPrice = Math.round(commodity.getMarket().getSupplyPrice(commodity.getId(), 1.0, true) * (1.0f + pricePercent / 100.0f) + priceFlat);
            testDemandPrice = Math.round(commodity.getMarket().getDemandPrice(commodity.getId(), 1.0, true) * (1.0f + pricePercent / 100.0f) + priceFlat);
        }
        this.type = stats.isSupplyPriceSignificant(commodity, Misc.getRounded(testSupplyPrice)) ? CampaignEventPlugin.PriceUpdatePlugin.PriceType.CHEAP : (stats.isDemandPriceSignificant(commodity, Misc.getRounded(testDemandPrice)) ? CampaignEventPlugin.PriceUpdatePlugin.PriceType.EXPENSIVE : CampaignEventPlugin.PriceUpdatePlugin.PriceType.NORMAL);
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isSignificant() {
        return this.isSignificant(0.0f, 0.0f);
    }

    public boolean isSignificant(float priceFlat, float pricePercent) {
        this.updateType(priceFlat, pricePercent);
        CommodityOnMarketAPI commodity = this.getCommodity();
        if (this.getType() == CampaignEventPlugin.PriceUpdatePlugin.PriceType.CHEAP && commodity.getStockpile() < 100.0f) {
            return false;
        }
        if (this.getType() == CampaignEventPlugin.PriceUpdatePlugin.PriceType.NORMAL && commodity.getStockpile() + commodity.getDemand().getDemandValue() < 100.0f) {
            return false;
        }
        return this.getType() != CampaignEventPlugin.PriceUpdatePlugin.PriceType.EXPENSIVE || !(commodity.getDemand().getDemandValue() < 100.0f);
    }

    @Override
    public MarketAPI getMarket() {
        return Global.getSector().getEconomy().getMarket(this.marketId);
    }

    @Override
    public CommodityOnMarketAPI getCommodity() {
        MarketAPI market = this.getMarket();
        if (market == null) {
            return null;
        }
        return market.getCommodityData(this.commodityId);
    }

    @Override
    public float getSupplyPrice() {
        return this.supplyPrice;
    }

    @Override
    public float getDemandPrice() {
        return this.demandPrice;
    }

    @Override
    public CampaignEventPlugin.PriceUpdatePlugin.PriceType getType() {
        return this.type;
    }
}

