/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;

public class RecentUnrestEvent
extends BaseEventPlugin {
    public static final float DAYS_PER_STAGE = 10.0f;
    private float elapsedDays = 0.0f;
    private int stabilityPenalty = 0;
    private String conditionToken = null;
    private boolean ended = false;

    @Override
    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget, false);
    }

    @Override
    public void startEvent() {
        super.startEvent(true);
        if (this.market == null) {
            this.endEvent();
            return;
        }
        this.conditionToken = this.market.addCondition("recent_unrest", this);
    }

    @Override
    public void advance(float amount) {
        if (!this.isEventStarted()) {
            return;
        }
        if (this.isDone()) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.elapsedDays += days;
        if (this.elapsedDays >= 10.0f) {
            this.elapsedDays -= 10.0f;
            --this.stabilityPenalty;
            this.market.reapplyCondition(this.conditionToken);
        }
        if (this.stabilityPenalty <= 0) {
            this.endEvent();
        }
    }

    private void endEvent() {
        if (this.market != null && this.conditionToken != null) {
            this.market.removeSpecificCondition(this.conditionToken);
        }
        this.ended = true;
    }

    @Override
    public boolean isDone() {
        return this.ended;
    }

    public int getStabilityPenalty() {
        return this.stabilityPenalty;
    }

    public void setStabilityPenalty(int stabilityPenalty) {
        if (this.isDone()) {
            return;
        }
        this.stabilityPenalty = stabilityPenalty;
        if (stabilityPenalty <= 0) {
            this.endEvent();
        } else {
            this.market.reapplyCondition(this.conditionToken);
        }
    }

    public void increaseStabilityPenalty(int penalty) {
        if (this.isDone()) {
            return;
        }
        this.stabilityPenalty += penalty;
        if (this.stabilityPenalty <= 0) {
            this.endEvent();
        } else {
            this.market.reapplyCondition(this.conditionToken);
        }
    }

    public void reduceStabilityPenalty(int penalty) {
        if (this.isDone()) {
            return;
        }
        this.stabilityPenalty -= penalty;
        if (this.stabilityPenalty <= 0) {
            this.endEvent();
        } else {
            this.market.reapplyCondition(this.conditionToken);
        }
    }

    @Override
    public String getEventName() {
        if (this.isDone()) {
            return "Recent unrest at null market";
        }
        return "Recent unrest at " + this.market.getName();
    }
}

