/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.events.nearby;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseAssignmentAI;
import com.fs.starfarer.api.util.Misc;

public class DistressCallPirateAmbushAssignmentAI
extends BaseAssignmentAI {
    protected StarSystemAPI system;
    protected SectorEntityToken jumpPoint;
    protected float elapsed = 0.0f;
    protected float dur = 30.0f + (float)Math.random() * 20.0f;

    public DistressCallPirateAmbushAssignmentAI(CampaignFleetAPI fleet, StarSystemAPI system, SectorEntityToken jumpPoint) {
        this.fleet = fleet;
        this.system = system;
        this.jumpPoint = jumpPoint;
        this.giveInitialAssignments();
    }

    @Override
    protected void giveInitialAssignments() {
        this.fleet.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, this.jumpPoint, 1000.0f, "laying in wait");
    }

    @Override
    protected void pickNext() {
        this.fleet.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, this.jumpPoint, 1000.0f, "laying in wait");
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        float days = Global.getSector().getClock().convertToDays(amount);
        this.elapsed += days;
        if (this.elapsed >= this.dur) {
            Misc.giveStandardReturnToSourceAssignments(this.fleet);
        }
    }
}

