/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;

public class AutoDespawnScript
implements EveryFrameScript {
    protected CampaignFleetAPI fleet;
    protected float elapsed = 0.0f;

    public AutoDespawnScript(CampaignFleetAPI fleet) {
        this.fleet = fleet;
    }

    @Override
    public void advance(float amount) {
        if (!this.fleet.isInCurrentLocation()) {
            this.elapsed += Global.getSector().getClock().convertToDays(amount);
            if (this.elapsed > 30.0f && this.fleet.getBattle() == null) {
                this.fleet.despawn(CampaignEventListener.FleetDespawnReason.PLAYER_FAR_AWAY, null);
                this.elapsed = -1.0f;
            }
        } else {
            this.elapsed = 0.0f;
        }
    }

    @Override
    public boolean isDone() {
        return this.elapsed < 0.0f;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }
}

