/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.impl.campaign.fleets.DisposableFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactory;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.intel.SystemBountyManager;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateActivity;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseManager;
import com.fs.starfarer.api.util.Misc;

public class DisposablePirateFleetManager
extends DisposableFleetManager {
    @Override
    protected Object readResolve() {
        super.readResolve();
        return this;
    }

    @Override
    protected String getSpawnId() {
        return "pirates";
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
    }

    @Override
    protected int getDesiredNumFleetsForSpawnLocation() {
        PirateBaseIntel.PirateBaseTier tier = this.getPirateActivityTier();
        MarketAPI largestBounty = this.getLargestMarketIfSystemHasBounty();
        float tierMult = this.getMultForTier(tier);
        float bountyMult = largestBounty == null ? 0 : largestBounty.getSize();
        float desiredNumFleets = 1.0f;
        desiredNumFleets += tierMult > 0.0f ? 3.0f + tierMult : 0.0f;
        return Math.round(desiredNumFleets += bountyMult);
    }

    protected float getMultForTier(PirateBaseIntel.PirateBaseTier tier) {
        if (tier == null) {
            return 0.0f;
        }
        return (float)tier.ordinal() + 1.0f;
    }

    protected PirateBaseIntel.PirateBaseTier getPirateActivityTier() {
        if (this.currSpawnLoc == null) {
            return null;
        }
        for (MarketAPI market : Global.getSector().getEconomy().getMarkets(this.currSpawnLoc)) {
            MarketConditionAPI mc;
            if (market.isHidden() || market.getFactionId().equals("pirates") || (mc = market.getCondition("pirate_activity")) == null || !(mc.getPlugin() instanceof PirateActivity)) continue;
            PirateActivity pa = (PirateActivity)mc.getPlugin();
            return pa.getIntel() == null ? null : pa.getIntel().getTier();
        }
        return null;
    }

    protected boolean hasPirateActivity() {
        return this.getPirateActivityTier() != null;
    }

    protected MarketAPI getLargestMarketIfSystemHasBounty() {
        if (this.currSpawnLoc == null) {
            return null;
        }
        MarketAPI largest = null;
        boolean bounty = false;
        int maxSize = 0;
        for (MarketAPI market : Global.getSector().getEconomy().getMarkets(this.currSpawnLoc)) {
            if (market.isHidden() || market.getFactionId().equals("pirates")) continue;
            if (SystemBountyManager.getInstance().isActive(market)) {
                bounty = true;
            }
            if (market.getSize() <= maxSize) continue;
            maxSize = market.getSize();
            largest = market;
        }
        if (!bounty) {
            largest = null;
        }
        return largest;
    }

    @Override
    protected CampaignFleetAPI spawnFleetImpl() {
        CampaignFleetAPI fleet;
        float earlyTimeFactor;
        StarSystemAPI system = this.currSpawnLoc;
        if (system == null) {
            return null;
        }
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        if (player == null) {
            return null;
        }
        int num = Misc.getMarketsInLocation(system).size();
        if (Misc.getMarketsInLocation(system, "player").size() == num && num > 0) {
            return null;
        }
        PirateBaseIntel.PirateBaseTier tier = this.getPirateActivityTier();
        MarketAPI largestBounty = this.getLargestMarketIfSystemHasBounty();
        float tierMult = this.getMultForTier(tier);
        float bountyMult = 0.0f;
        if (largestBounty != null) {
            bountyMult = largestBounty.getSize();
        }
        float bonus = tierMult + bountyMult;
        float timeFactor = (PirateBaseManager.getInstance().getDaysSinceStart() - 180.0f) / 730.0f;
        if (timeFactor < 0.0f) {
            timeFactor = 0.0f;
        }
        if (timeFactor > 1.0f) {
            timeFactor = 1.0f;
        }
        if ((earlyTimeFactor = (PirateBaseManager.getInstance().getDaysSinceStart() - 60.0f) / 120.0f) < 0.0f) {
            earlyTimeFactor = 0.0f;
        }
        if (earlyTimeFactor > 1.0f) {
            earlyTimeFactor = 1.0f;
        }
        float r = (float)Math.random();
        float fp = (10.0f + bonus) * earlyTimeFactor + (5.0f + bonus) * (0.5f + 0.5f * (float)Math.random()) + 50.0f * (0.5f + 0.5f * r) * timeFactor;
        float desired = this.getDesiredNumFleetsForSpawnLocation();
        if (desired > 2.0f) {
            fp += (desired - 2.0f) * (0.5f + (float)Math.random() * 0.5f) * 2.0f * timeFactor;
        }
        if (fp < 10.0f) {
            fp = 10.0f;
        }
        FleetFactory.MercType type = fp < 25.0f ? FleetFactory.MercType.SCOUT : (fp < 75.0f ? FleetFactory.MercType.PRIVATEER : (fp < 125.0f ? FleetFactory.MercType.PATROL : FleetFactory.MercType.ARMADA));
        String fleetType = type.fleetType;
        float combat = fp;
        float tanker = 0.0f;
        if (type == FleetFactory.MercType.PATROL || type == FleetFactory.MercType.ARMADA) {
            tanker = combat * 0.1f;
        }
        combat = Math.round(combat);
        tanker = Math.round(tanker);
        FleetParamsV3 params = new FleetParamsV3(null, system.getLocation(), "pirates", null, fleetType, combat, 0.0f, tanker, 0.0f, 0.0f, 0.0f, 0.0f);
        params.ignoreMarketFleetSizeMult = true;
        if (timeFactor <= 0.0f) {
            params.maxShipSize = 1;
        }
        if ((fleet = FleetFactoryV3.createFleet(params)) == null || fleet.isEmpty()) {
            return null;
        }
        fleet.getMemoryWithoutUpdate().set("$isPirate", true);
        fleet.getMemoryWithoutUpdate().set("$core_fleetNoMilitaryResponse", true);
        this.setLocationAndOrders(fleet, 0.25f, 0.25f);
        return fleet;
    }
}

