/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.ShipRolePick;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.fleets.EconomyFleetRouteManager;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RouteFleetAssignmentAI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;

public class EconomyFleetAssignmentAI
extends RouteFleetAssignmentAI {
    private String origFaction;
    private IntervalUtil factionChangeTracker = new IntervalUtil(0.1f, 0.3f);

    public EconomyFleetAssignmentAI(CampaignFleetAPI fleet, RouteManager.RouteData route) {
        super(fleet, route);
        this.origFaction = route.getFactionId();
        if (!this.getData().smuggling) {
            this.origFaction = null;
            this.factionChangeTracker = null;
        } else {
            this.factionChangeTracker.forceIntervalElapsed();
            this.doSmugglingFactionChangeCheck(0.1f);
        }
    }

    public static String getCargoListDeliver(RouteManager.RouteData route) {
        return EconomyFleetAssignmentAI.getCargoList(route, route.getSegments().get(0));
    }

    public static String getCargoListReturn(RouteManager.RouteData route) {
        return EconomyFleetAssignmentAI.getCargoList(route, route.getSegments().get(3));
    }

    public static String getCargoList(RouteManager.RouteData route, RouteManager.RouteSegment segment) {
        EconomyRouteData data = (EconomyRouteData)route.getCustom();
        Integer id = segment.getId();
        if (id <= EconomyFleetRouteManager.ROUTE_DST_UNLOAD) {
            return EconomyRouteData.getCargoList(data.cargoDeliver);
        }
        return EconomyRouteData.getCargoList(data.cargoReturn);
    }

    protected String getCargoList(RouteManager.RouteSegment segment) {
        return EconomyFleetAssignmentAI.getCargoList(this.route, segment);
    }

    protected void updateCargo(RouteManager.RouteSegment segment) {
        float qty;
        Integer id = segment.getId();
        if (this.route.isExpired() || id == EconomyFleetRouteManager.ROUTE_SRC_LOAD || id == EconomyFleetRouteManager.ROUTE_DST_LOAD) {
            this.fleet.getCargo().clear();
            this.syncMothballedShips(0.0f, null);
            return;
        }
        EconomyRouteData data = this.getData();
        MarketAPI cargoSource = data.from;
        List<CargoQuantityData> list = data.cargoDeliver;
        if (id > EconomyFleetRouteManager.ROUTE_DST_LOAD) {
            cargoSource = data.to;
            list = data.cargoReturn;
        }
        CargoAPI cargo = this.fleet.getCargo();
        cargo.clear();
        float total = 0.0f;
        LinkedHashMap<String, Float> target = new LinkedHashMap<String, Float>();
        float ships = 0.0f;
        for (CargoQuantityData curr : list) {
            CommoditySpecAPI spec = Global.getSettings().getCommoditySpec(curr.cargo);
            qty = (int)(BaseIndustry.getSizeMult(curr.units) * spec.getEconUnit());
            if (curr.cargo.equals("ships")) {
                ships = Math.max(ships, (float)curr.units);
                continue;
            }
            if (curr.cargo.equals("fuel")) {
                cargo.addFuel(Math.min(qty, cargo.getMaxFuel()));
                continue;
            }
            if (curr.cargo.equals("crew") || curr.cargo.equals("marines")) continue;
            total += qty;
            target.put(curr.cargo, Float.valueOf(qty));
        }
        this.syncMothballedShips(ships, cargoSource);
        if (total <= 0.0f) {
            return;
        }
        float maxCargo = cargo.getMaxCapacity();
        for (String cid : target.keySet()) {
            qty = ((Float)target.get(cid)).floatValue();
            cargo.addCommodity(cid, (float)((int)qty) * Math.min(1.0f, maxCargo / total));
        }
    }

    protected void syncMothballedShips(float units, MarketAPI market) {
        for (FleetMemberAPI member : this.fleet.getFleetData().getMembersListCopy()) {
            if (!member.isMothballed()) continue;
            this.fleet.getFleetData().removeFleetMember(member);
        }
        if (units <= 0.0f) {
            return;
        }
        Random random = new Random();
        if (this.route.getSeed() != null) {
            random = new Random(this.route.getSeed());
        }
        float add = units * 1.5f + (float)random.nextInt(3);
        EconomyRouteData data = this.getData();
        boolean sameFaction = data.from.getFaction() == data.to.getFaction();
        int i = 0;
        while ((float)i < add) {
            WeightedRandomPicker<String> roles = new WeightedRandomPicker<String>(random);
            roles.add("combatFreighterSmall", 20.0f);
            roles.add("freighterSmall", 20.0f);
            roles.add("tankerSmall", 10.0f);
            if (i >= 2) {
                roles.add("combatFreighterMedium", 20.0f * (float)(i - 1));
                roles.add("freighterMedium", 20.0f * (float)(i - 1));
                roles.add("tankerMedium", 10.0f * (float)(i - 1));
            }
            if (i >= 5) {
                roles.add("combatFreighterLarge", 20.0f * (float)(i - 2));
                roles.add("freighterLarge", 20.0f * (float)(i - 2));
                roles.add("tankerLarge", 10.0f * (float)(i - 2));
            }
            String role = (String)roles.pick();
            FactionAPI.ShipPickParams params = FactionAPI.ShipPickParams.priority();
            if (!sameFaction) {
                params = FactionAPI.ShipPickParams.imported();
            }
            List<ShipRolePick> picks = market.pickShipsForRole(role, params, random, null);
            for (ShipRolePick pick : picks) {
                FleetMemberAPI member = this.fleet.getFleetData().addFleetMember(pick.variantId);
                member.getRepairTracker().setMothballed(true);
            }
            ++i;
        }
        this.fleet.getFleetData().sort();
    }

    @Override
    protected String getStartingActionText(RouteManager.RouteSegment segment) {
        String list = this.getCargoList(segment);
        if (list.isEmpty()) {
            return "preparing for a voyage to " + this.getData().to.getName();
        }
        return "loading " + list + " at " + this.getData().from.getName();
    }

    @Override
    protected String getEndingActionText(RouteManager.RouteSegment segment) {
        String list = this.getCargoList(segment);
        if (list.isEmpty()) {
            return "orbiting " + this.getData().from.getName();
        }
        return "unloading " + list + " at " + this.getData().from.getName();
    }

    @Override
    protected String getTravelActionText(RouteManager.RouteSegment segment) {
        String list = this.getCargoList(segment);
        Integer id = segment.getId();
        if (id == EconomyFleetRouteManager.ROUTE_TRAVEL_DST || id == EconomyFleetRouteManager.ROUTE_TRAVEL_WS) {
            if (list.isEmpty()) {
                return "traveling to " + this.getData().to.getName();
            }
            return "delivering " + list + " to " + this.getData().to.getName();
        }
        if (id == EconomyFleetRouteManager.ROUTE_TRAVEL_SRC || id == EconomyFleetRouteManager.ROUTE_TRAVEL_BACK_WS) {
            if (list.isEmpty()) {
                return "returning to " + this.getData().from.getName();
            }
            return "returning to " + this.getData().from.getName() + " with " + list;
        }
        return super.getTravelActionText(segment);
    }

    @Override
    protected String getInSystemActionText(RouteManager.RouteSegment segment) {
        String list = this.getCargoList(segment);
        Integer id = segment.getId();
        if (id == EconomyFleetRouteManager.ROUTE_DST_UNLOAD) {
            if (list.isEmpty()) {
                return "orbiting " + this.getData().to.getName();
            }
            return "unloading " + list + " at " + this.getData().to.getName();
        }
        if (id == EconomyFleetRouteManager.ROUTE_DST_LOAD) {
            if (list.isEmpty()) {
                return "orbiting " + this.getData().to.getName();
            }
            return "loading " + list + " at " + this.getData().to.getName();
        }
        if (id == EconomyFleetRouteManager.ROUTE_RESUPPLY_WS || id == EconomyFleetRouteManager.ROUTE_RESUPPLY_BACK_WS) {
            return "resupplying";
        }
        return super.getInSystemActionText(segment);
    }

    @Override
    protected void addEndingAssignment(RouteManager.RouteSegment current, boolean justSpawned) {
        super.addEndingAssignment(current, justSpawned);
        this.updateCargo(current);
    }

    @Override
    protected void addLocalAssignment(RouteManager.RouteSegment current, boolean justSpawned) {
        super.addLocalAssignment(current, justSpawned);
        this.updateCargo(current);
    }

    @Override
    protected void addStartingAssignment(RouteManager.RouteSegment current, boolean justSpawned) {
        super.addStartingAssignment(current, justSpawned);
        this.updateCargo(current);
    }

    @Override
    protected void addTravelAssignment(RouteManager.RouteSegment current, boolean justSpawned) {
        super.addTravelAssignment(current, justSpawned);
        this.updateCargo(current);
    }

    protected EconomyRouteData getData() {
        EconomyRouteData data = (EconomyRouteData)this.route.getCustom();
        return data;
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        this.doSmugglingFactionChangeCheck(amount);
    }

    public void doSmugglingFactionChangeCheck(float amount) {
        EconomyRouteData data = this.getData();
        if (!data.smuggling) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.factionChangeTracker.advance(days);
        if (this.factionChangeTracker.intervalElapsed() && this.fleet.getAI() != null) {
            MarketAPI align = null;
            if (data.from.getStarSystem() == this.fleet.getContainingLocation()) {
                align = data.from;
            } else if (data.to.getStarSystem() == this.fleet.getContainingLocation()) {
                align = data.to;
            }
            if (align != null) {
                String targetFac = this.origFaction;
                boolean hostile = align.getFaction().isHostileTo(targetFac);
                if (hostile) {
                    targetFac = "independent";
                    hostile = align.getFaction().isHostileTo(targetFac);
                }
                if (hostile) {
                    targetFac = align.getFactionId();
                }
                if (!this.fleet.getFaction().getId().equals(targetFac)) {
                    this.fleet.setFaction(targetFac, true);
                }
            } else {
                String targetFac = this.origFaction;
                if (this.fleet.isInHyperspace()) {
                    targetFac = "independent";
                }
                if (!this.fleet.getFaction().getId().equals(targetFac)) {
                    this.fleet.setFaction(targetFac, true);
                }
            }
        }
    }

    public static class CargoQuantityData {
        public String cargo;
        public int units;

        public CargoQuantityData(String cargo, int units) {
            this.cargo = cargo;
            this.units = units;
        }

        public CommoditySpecAPI getCommodity() {
            CommoditySpecAPI spec = Global.getSettings().getCommoditySpec(this.cargo);
            return spec;
        }
    }

    public static class EconomyRouteData {
        public float cargoCap;
        public float fuelCap;
        public float personnelCap;
        public float size;
        public boolean smuggling = false;
        public MarketAPI from;
        public MarketAPI to;
        public List<CargoQuantityData> cargoDeliver = new ArrayList<CargoQuantityData>();
        public List<CargoQuantityData> cargoReturn = new ArrayList<CargoQuantityData>();

        public void addDeliver(String id, int qty) {
            this.cargoDeliver.add(new CargoQuantityData(id, qty));
        }

        public void addReturn(String id, int qty) {
            this.cargoReturn.add(new CargoQuantityData(id, qty));
        }

        public static String getCargoList(List<CargoQuantityData> cargo) {
            ArrayList<String> strings = new ArrayList<String>();
            ArrayList<CargoQuantityData> sorted = new ArrayList<CargoQuantityData>(cargo);
            Collections.sort(sorted, new Comparator<CargoQuantityData>(){

                @Override
                public int compare(CargoQuantityData o1, CargoQuantityData o2) {
                    if (o1.getCommodity().isPersonnel() && !o2.getCommodity().isPersonnel()) {
                        return 1;
                    }
                    if (o2.getCommodity().isPersonnel() && !o1.getCommodity().isPersonnel()) {
                        return -1;
                    }
                    return o2.units - o1.units;
                }
            });
            for (CargoQuantityData curr : sorted) {
                CommoditySpecAPI spec = curr.getCommodity();
                if (spec.getId().equals("ships")) {
                    strings.add("ship hulls");
                    continue;
                }
                if (spec.isMeta()) continue;
                strings.add(spec.getName().toLowerCase());
            }
            if (strings.size() > 4) {
                ArrayList<String> copy = new ArrayList<String>();
                copy.add((String)strings.get(0));
                copy.add((String)strings.get(1));
                copy.add("other commodities");
                strings = copy;
            }
            return Misc.getAndJoined(strings);
        }
    }
}

