/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.util.Misc;
import java.util.Random;

public abstract class PersonalFleetScript
implements EveryFrameScript,
FleetEventListener {
    protected String personId;
    protected float minRespawnDelayDays = 1.0f;
    protected float maxRespawnDelayDays = 2.0f;
    protected float minFailedSpawnRespawnDelayDays = 1.0f;
    protected float maxFailedSpawnRespawnDelayDays = 2.0f;
    protected float currDelay;
    protected CampaignFleetAPI fleet;
    protected Random random = new Random();
    protected boolean done = false;
    protected String defeatTrigger = null;
    protected float origFP = 0.0f;

    public PersonalFleetScript(String personId) {
        this.personId = personId;
        Global.getSector().addScript(this);
    }

    public PersonAPI getPerson() {
        return People.getPerson(this.personId);
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    public String getDefeatTrigger() {
        return this.defeatTrigger;
    }

    public void setDefeatTrigger(String defeatTrigger) {
        this.defeatTrigger = defeatTrigger;
    }

    protected abstract MarketAPI getSourceMarket();

    @Override
    public void advance(float amount) {
        if (amount <= 0.0f || this.isDone()) {
            return;
        }
        if (this.fleet != null && !this.fleet.isAlive()) {
            this.fleet = null;
        }
        if (this.fleet == null) {
            float days = Global.getSector().getClock().convertToDays(amount);
            this.currDelay -= days;
            if (this.currDelay <= 0.0f) {
                this.currDelay = 0.0f;
                if (this.shouldScriptBeRemoved() || this.getPerson() == null) {
                    this.done = true;
                    return;
                }
                if (this.canSpawnFleetNow()) {
                    this.fleet = this.spawnFleet();
                    if (this.fleet != null) {
                        this.origFP = this.fleet.getFleetPoints();
                        MarketAPI source = this.getSourceMarket();
                        if (source != null) {
                            this.fleet.getMemoryWithoutUpdate().set("$sourceMarket", source.getId());
                        }
                        this.fleet.addEventListener(this);
                        if (this.defeatTrigger != null) {
                            Misc.addDefeatTrigger(this.fleet, this.defeatTrigger);
                        }
                    }
                }
                if (this.fleet == null) {
                    this.currDelay = this.minFailedSpawnRespawnDelayDays + (this.maxFailedSpawnRespawnDelayDays - this.minFailedSpawnRespawnDelayDays) * this.random.nextFloat();
                }
            }
        }
    }

    public abstract CampaignFleetAPI spawnFleet();

    public abstract boolean canSpawnFleetNow();

    public abstract boolean shouldScriptBeRemoved();

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        if (fleet == this.fleet) {
            this.fleet = null;
            this.currDelay = this.minRespawnDelayDays + (this.maxRespawnDelayDays - this.minRespawnDelayDays) * this.random.nextFloat();
        }
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
        float currFP = fleet.getFleetPoints();
        if (currFP < this.origFP * 0.33f && !Misc.isFleetReturningToDespawn(fleet)) {
            Misc.giveStandardReturnToSourceAssignments(fleet);
        }
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public float getMinRespawnDelayDays() {
        return this.minRespawnDelayDays;
    }

    public void setMinRespawnDelayDays(float minRespawnDelayDays) {
        this.minRespawnDelayDays = minRespawnDelayDays;
    }

    public float getMaxRespawnDelayDays() {
        return this.maxRespawnDelayDays;
    }

    public void setMaxRespawnDelayDays(float maxRespawnDelayDays) {
        this.maxRespawnDelayDays = maxRespawnDelayDays;
    }

    public float getMinFailedSpawnRespawnDelayDays() {
        return this.minFailedSpawnRespawnDelayDays;
    }

    public void setMinFailedSpawnRespawnDelayDays(float minFailedSpawnRespawnDelayDays) {
        this.minFailedSpawnRespawnDelayDays = minFailedSpawnRespawnDelayDays;
    }

    public float getMaxFailedSpawnRespawnDelayDays() {
        return this.maxFailedSpawnRespawnDelayDays;
    }

    public void setMaxFailedSpawnRespawnDelayDays(float maxFailedSpawnRespawnDelayDays) {
        this.maxFailedSpawnRespawnDelayDays = maxFailedSpawnRespawnDelayDays;
    }

    public float getCurrDelay() {
        return this.currDelay;
    }

    public void setCurrDelay(float currDelay) {
        this.currDelay = currDelay;
    }

    public CampaignFleetAPI getFleet() {
        return this.fleet;
    }

    public void setFleet(CampaignFleetAPI fleet) {
        this.fleet = fleet;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }
}

