/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.fleets.BaseLimitedFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactory;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import org.lwjgl.util.vector.Vector2f;

public class PirateFleetManager
extends BaseLimitedFleetManager {
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$fs$starfarer$api$impl$campaign$fleets$FleetFactory$MercType;

    @Override
    protected int getMaxFleets() {
        return (int)Global.getSettings().getFloat("maxPirateFleets");
    }

    @Override
    protected CampaignFleetAPI spawnFleet() {
        StarSystemAPI target = this.pickTargetSystem();
        return null;
    }

    protected StarSystemAPI pickTargetSystem() {
        WeightedRandomPicker<StarSystemAPI> picker = new WeightedRandomPicker<StarSystemAPI>();
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            float mult = Misc.getSpawnChanceMult(system.getLocation());
            if (system.hasTag("system_cut_off_from_hyper")) continue;
            float weight = 0.0f;
            float bounties = 0.0f;
            for (MarketAPI market : Misc.getMarketsInLocation(system)) {
                float w;
                if (market.getFactionId().equals("pirates") || !((w = 11.0f - market.getStabilityValue() + (float)market.getSize()) > weight)) continue;
                weight = w;
            }
            weight *= bounties + 1.0f;
            picker.add(system, weight *= mult);
        }
        return (StarSystemAPI)picker.pick();
    }

    public static CampaignFleetAPI createPirateFleet(int combatPoints, RouteManager.RouteData route, Vector2f locInHyper) {
        CampaignFleetAPI fleet;
        float combat = combatPoints;
        float tanker = 0.0f;
        float freighter = 0.0f;
        FleetFactory.MercType type = FleetFactory.MercType.SCOUT;
        if (combat >= 18.0f) {
            type = FleetFactory.MercType.ARMADA;
        }
        if (combat >= 12.0f) {
            type = FleetFactory.MercType.PATROL;
        }
        if (combat >= 6.0f) {
            type = (float)Math.random() < 0.5f ? FleetFactory.MercType.PRIVATEER : FleetFactory.MercType.BOUNTY_HUNTER;
        }
        String fleetType = type.fleetType;
        FleetParamsV3 params = new FleetParamsV3(route != null ? route.getMarket() : null, locInHyper, "pirates", route != null ? route.getQualityOverride() : null, fleetType, combat *= 5.0f, freighter, tanker, 0.0f, 0.0f, 0.0f, 0.0f);
        if (route != null) {
            params.timestamp = route.getTimestamp();
        }
        if ((fleet = FleetFactoryV3.createFleet(params)) == null || fleet.isEmpty()) {
            return null;
        }
        fleet.getMemoryWithoutUpdate().set("$isPirate", true);
        fleet.getMemoryWithoutUpdate().set("$cfai_longPursuit", true);
        MarketAPI source = Misc.getSourceMarket(fleet);
        if (source == null) {
            return null;
        }
        return fleet;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$fs$starfarer$api$impl$campaign$fleets$FleetFactory$MercType() {
        if ($SWITCH_TABLE$com$fs$starfarer$api$impl$campaign$fleets$FleetFactory$MercType != null) {
            return $SWITCH_TABLE$com$fs$starfarer$api$impl$campaign$fleets$FleetFactory$MercType;
        }
        int[] nArray = new int[FleetFactory.MercType.values().length];
        try {
            nArray[FleetFactory.MercType.ARMADA.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FleetFactory.MercType.BOUNTY_HUNTER.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FleetFactory.MercType.PATROL.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FleetFactory.MercType.PRIVATEER.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FleetFactory.MercType.SCOUT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$fs$starfarer$api$impl$campaign$fleets$FleetFactory$MercType = nArray;
        return nArray;
    }
}

