/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.events.OfficerManagerEvent;
import com.fs.starfarer.api.impl.campaign.fleets.SDFBase;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionFleetAutoDespawn;
import org.lwjgl.util.vector.Vector2f;

public class SDFTriTachyon
extends SDFBase {
    @Override
    protected String getFactionId() {
        return "tritachyon";
    }

    @Override
    protected OfficerManagerEvent.SkillPickPreference getCommanderShipSkillPreference() {
        return OfficerManagerEvent.SkillPickPreference.YES_ENERGY_NO_BALLISTIC_NO_MISSILE_YES_DEFENSE;
    }

    @Override
    protected MarketAPI getSourceMarket() {
        return Global.getSector().getEconomy().getMarket("culann");
    }

    @Override
    protected String getDefeatTriggerToUse() {
        return "SDFTriTachyonDefeated";
    }

    @Override
    public CampaignFleetAPI spawnFleet() {
        MarketAPI culann = this.getSourceMarket();
        FleetCreatorMission m = new FleetCreatorMission(this.random);
        m.beginFleet();
        Vector2f loc = culann.getLocationInHyperspace();
        m.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MAXIMUM, HubMissionWithTriggers.FleetQuality.SMOD_3, this.getFactionId(), "patrolLarge", loc);
        m.triggerSetFleetSizeFraction(1.15f);
        m.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.DEFAULT, HubMissionWithTriggers.OfficerQuality.DEFAULT);
        m.triggerSetFleetDoctrineComp(5, 0, 3);
        m.triggerSetFleetCommander(this.getPerson());
        m.triggerFleetAddCommanderSkill("fighter_uplink", 1);
        m.triggerFleetAddCommanderSkill("flux_regulation", 1);
        m.triggerFleetAddCommanderSkill("phase_corps", 1);
        m.triggerFleetAddCommanderSkill("electronic_warfare", 1);
        m.triggerFleetAddCommanderSkill("cybernetic_augmentation", 1);
        m.triggerSetPatrol();
        m.triggerSetFleetMemoryValue("$sourceMarket", culann);
        m.triggerFleetSetName("Capital Assurance Reserve");
        m.triggerPatrolAllowTransponderOff();
        m.triggerOrderFleetPatrol(culann.getStarSystem());
        CampaignFleetAPI fleet = m.createFleet();
        fleet.removeScriptsOfClass(MissionFleetAutoDespawn.class);
        culann.getContainingLocation().addEntity(fleet);
        fleet.setLocation(culann.getPlanetEntity().getLocation().x, culann.getPlanetEntity().getLocation().y);
        fleet.setFacing(this.random.nextFloat() * 360.0f);
        return fleet;
    }
}

