/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.List;

public abstract class SeededFleetManager
implements FleetEventListener,
EveryFrameScript {
    public static float DESPAWN_PAD_LY = 1.0f;
    protected List<SeededFleet> fleets = new ArrayList<SeededFleet>();
    protected float inflateRangeLY = 5.0f;
    protected StarSystemAPI system;
    public static boolean DEBUG = false;

    public SeededFleetManager(StarSystemAPI system, float inflateRangeLY) {
        this.system = system;
        this.inflateRangeLY = inflateRangeLY;
    }

    public void addSeed(long seed) {
        SeededFleet f = new SeededFleet();
        f.seed = seed;
        this.fleets.add(f);
    }

    public float getInflateRangeLY() {
        return this.inflateRangeLY;
    }

    public StarSystemAPI getSystem() {
        return this.system;
    }

    protected abstract CampaignFleetAPI spawnFleet(long var1);

    @Override
    public void advance(float amount) {
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        float distFromSystem = Misc.getDistanceLY(player.getLocationInHyperspace(), this.system.getLocation());
        if (distFromSystem < this.inflateRangeLY) {
            float index = 0.0f;
            for (SeededFleet curr : this.fleets) {
                float threshold = this.inflateRangeLY * (0.9f + 0.1f / (float)this.fleets.size() * (index + 1.0f));
                if (distFromSystem < threshold && curr.fleet == null) {
                    curr.fleet = this.spawnFleet(curr.seed);
                    if (curr.fleet != null) {
                        if (DEBUG) {
                            System.out.println("Created " + curr.fleet.getName() + " (seed: " + curr.seed + ")");
                        }
                        curr.fleet.addEventListener(this);
                        curr.points = curr.fleet.getFleetPoints();
                    }
                }
                index += 1.0f;
            }
        }
        for (SeededFleet curr : this.fleets) {
            float dist;
            if (curr.fleet == null || !((dist = Misc.getDistanceLY(player.getLocationInHyperspace(), curr.fleet.getLocationInHyperspace())) > this.inflateRangeLY + DESPAWN_PAD_LY) || curr.points != curr.fleet.getFleetPoints()) continue;
            if (DEBUG) {
                System.out.println("Despawned " + curr.fleet.getName() + " (seed: " + curr.seed + ")");
            }
            curr.fleet.despawn(CampaignEventListener.FleetDespawnReason.PLAYER_FAR_AWAY, null);
            curr.fleet = null;
            curr.points = 0;
        }
    }

    @Override
    public boolean isDone() {
        return this.fleets.isEmpty();
    }

    @Override
    public boolean runWhilePaused() {
        return Global.getSettings().isDevMode();
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        if (reason == CampaignEventListener.FleetDespawnReason.PLAYER_FAR_AWAY) {
            return;
        }
        for (SeededFleet curr : this.fleets) {
            if (curr.fleet == null || curr.fleet != fleet) continue;
            this.fleets.remove(curr);
            if (!DEBUG) break;
            System.out.println("Removed " + curr.fleet.getName() + " (seed: " + curr.seed + "), remaiing: " + this.fleets.size());
            break;
        }
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
    }

    public static class SeededFleet {
        public long seed;
        public int points;
        public CampaignFleetAPI fleet;
    }
}

