/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public abstract class SourceBasedFleetManager
implements FleetEventListener,
EveryFrameScript {
    public static float DESPAWN_THRESHOLD_PAD_LY = 1.0f;
    public static float DESPAWN_MIN_DIST_LY = 3.0f;
    protected List<CampaignFleetAPI> fleets = new ArrayList<CampaignFleetAPI>();
    protected float thresholdLY = 4.0f;
    protected SectorEntityToken source;
    public static boolean DEBUG = true;
    protected int minFleets;
    protected int maxFleets;
    protected float respawnDelay;
    protected float destroyed = 0.0f;
    protected Vector2f sourceLocation = new Vector2f();
    private boolean done = false;

    public SourceBasedFleetManager(SectorEntityToken source, float thresholdLY, int minFleets, int maxFleets, float respawnDelay) {
        this.source = source;
        this.thresholdLY = thresholdLY;
        this.minFleets = minFleets;
        this.maxFleets = maxFleets;
        this.respawnDelay = respawnDelay;
    }

    public float getThresholdLY() {
        return this.thresholdLY;
    }

    public SectorEntityToken getSource() {
        return this.source;
    }

    protected abstract CampaignFleetAPI spawnFleet();

    @Override
    public void advance(float amount) {
        CampaignFleetAPI fleet2;
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        float days = Global.getSector().getClock().convertToDays(amount);
        this.destroyed -= days / this.respawnDelay;
        if (this.destroyed < 0.0f) {
            this.destroyed = 0.0f;
        }
        Iterator<CampaignFleetAPI> iter = this.fleets.iterator();
        while (iter.hasNext()) {
            if (iter.next().isAlive()) continue;
            iter.remove();
        }
        if (this.source != null) {
            if (!this.source.isAlive()) {
                this.source = null;
            } else {
                this.sourceLocation.set((ReadableVector2f)this.source.getLocationInHyperspace());
            }
        }
        float distFromSource = Misc.getDistanceLY(player.getLocationInHyperspace(), this.sourceLocation);
        float f = 0.0f;
        if (distFromSource < this.thresholdLY && (f = (this.thresholdLY - distFromSource) / (this.thresholdLY * 0.1f)) > 1.0f) {
            f = 1.0f;
        }
        int currMax = this.minFleets + Math.round((float)(this.maxFleets - this.minFleets) * f);
        currMax = (int)((double)currMax - Math.ceil(this.destroyed));
        if (this.source == null) {
            currMax = 0;
        }
        if (currMax < this.fleets.size()) {
            for (CampaignFleetAPI fleet2 : new ArrayList<CampaignFleetAPI>(this.fleets)) {
                float distFromPlayer = Misc.getDistanceLY(player.getLocationInHyperspace(), fleet2.getLocationInHyperspace());
                if (!(distFromPlayer > DESPAWN_MIN_DIST_LY) || !(distFromPlayer > this.thresholdLY + DESPAWN_THRESHOLD_PAD_LY)) continue;
                fleet2.despawn(CampaignEventListener.FleetDespawnReason.PLAYER_FAR_AWAY, null);
                if (this.fleets.size() <= currMax) break;
            }
        }
        if (currMax > this.fleets.size() && (fleet2 = this.spawnFleet()) != null) {
            this.fleets.add(fleet2);
            fleet2.addEventListener(this);
        }
        if (this.source == null && this.fleets.size() == 0) {
            this.setDone(true);
        }
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        if (reason == CampaignEventListener.FleetDespawnReason.DESTROYED_BY_BATTLE) {
            this.destroyed += 1.0f;
        }
        this.fleets.remove(fleet);
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
    }
}

