/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.fleets.misc.MiscFleetCreatorPlugin;
import com.fs.starfarer.api.impl.campaign.fleets.misc.MiscFleetRouteManager;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RouteFleetAssignmentAI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.List;

public class MiscFleetAssignmentAI
extends RouteFleetAssignmentAI {
    private String origFaction;
    private IntervalUtil factionChangeTracker = new IntervalUtil(0.1f, 0.3f);

    public MiscFleetAssignmentAI(CampaignFleetAPI fleet, RouteManager.RouteData route) {
        super(fleet, route);
        this.origFaction = route.getFactionId();
        if (!this.getData().smuggling) {
            this.origFaction = null;
            this.factionChangeTracker = null;
        } else {
            this.factionChangeTracker.forceIntervalElapsed();
            this.doSmugglingFactionChangeCheck(0.1f);
        }
    }

    @Override
    protected String getStartingActionText(RouteManager.RouteSegment segment) {
        MiscFleetRouteManager.MiscRouteData data = this.getData();
        MiscFleetCreatorPlugin creator = MiscFleetRouteManager.getCreator(data.creatorId);
        if (creator != null) {
            return creator.getStartingActionText(this.fleet, segment, data);
        }
        return super.getStartingActionText(segment);
    }

    @Override
    protected String getEndingActionText(RouteManager.RouteSegment segment) {
        MiscFleetRouteManager.MiscRouteData data = this.getData();
        MiscFleetCreatorPlugin creator = MiscFleetRouteManager.getCreator(data.creatorId);
        if (creator != null) {
            return creator.getEndingActionText(this.fleet, segment, data);
        }
        return super.getEndingActionText(segment);
    }

    @Override
    protected String getTravelActionText(RouteManager.RouteSegment segment) {
        Integer id = segment.getId();
        MiscFleetRouteManager.MiscRouteData data = this.getData();
        MiscFleetCreatorPlugin creator = MiscFleetRouteManager.getCreator(data.creatorId);
        if (creator != null) {
            if (id == MiscFleetRouteManager.ROUTE_TRAVEL_DST) {
                return creator.getTravelToDestActionText(this.fleet, segment, data);
            }
            if (id == MiscFleetRouteManager.ROUTE_TRAVEL_SRC) {
                return creator.getTravelReturnActionText(this.fleet, segment, data);
            }
        }
        return super.getTravelActionText(segment);
    }

    @Override
    protected String getInSystemActionText(RouteManager.RouteSegment segment) {
        Integer id = segment.getId();
        MiscFleetRouteManager.MiscRouteData data = this.getData();
        MiscFleetCreatorPlugin creator = MiscFleetRouteManager.getCreator(data.creatorId);
        if (creator != null) {
            if (id == MiscFleetRouteManager.ROUTE_DST_UNLOAD) {
                return creator.getAtDestUnloadActionText(this.fleet, segment, data);
            }
            if (id == MiscFleetRouteManager.ROUTE_DST_LOAD) {
                return creator.getAtDestLoadActionText(this.fleet, segment, data);
            }
        }
        return super.getInSystemActionText(segment);
    }

    protected MiscFleetRouteManager.MiscRouteData getData() {
        MiscFleetRouteManager.MiscRouteData data = (MiscFleetRouteManager.MiscRouteData)this.route.getCustom();
        return data;
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        this.doSmugglingFactionChangeCheck(amount);
    }

    public void doSmugglingFactionChangeCheck(float amount) {
        MiscFleetRouteManager.MiscRouteData data = this.getData();
        if (!data.smuggling) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.factionChangeTracker.advance(days);
        if (this.factionChangeTracker.intervalElapsed() && this.fleet.getAI() != null) {
            List<MarketAPI> markets = Misc.getMarketsInLocation(this.fleet.getContainingLocation());
            MarketAPI align = null;
            int max = 0;
            for (MarketAPI market : markets) {
                int size = market.getSize();
                if (market.getFaction().isHostileTo(data.factionId)) {
                    if (size <= max) continue;
                    max = size;
                    align = market;
                    continue;
                }
                if (size <= max) continue;
                max = size;
                align = null;
            }
            if (align == null || this.fleet.isInHyperspace() || this.fleet.getContainingLocation() == data.from.getContainingLocation()) {
                align = data.from;
            }
            if (align != null) {
                targetFac = this.origFaction;
                boolean hostile = align.getFaction().isHostileTo(targetFac);
                if (hostile) {
                    targetFac = "independent";
                    hostile = align.getFaction().isHostileTo(targetFac);
                }
                if (hostile) {
                    targetFac = align.getFactionId();
                }
                if (!this.fleet.getFaction().getId().equals(targetFac)) {
                    this.fleet.setFaction(targetFac, true);
                }
            } else {
                targetFac = this.origFaction;
                if (this.fleet.isInHyperspace()) {
                    targetFac = "independent";
                }
                if (!this.fleet.getFaction().getId().equals(targetFac)) {
                    this.fleet.setFaction(targetFac, true);
                }
            }
        }
    }
}

