/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostManager;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamTerrainPlugin2;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class BaseSensorGhostCreator
implements SensorGhostCreator {
    @Override
    public List<SensorGhost> createGhost(SensorGhostManager manager) {
        return null;
    }

    @Override
    public float getFrequency(SensorGhostManager manager) {
        return 10.0f;
    }

    @Override
    public String getId() {
        return this.getClass().getSimpleName();
    }

    @Override
    public float getTimeoutDaysOnSuccessfulCreate(SensorGhostManager manager) {
        return 10.0f + manager.getRandom().nextFloat() * 10.0f;
    }

    public static Vector2f findClearHyperspaceArea(Vector2f from, float minRange, float maxRange, float radius, Random random) {
        return BaseSensorGhostCreator.findHyperspaceArea(from, minRange, maxRange, radius, random, true, 0.0f);
    }

    public static Vector2f findDeepHyperspaceArea(Vector2f from, float minRange, float maxRange, float radius, Random random) {
        return BaseSensorGhostCreator.findHyperspaceArea(from, minRange, maxRange, radius, random, false, 0.0f);
    }

    public static Vector2f findHyperspaceArea(Vector2f from, float minRange, float maxRange, float radius, Random random, boolean clear, float noSlipstreamRange) {
        CampaignTerrainAPI terrain;
        if (random == null) {
            random = Misc.random;
        }
        if ((terrain = Misc.getHyperspaceTerrain()) == null) {
            return null;
        }
        HyperspaceTerrainPlugin plugin = (HyperspaceTerrainPlugin)terrain.getPlugin();
        int[][] tiles = plugin.getTiles();
        float perTile = plugin.getTileSize();
        int areaSize = (int)Math.ceil(radius / perTile);
        Vector2f best = null;
        float bestScore = 0.0f;
        float total = (areaSize + areaSize + 1) * (areaSize + areaSize + 1);
        if (total < 1.0f) {
            total = 1.0f;
        }
        int k = 0;
        while (k < 20) {
            Vector2f test = Misc.getPointWithinRadiusUniform(from, minRange, maxRange, random);
            int[] coords = plugin.getTile(test);
            if (!(coords == null || noSlipstreamRange > 0.0f && Misc.isInsideSlipstream(test, noSlipstreamRange))) {
                float count = 0.0f;
                int i = coords[0] - areaSize;
                while (i <= coords[0] + areaSize) {
                    if (i >= 0 && i < tiles.length) {
                        int j = coords[1] - areaSize;
                        while (j < coords[1] + areaSize) {
                            if (j >= 0 && j < tiles[0].length) {
                                int texIndex = tiles[i][j];
                                if (clear) {
                                    if (texIndex <= 0) {
                                        count += 1.0f;
                                    }
                                } else if (texIndex > 0) {
                                    count += 1.0f;
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                float score = count / total;
                if (score >= 0.75f && score > bestScore) {
                    best = test;
                    bestScore = score;
                }
            }
            ++k;
        }
        return best;
    }

    public static SlipstreamTerrainPlugin2 pickNearbySlipstream(float radius, Random random) {
        return BaseSensorGhostCreator.pickNearbySlipstream(radius, Global.getSector().getHyperspace(), random);
    }

    public static SlipstreamTerrainPlugin2 pickNearbySlipstream(float radius, LocationAPI location, Random random) {
        WeightedRandomPicker<SlipstreamTerrainPlugin2> picker = new WeightedRandomPicker<SlipstreamTerrainPlugin2>(random);
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        Vector2f loc = pf.getLocation();
        for (CampaignTerrainAPI ter : location.getTerrainCopy()) {
            SlipstreamTerrainPlugin2 plugin;
            if (!(ter.getPlugin() instanceof SlipstreamTerrainPlugin2) || !(plugin = (SlipstreamTerrainPlugin2)ter.getPlugin()).containsPoint(loc, radius)) continue;
            float w = 1.0f;
            if (plugin.isPreventedFromAffecting(pf)) {
                w *= 0.25f;
            }
            picker.add(plugin, w);
        }
        return (SlipstreamTerrainPlugin2)picker.pick();
    }

    @Override
    public boolean canSpawnWhilePlayerInOrNearSlipstream() {
        return false;
    }

    @Override
    public boolean canSpawnWhilePlayerInAbyss() {
        return false;
    }

    @Override
    public boolean canSpawnWhilePlayerOutsideAbyss() {
        return true;
    }
}

