/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts;

import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseGhostBehavior;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhost;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class GBDartAround
extends BaseGhostBehavior {
    protected SectorEntityToken other;
    protected int maxBurn;
    protected float desiredRange;
    protected float desiredRangeMin;
    protected float desiredRangeMax;
    protected IntervalUtil interval = new IntervalUtil(5.0f, 10.0f);
    protected float angleOffset = 0.0f;
    protected Vector2f dest = new Vector2f();

    public GBDartAround(SectorEntityToken other, float duration, int maxBurn, float desiredRangeMin, float desiredRangeMax) {
        super(duration);
        this.other = other;
        this.maxBurn = maxBurn;
        this.desiredRangeMin = desiredRangeMin;
        this.desiredRangeMax = desiredRangeMax;
        this.interval.forceIntervalElapsed();
    }

    @Override
    public void advance(float amount, SensorGhost ghost) {
        if (this.other.getContainingLocation() != ghost.getEntity().getContainingLocation() || !this.other.isAlive()) {
            this.end();
            return;
        }
        super.advance(amount, ghost);
        float mult = 1.0f;
        mult = (float)this.maxBurn >= 25.0f ? 3.0f : ((float)this.maxBurn >= 15.0f ? 2.0f : 1.5f);
        this.interval.advance(amount * mult);
        if (this.interval.intervalElapsed()) {
            this.angleOffset = (float)Math.random() * 360.0f;
            this.desiredRange = this.desiredRangeMin + (this.desiredRangeMax - this.desiredRangeMin) * (float)Math.random();
            this.dest = Misc.getUnitVectorAtDegreeAngle(this.angleOffset + Misc.getAngleInDegrees(this.other.getLocation(), ghost.getEntity().getLocation()));
            this.dest.scale(this.desiredRange + this.other.getRadius() + ghost.getEntity().getRadius());
            Vector2f.add((Vector2f)this.dest, (Vector2f)this.other.getLocation(), (Vector2f)this.dest);
        }
        if (Misc.getDistance(this.dest, ghost.getEntity().getLocation()) < 10.0f) {
            this.interval.forceIntervalElapsed();
        }
        ghost.moveTo(this.dest, new Vector2f(), this.maxBurn);
    }
}

