/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseGhostBehavior;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhost;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class GBEchoMovement
extends BaseGhostBehavior {
    protected List<GBEchoSnapshot> snapshots = new ArrayList<GBEchoSnapshot>();
    protected SectorEntityToken other;
    protected float delayDays;

    public GBEchoMovement(SectorEntityToken other, float delayDays, float duration) {
        super(duration);
        this.other = other;
        this.delayDays = delayDays;
    }

    @Override
    public void advance(float amount, SensorGhost ghost) {
        if (this.other.getContainingLocation() != ghost.getEntity().getContainingLocation() || !this.other.isAlive()) {
            this.end();
            return;
        }
        super.advance(amount, ghost);
        GBEchoSnapshot curr = new GBEchoSnapshot();
        curr.vel = new Vector2f((ReadableVector2f)this.other.getVelocity());
        curr.timestamp = Global.getSector().getClock().getTimestamp();
        this.snapshots.add(curr);
        Iterator<GBEchoSnapshot> iter = this.snapshots.iterator();
        GBEchoSnapshot use = null;
        while (iter.hasNext()) {
            curr = iter.next();
            float ago = Global.getSector().getClock().getElapsedDaysSince(curr.timestamp);
            if (!(ago >= this.delayDays)) break;
            use = curr;
            iter.remove();
        }
        if (use != null) {
            ghost.getMovement().getVelocity().set((ReadableVector2f)use.vel);
        }
    }

    public static class GBEchoSnapshot {
        Vector2f vel;
        long timestamp;
    }
}

