/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts;

import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseGhostBehavior;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhost;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class GBIntercept
extends BaseGhostBehavior {
    protected SectorEntityToken other;
    protected int maxBurn;
    protected boolean endOnIntercept;
    protected float desiredRange;

    public GBIntercept(SectorEntityToken other, float duration, int maxBurn, boolean endOnIntercept) {
        this(other, duration, maxBurn, 0.0f, endOnIntercept);
    }

    public GBIntercept(SectorEntityToken other, float duration, int maxBurn, float desiredRange, boolean endOnIntercept) {
        super(duration);
        this.other = other;
        this.maxBurn = maxBurn;
        this.endOnIntercept = endOnIntercept;
        this.desiredRange = desiredRange;
    }

    @Override
    public void advance(float amount, SensorGhost ghost) {
        float dist;
        if (this.other.getContainingLocation() != ghost.getEntity().getContainingLocation() || !this.other.isAlive()) {
            this.end();
            return;
        }
        super.advance(amount, ghost);
        float speed = Misc.getSpeedForBurnLevel(this.maxBurn);
        Vector2f loc = Misc.getInterceptPoint(ghost.getEntity(), this.other, speed);
        if (loc != null) {
            ghost.moveTo(loc, this.maxBurn);
        }
        if (this.endOnIntercept && (dist = Misc.getDistance(ghost.getEntity(), this.other)) < ghost.getEntity().getRadius() + this.other.getRadius() + this.desiredRange) {
            this.end();
            return;
        }
    }
}

