/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseGhostBehavior;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseSensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.GBIGenerateSlipstream;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhost;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamTerrainPlugin2;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class GBLeviathanCalfRun
extends BaseGhostBehavior
implements GBIGenerateSlipstream.GhostBehaviorWithSlipstream {
    public static float SENSOR_BURST_TURN_RATE = 30.0f;
    public static float PULSE_BURN_BONUS = 10.0f;
    public static float PULSE_BURN_BONUS_DECAY = 0.25f;
    protected boolean dirSet = false;
    protected float dir;
    protected float burnBonus;
    protected int origPluginBurn;
    protected SectorEntityToken from;
    protected float phase = (float)Math.random();
    protected int maxBurn;
    protected SlipstreamTerrainPlugin2 plugin;
    protected boolean affectedByPulse = false;
    protected float wobbleRate;
    protected float maxWobble;

    public GBLeviathanCalfRun(float duration, SectorEntityToken from, float wobbleRate, float maxWobble, int maxBurn, boolean affectedByPulse) {
        super(duration);
        this.from = from;
        this.wobbleRate = wobbleRate;
        this.maxWobble = maxWobble;
        this.maxBurn = maxBurn;
        this.affectedByPulse = affectedByPulse;
    }

    @Override
    public void advance(float amount, SensorGhost ghost) {
        if (this.from.getContainingLocation() != ghost.getEntity().getContainingLocation() || ghost.getEntity().getContainingLocation() == null || !this.from.isAlive()) {
            this.end();
            return;
        }
        super.advance(amount, ghost);
        if (!this.dirSet || ghost.getEntity().getVelocity().length() < 10.0f) {
            this.dir = Misc.getAngleInDegrees(this.from.getLocation(), ghost.getEntity().getLocation());
            this.dirSet = true;
        }
        float pi = (float)Math.PI;
        float sin = (float)Math.sin(this.phase * pi * 2.0f);
        this.phase += amount * this.wobbleRate;
        float maxAngleOffset = this.maxWobble;
        float angle = this.dir + sin * maxAngleOffset;
        if (this.affectedByPulse) {
            this.checkInterdictionPulses(ghost);
        }
        int useBonus = 0;
        if (this.plugin != null) {
            this.burnBonus -= PULSE_BURN_BONUS_DECAY * amount;
            if (this.burnBonus < 0.0f) {
                this.burnBonus = 0.0f;
            }
            useBonus = (int)this.burnBonus;
            this.plugin.getParams().burnLevel = this.origPluginBurn + useBonus;
        }
        Vector2f loc = Misc.getUnitVectorAtDegreeAngle(angle);
        loc.scale(10000.0f);
        Vector2f.add((Vector2f)loc, (Vector2f)ghost.getEntity().getLocation(), (Vector2f)loc);
        ghost.moveTo(loc, this.maxBurn + useBonus);
    }

    public void checkInterdictionPulses(SensorGhost ghost) {
        if (!Global.getSector().getMemoryWithoutUpdate().getBoolean("$interdictionPulseJustUsed")) {
            return;
        }
        CustomCampaignEntityAPI entity = ghost.getEntity();
        if (entity == null || entity.getContainingLocation() == null || this.plugin == null) {
            return;
        }
        for (CampaignFleetAPI fleet : entity.getContainingLocation().getFleets()) {
            if (!this.plugin.containsEntity(fleet) || !fleet.getMemoryWithoutUpdate().getBoolean("$justDidInterdictionPulse")) continue;
            this.burnBonus = PULSE_BURN_BONUS;
            if (fleet.isPlayerFleet()) {
                String key = "$leviathanCalvesPulsed";
                int count = Global.getSector().getMemoryWithoutUpdate().getInt(key);
                Global.getSector().getMemoryWithoutUpdate().set(key, count + 1);
            }
            return;
        }
    }

    public void checkSensorBursts(SensorGhost ghost, float amount) {
        CustomCampaignEntityAPI entity = ghost.getEntity();
        if (entity == null || entity.getContainingLocation() == null || this.plugin == null) {
            return;
        }
        for (CampaignFleetAPI fleet : entity.getContainingLocation().getFleets()) {
            float[] coords;
            AbilityPlugin asb;
            if (!this.plugin.containsEntity(fleet) || !(asb = fleet.getAbility("sensor_burst")).isInProgress() || (coords = this.plugin.getLengthAndWidthFractionWithinStream(fleet.getLocation())) == null) continue;
            this.dir += coords[1] * SENSOR_BURST_TURN_RATE * amount;
            ((BaseSensorGhost)ghost).setAccelMult(1.0f);
        }
    }

    @Override
    public void setSlipstream(SlipstreamTerrainPlugin2 plugin) {
        this.plugin = plugin;
        this.origPluginBurn = plugin.getParams().burnLevel;
    }
}

