/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostManager;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class SpeedReduction
implements EveryFrameScript {
    protected float elapsed;
    protected SectorEntityToken target;
    protected float speedReductionRate;
    protected float durationSeconds;

    public SpeedReduction(SectorEntityToken target, float speedReductionFraction) {
        this(target, speedReductionFraction, 0.2f);
    }

    public SpeedReduction(SectorEntityToken target, float speedReductionFraction, float durationSeconds) {
        this.target = target;
        this.durationSeconds = durationSeconds;
        this.speedReductionRate = target.getVelocity().length() * speedReductionFraction / durationSeconds;
    }

    @Override
    public void advance(float amount) {
        if (this.target instanceof CampaignFleetAPI) {
            this.target.setOrbit(null);
        }
        Vector2f v = this.target.getVelocity();
        Vector2f dV = Misc.getUnitVector(new Vector2f(), v);
        dV.scale(-1.0f * Math.min(v.length(), this.speedReductionRate * Math.min(this.durationSeconds, amount)));
        SensorGhost ghost = SensorGhostManager.getGhostFor(this.target);
        if (ghost != null) {
            v = ghost.getMovement().getVelocity();
            ghost.getMovement().getVelocity().set(v.x + dV.x, v.y + dV.y);
        } else if (this.target instanceof CampaignFleetAPI) {
            v = ((CampaignFleetAPI)this.target).getVelocityFromMovementModule();
            ((CampaignFleetAPI)this.target).setVelocity(v.x + dV.x, v.y + dV.y);
        } else {
            this.target.getVelocity().set(v.x + dV.x, v.y + dV.y);
        }
        this.elapsed += amount;
    }

    @Override
    public boolean isDone() {
        return this.elapsed >= this.durationSeconds;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }
}

