/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts.types;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseSensorGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.GhostFrequencies;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostManager;
import com.fs.starfarer.api.impl.campaign.ghosts.SharedTrigger;
import com.fs.starfarer.api.impl.campaign.ghosts.types.MinnowGhost;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class MinnowGhostCreator
extends BaseSensorGhostCreator {
    @Override
    public List<SensorGhost> createGhost(SensorGhostManager manager) {
        if (!Global.getSector().getCurrentLocation().isHyperspace()) {
            return null;
        }
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        Vector2f loc = MinnowGhostCreator.findHyperspaceArea(pf.getLocation(), 1500.0f, 2000.0f, 1000.0f, manager.getRandom(), true, 250.0f);
        if (loc == null) {
            return null;
        }
        SectorEntityToken target = Global.getSector().getHyperspace().createToken(loc);
        int numMinnows = 5 + manager.getRandom().nextInt(11);
        float minRange = 100.0f;
        float maxRange = 500.0f;
        float dur = 5.0f + manager.getRandom().nextFloat() * 5.0f;
        SharedTrigger trigger = new SharedTrigger();
        ArrayList<SensorGhost> result = new ArrayList<SensorGhost>();
        int i = 0;
        while (i < numMinnows) {
            MinnowGhost m = new MinnowGhost(manager, target, minRange, maxRange, dur + manager.getRandom().nextFloat(), trigger);
            result.add(m);
            ++i;
        }
        return result;
    }

    @Override
    public float getFrequency(SensorGhostManager manager) {
        return GhostFrequencies.getMinnowFrequency(manager);
    }

    @Override
    public boolean canSpawnWhilePlayerInOrNearSlipstream() {
        return true;
    }
}

