/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts.types;

import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.impl.campaign.fleets.AutoDespawnScript;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseSensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.GBCircle;
import com.fs.starfarer.api.impl.campaign.ghosts.GBIRunScript;
import com.fs.starfarer.api.impl.campaign.ghosts.GBIntercept;
import com.fs.starfarer.api.impl.campaign.ghosts.GBStayInPlace;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostManager;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.util.Misc;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class RemnantGhost
extends BaseSensorGhost
implements Script {
    protected Random random;

    public RemnantGhost(SensorGhostManager manager, CampaignFleetAPI fleet) {
        super(manager, 0);
        this.random = Misc.getRandom(manager.getRandom().nextLong(), 5);
        int maxBurn = 9 + this.random.nextInt(3);
        this.initEntity(this.genLargeSensorProfile(), this.genLargeRadius());
        if (!this.placeNearPlayer()) {
            this.setCreationFailed();
            return;
        }
        this.setDespawnRange(-1000.0f);
        float speed = Misc.getSpeedForBurnLevel(maxBurn);
        float accelMult = speed / Misc.getSpeedForBurnLevel(20.0f);
        if (accelMult < 0.1f) {
            accelMult = 0.1f;
        }
        this.setAccelMult(1.0f / accelMult);
        this.addBehavior(new GBIntercept(fleet, 5.0f + this.random.nextFloat() * 2.0f, maxBurn, 450.0f, true));
        this.addBehavior(new GBCircle(fleet, 0.7f + this.random.nextFloat() * 0.5f, maxBurn / 2, 300.0f, this.random.nextBoolean() ? 1.0f : -1.0f));
        this.addBehavior(new GBStayInPlace(0.1f));
        this.addInterrupt(new GBIRunScript(0.0f, this, true));
    }

    @Override
    public void run() {
        FleetCreatorMission m = new FleetCreatorMission(this.random);
        m.beginFleet();
        Vector2f loc = this.entity.getLocationInHyperspace();
        HubMissionWithTriggers.FleetSize size = HubMissionWithTriggers.FleetSize.MEDIUM;
        HubMissionWithTriggers.FleetQuality quality = HubMissionWithTriggers.FleetQuality.VERY_LOW;
        HubMissionWithTriggers.OfficerQuality oQuality = HubMissionWithTriggers.OfficerQuality.AI_MIXED;
        HubMissionWithTriggers.OfficerNum oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
        String type = "patrolMedium";
        float r = this.random.nextFloat();
        if (r < 0.25f) {
            size = HubMissionWithTriggers.FleetSize.LARGE;
        } else if (r < 0.5f) {
            size = HubMissionWithTriggers.FleetSize.LARGER;
        }
        m.triggerCreateFleet(size, quality, "remnant", type, loc);
        m.getPreviousCreateFleetAction().fQualityMod = Float.valueOf(-10.0f);
        m.triggerSetFleetOfficers(oNum, oQuality);
        m.triggerSetRemnantConfigDormant();
        CampaignFleetAPI fleet = m.createFleet();
        if (fleet != null) {
            this.setVel(new Vector2f(0.0f, 0.0f));
            this.entity.getContainingLocation().addEntity(fleet);
            fleet.setLocation(this.entity.getLocation().x, this.entity.getLocation().y);
            fleet.addScript(new AutoDespawnScript(fleet));
            fleet.getMemoryWithoutUpdate().set("$fromGhost", true);
        }
    }
}

