/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts.types;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseSensorGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.GhostFrequencies;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostManager;
import com.fs.starfarer.api.impl.campaign.ghosts.types.RemoraGhost;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class RemoraGhostCreator
extends BaseSensorGhostCreator {
    @Override
    public List<SensorGhost> createGhost(SensorGhostManager manager) {
        if (!Global.getSector().getCurrentLocation().isHyperspace()) {
            return null;
        }
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        float f = GhostFrequencies.getFringeFactor();
        int numRemora = 1 + manager.getRandom().nextInt(Math.round(f * 4.0f) + 1);
        ArrayList<SensorGhost> result = new ArrayList<SensorGhost>();
        float dur = 7.0f + manager.getRandom().nextFloat() * 5.0f;
        Vector2f first = null;
        int i = 0;
        while (i < numRemora) {
            RemoraGhost remora;
            Vector2f loc = null;
            if (first != null) {
                loc = Misc.getPointWithinRadiusUniform(first, 300.0f, manager.getRandom());
            }
            if (!(remora = new RemoraGhost(manager, pf, dur + manager.getRandom().nextFloat() * 0.5f, loc)).isCreationFailed()) {
                result.add(remora);
                first = remora.getEntity().getLocation();
            }
            ++i;
        }
        return result;
    }

    @Override
    public float getFrequency(SensorGhostManager manager) {
        return GhostFrequencies.getRemoraFrequency(manager);
    }

    @Override
    public boolean canSpawnWhilePlayerInOrNearSlipstream() {
        return true;
    }
}

