/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts.types;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseSensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseSensorGhostCreator;
import com.fs.starfarer.api.impl.campaign.ghosts.GBGoTo;
import com.fs.starfarer.api.impl.campaign.ghosts.GBStayInPlace;
import com.fs.starfarer.api.impl.campaign.ghosts.GBStormArea;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostManager;
import org.lwjgl.util.vector.Vector2f;

public class StormcallerGhost
extends BaseSensorGhost {
    public StormcallerGhost(SensorGhostManager manager) {
        super(manager, 40);
        float size = this.genFloat(600.0f, 700.0f);
        this.initEntity(this.genHugeSensorProfile(), size);
        this.setDespawnRange(-500.0f);
        this.entity.addTag("unaffected_by_slipstream");
        if (!this.placeNearPlayer()) {
            this.setCreationFailed();
            return;
        }
        int numStops = 2 + manager.getRandom().nextInt(4);
        int maxBurn = 10;
        Vector2f curr = this.entity.getLocation();
        int i = 0;
        while (i < numStops) {
            Vector2f loc;
            curr = loc = BaseSensorGhostCreator.findDeepHyperspaceArea(curr, 1000.0f, 3000.0f, 1000.0f, manager.getRandom());
            if (loc == null) {
                this.setCreationFailed();
                return;
            }
            SectorEntityToken target = Global.getSector().getHyperspace().createToken(loc);
            this.addBehavior(new GBGoTo(20.0f, target, maxBurn));
            this.addBehavior(new GBStayInPlace(0.4f + manager.getRandom().nextFloat() * 0.3f));
            this.addBehavior(new GBStormArea(1500.0f + manager.getRandom().nextFloat() * 500.0f));
            this.addBehavior(new GBStayInPlace(0.4f + manager.getRandom().nextFloat() * 0.3f));
            ++i;
        }
    }
}

