/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.graid;

import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.graid.BaseGroundRaidObjectivePluginImpl;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.loading.IndustrySpecAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Random;

public class DisruptIndustryRaidObjectivePluginImpl
extends BaseGroundRaidObjectivePluginImpl {
    public static float DISRUPTION_DAYS_XP_MULT = 300.0f;
    protected float addedDisruptionDays = 0.0f;

    public DisruptIndustryRaidObjectivePluginImpl(MarketAPI market, Industry target) {
        super(market, target.getId());
        this.setSource(target);
    }

    @Override
    public void setSource(Industry source) {
        super.setSource(source);
    }

    @Override
    public String getQuantityString(int marines) {
        float days = this.source.getDisruptedDays();
        if (days > 0.0f && days < 1.0f) {
            days = 1.0f;
        }
        if ((days = (float)Math.round(days)) > 0.0f) {
            return "" + (int)days;
        }
        return "";
    }

    @Override
    public Color getQuantityColor(int marines) {
        return Misc.getHighlightColor();
    }

    @Override
    public int getDisruptionDaysSort(int marines) {
        marines = Math.max(1, marines);
        return (int)this.getBaseDisruptDuration(marines);
    }

    @Override
    public String getDisruptionDaysString(int marines) {
        marines = Math.max(1, marines);
        return "" + (int)this.getBaseDisruptDuration(marines);
    }

    @Override
    public float getQuantity(int marines) {
        return 0.0f;
    }

    @Override
    public int getValue(int marines) {
        return 0;
    }

    @Override
    public int getProjectedCreditsValue() {
        return 0;
    }

    public IndustrySpecAPI getSpec() {
        return this.getSource().getSpec();
    }

    @Override
    public MarketCMD.RaidDangerLevel getDangerLevel() {
        MarketCMD.RaidDangerLevel level = this.getSpec().getDisruptDanger();
        return level;
    }

    @Override
    public float getQuantitySortValue() {
        IndustrySpecAPI spec = this.getSpec();
        float add = spec.getOrder();
        return 1.1E8f + add + 1000.0f;
    }

    @Override
    public String getName() {
        return this.getSource().getCurrentName();
    }

    @Override
    public String getIconName() {
        return this.getSource().getCurrentImage();
    }

    public float getAddedDisruptionDays() {
        return this.addedDisruptionDays;
    }

    public void setAddedDisruptionDays(float addedDisruptionDays) {
        this.addedDisruptionDays = addedDisruptionDays;
    }

    @Override
    public int performRaid(CargoAPI loot, Random random, float lootMult, TextPanelAPI text) {
        if (this.marinesAssigned <= 0) {
            return 0;
        }
        float dur = this.getBaseDisruptDuration(this.marinesAssigned);
        dur *= lootMult;
        if ((dur *= StarSystemGenerator.getNormalRandom(random, 1.0f, 1.1f)) < 2.0f) {
            dur = 2.0f;
        }
        float already = this.source.getDisruptedDays();
        this.source.setDisrupted(already + dur);
        this.addedDisruptionDays = dur;
        text.addPara("The raid was successful in disrupting " + this.source.getCurrentName() + " operations." + " It will take at least %s days for normal operations to resume.", Misc.getHighlightColor(), "" + Math.round(this.source.getDisruptedDays()));
        int xpGained = (int)(dur * DISRUPTION_DAYS_XP_MULT);
        return xpGained;
    }

    public float getBaseDisruptDuration(int marines) {
        if (marines <= 0) {
            return 0.0f;
        }
        float already = this.source.getDisruptedDays();
        float dur = (float)marines * this.source.getSpec().getDisruptDanger().disruptionDays;
        dur *= dur / (dur + already);
        return dur;
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @Override
    public float getTooltipWidth() {
        return this.getSource().getTooltipWidth();
    }

    @Override
    public void createTooltip(TooltipMakerAPI t, boolean expanded) {
        this.getSource().createTooltip(Industry.IndustryTooltipMode.NORMAL, t, expanded);
    }
}

